/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mojang.authlib.GameProfile;
import com.mumfrey.liteloader.client.ClientEvents;
import com.mumfrey.liteloader.transformers.event.EventInfo;
import com.mumfrey.liteloader.transformers.event.ReturnEventInfo;
import net.minecraft.server.MinecraftServer;

public class CallbackProxyClient {
    private static boolean clock = false;
    private static ClientEvents events;
    private static boolean fboEnabled;
    private static boolean renderingFBO;

    public static void onStartupComplete(EventInfo<bao> e) {
        events = ClientEvents.getInstance();
        if (events == null) {
            throw new RuntimeException("LiteLoader failed to start up properly. The game is in an unstable state and must shut down now. Check the developer log for startup errors");
        }
        events.onStartupComplete();
    }

    public static void onTimerUpdate(EventInfo<bao> e) {
        events.onTimerUpdate();
    }

    public static void newTick(EventInfo<bao> e) {
        clock = true;
    }

    public static void onTick(EventInfo<bao> e) {
        events.onTick(clock);
        clock = false;
    }

    public static void onRender(EventInfo<bao> e) {
        events.onRender();
    }

    public static void preRenderGUI(EventInfo<blt> e, float partialTicks) {
        events.preRenderGUI(partialTicks);
    }

    public static void onSetupCameraTransform(EventInfo<blt> e, float partialTicks, long timeSlice) {
        events.onSetupCameraTransform(partialTicks, timeSlice);
    }

    public static void postRenderEntities(EventInfo<blt> e, float partialTicks, long timeSlice) {
        events.postRenderEntities(partialTicks, timeSlice);
    }

    public static void postRender(EventInfo<blt> e, float partialTicks, long timeSlice) {
        events.postRender(partialTicks, timeSlice);
    }

    public static void onRenderHUD(EventInfo<blt> e, float partialTicks) {
        events.onRenderHUD(partialTicks);
    }

    public static void onRenderChat(EventInfo<bbv> e, float partialTicks, boolean guiActive, int mouseX, int mouseY) {
        events.onRenderChat(e.getSource().b(), partialTicks, guiActive, mouseX, mouseY);
    }

    public static void postRenderChat(EventInfo<bbv> e, float partialTicks, boolean guiActive, int mouseX, int mouseY) {
        events.postRenderChat(e.getSource().b(), partialTicks, guiActive, mouseX, mouseY);
    }

    public static void postRenderHUD(EventInfo<blt> e, float partialTicks) {
        events.postRenderHUD(partialTicks);
    }

    public static void IntegratedServerCtor(EventInfo<bsx> e, bao minecraft, String folderName, String worldName, ahj worldSettings) {
        events.onStartServer((MinecraftServer)e.getSource(), folderName, worldName, worldSettings);
    }

    public static void onInitializePlayerConnection(EventInfo<oi> e, ej netManager, mw player) {
        events.onInitializePlayerConnection(e.getSource(), netManager, player);
    }

    public static void onPlayerLogin(EventInfo<oi> e, mw player) {
        events.onPlayerLogin(e.getSource(), player);
    }

    public static void onPlayerLogout(EventInfo<oi> e, mw player) {
        events.onPlayerLogout(e.getSource(), player);
    }

    public static void onSpawnPlayer(ReturnEventInfo<oi, mw> e, GameProfile profile) {
        events.onSpawnPlayer((oi)e.getSource(), e.getReturnValue(), profile);
    }

    public static void onRespawnPlayer(ReturnEventInfo<oi, mw> e, mw oldPlayer, int dimension, boolean won) {
        events.onRespawnPlayer((oi)e.getSource(), e.getReturnValue(), oldPlayer, dimension, won);
    }

    public static void onOutboundChat(EventInfo<bjk> e, String message) {
        events.onSendChatMessage(e, message);
    }

    public static void onResize(EventInfo<bao> e) {
        if (events == null) {
            return;
        }
        events.onResize(e.getSource());
    }

    public static void preRenderFBO(EventInfo<bao> e) {
        if (events == null) {
            return;
        }
        fboEnabled = buu.g();
        if (fboEnabled) {
            renderingFBO = true;
            events.preRenderFBO(e.getSource().a());
        }
    }

    public static void postRenderFBO(EventInfo<bao> e) {
        if (events == null) {
            return;
        }
        renderingFBO = false;
        if (fboEnabled) {
            events.postRenderFBO(e.getSource().a());
        }
    }

    public static void renderFBO(EventInfo<bmg> e, int width, int height) {
        if (events == null) {
            return;
        }
        if (renderingFBO) {
            events.onRenderFBO(e.getSource(), width, height);
        }
        renderingFBO = false;
    }

    public static void onRenderWorld(EventInfo<blt> e, float partialTicks, long timeSlice) {
        events.onRenderWorld(partialTicks, timeSlice);
    }
}

