/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.client;

import com.mumfrey.liteloader.client.gui.GuiLiteLoaderPanel;
import com.mumfrey.liteloader.common.GameEngine;
import com.mumfrey.liteloader.core.LiteLoaderMods;
import com.mumfrey.liteloader.core.LiteLoaderUpdateSite;
import com.mumfrey.liteloader.core.LiteLoaderVersion;
import com.mumfrey.liteloader.interfaces.PanelManager;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.modconfig.ConfigManager;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import org.lwjgl.input.Keyboard;

public class LiteLoaderPanelManager
implements PanelManager<bdw> {
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private LiteLoaderMods mods;
    private ConfigManager configManager;
    private bao minecraft;
    private boolean displayModInfoScreenTab = true;
    private boolean tabAlwaysExpanded = false;
    private boolean hideModInfoScreenTab = false;
    private boolean checkForUpdate = false;
    private String notification;
    private GuiLiteLoaderPanel panelHost;

    public LiteLoaderPanelManager(GameEngine<?, ?> engine, LoaderEnvironment environment, LoaderProperties properties) {
        this.environment = environment;
        this.properties = properties;
        this.minecraft = (bao)engine.getClient();
        this.displayModInfoScreenTab = this.properties.getAndStoreBooleanProperty("modInfoScreen", true);
        this.tabAlwaysExpanded = this.properties.getAndStoreBooleanProperty("tabAlwaysExpanded", false);
        if (this.properties.getAndStoreBooleanProperty("allowForceUpdate", false)) {
            int updateCheckInterval = this.properties.getIntegerProperty("updateCheckInterval") + 1;
            LiteLoaderLogger.debug("Force update is TRUE, updateCheckInterval = %d", updateCheckInterval);
            if (updateCheckInterval > 10) {
                LiteLoaderLogger.debug("Forcing update check!", new Object[0]);
                this.checkForUpdate = true;
                updateCheckInterval = 0;
            }
            this.properties.setIntegerProperty("updateCheckInterval", updateCheckInterval);
            this.properties.writeProperties();
        }
    }

    @Override
    public void init(LiteLoaderMods mods, ConfigManager configManager) {
        this.mods = mods;
        this.configManager = configManager;
    }

    @Override
    public void onStartupComplete() {
        if (this.checkForUpdate) {
            LiteLoaderVersion.getUpdateSite().beginUpdateCheck();
        }
    }

    @Override
    public void onTick(boolean clock, float partialTicks, boolean inGame) {
        LiteLoaderUpdateSite updateSite;
        if (clock && this.panelHost != null && this.minecraft.n != this.panelHost) {
            this.panelHost.e();
        }
        if (clock && this.checkForUpdate && !(updateSite = LiteLoaderVersion.getUpdateSite()).isCheckInProgress() && updateSite.isCheckComplete()) {
            LiteLoaderLogger.debug("Scheduled update check completed, success=%s", updateSite.isCheckSucceess());
            this.checkForUpdate = false;
            if (updateSite.isCheckSucceess() && updateSite.isUpdateAvailable()) {
                this.setNotification(brp.a((String)"gui.notifications.updateavailable", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public void onPostRender(int mouseX, int mouseY, float partialTicks) {
        boolean tabHidden;
        if (this.mods == null) {
            return;
        }
        boolean bl2 = tabHidden = this.isTabHidden() && this.minecraft.n instanceof bee;
        if (this.isPanelSupportedOnScreen(this.minecraft.n) && (this.displayModInfoScreenTab && !tabHidden || this.panelHost != null && this.panelHost.isOpen())) {
            if (this.panelHost == null || this.panelHost.getScreen() != this.minecraft.n) {
                this.panelHost = new GuiLiteLoaderPanel(this.minecraft, this.minecraft.n, this.mods, this.environment, this.properties, this.configManager, !tabHidden);
                if (this.notification != null) {
                    this.panelHost.setNotification(this.notification);
                }
            }
            this.minecraft.p.g();
            this.panelHost.drawScreen(mouseX, mouseY, partialTicks, this.tabAlwaysExpanded);
        } else if (this.minecraft.n != this.panelHost && this.panelHost != null) {
            this.panelHost.release();
            this.panelHost = null;
        } else if (this.isPanelSupportedOnScreen(this.minecraft.n) && Keyboard.isKeyDown((int)29) && Keyboard.isKeyDown((int)42) && Keyboard.isKeyDown((int)15)) {
            this.displayLiteLoaderPanel(this.minecraft.n);
        }
    }

    @Override
    public void hideTab() {
        this.hideModInfoScreenTab = true;
    }

    private boolean isTabHidden() {
        return this.hideModInfoScreenTab && this.getStartupErrorCount() == 0 && this.notification == null;
    }

    @Override
    public void setTabVisible(boolean show) {
        this.displayModInfoScreenTab = show;
        this.properties.setBooleanProperty("modInfoScreen", show);
        this.properties.writeProperties();
    }

    @Override
    public boolean isTabVisible() {
        return this.displayModInfoScreenTab;
    }

    @Override
    public void setTabAlwaysExpanded(boolean expand) {
        this.tabAlwaysExpanded = expand;
        this.properties.setBooleanProperty("tabAlwaysExpanded", expand);
        this.properties.writeProperties();
    }

    @Override
    public boolean isTabAlwaysExpanded() {
        return this.tabAlwaysExpanded;
    }

    @Override
    public void setForceUpdateEnabled(boolean forceUpdate) {
        this.properties.setBooleanProperty("allowForceUpdate", forceUpdate);
        this.properties.writeProperties();
    }

    @Override
    public boolean isForceUpdateEnabled() {
        return this.properties.getBooleanProperty("allowForceUpdate");
    }

    @Override
    public void displayLiteLoaderPanel(bdw parentScreen) {
        if (this.isPanelSupportedOnScreen(parentScreen)) {
            this.panelHost = new GuiLiteLoaderPanel(this.minecraft, parentScreen, this.mods, this.environment, this.properties, this.configManager, !this.isTabHidden());
            this.minecraft.a((bdw)this.panelHost);
        }
    }

    @Override
    public int getStartupErrorCount() {
        return this.mods.getStartupErrorCount();
    }

    @Override
    public int getCriticalErrorCount() {
        return this.mods.getCriticalErrorCount();
    }

    @Override
    public void setNotification(String notification) {
        LiteLoaderLogger.debug("Setting notification: " + notification, new Object[0]);
        this.notification = notification;
        if (this.panelHost != null) {
            this.panelHost.setNotification(notification);
        }
    }

    private boolean isPanelSupportedOnScreen(bdw guiScreen) {
        return guiScreen instanceof bee || guiScreen instanceof bdp || guiScreen instanceof bdm;
    }
}

