/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.google.common.base.Throwables;
import com.mumfrey.liteloader.LiteMod;
import com.mumfrey.liteloader.api.EnumeratorModule;
import com.mumfrey.liteloader.api.LiteAPI;
import com.mumfrey.liteloader.api.manager.APIProvider;
import com.mumfrey.liteloader.core.Mod;
import com.mumfrey.liteloader.core.ModInfo;
import com.mumfrey.liteloader.core.NonMod;
import com.mumfrey.liteloader.core.exceptions.OutdatedLoaderException;
import com.mumfrey.liteloader.interfaces.Loadable;
import com.mumfrey.liteloader.interfaces.LoadableMod;
import com.mumfrey.liteloader.interfaces.LoaderEnumerator;
import com.mumfrey.liteloader.interfaces.TweakContainer;
import com.mumfrey.liteloader.launch.LiteLoaderTweaker;
import com.mumfrey.liteloader.launch.LoaderEnvironment;
import com.mumfrey.liteloader.launch.LoaderProperties;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class LiteLoaderEnumerator
implements LoaderEnumerator {
    private final LoaderEnvironment environment;
    private final LoaderProperties properties;
    private final LiteLoaderTweaker tweaker;
    private final LaunchClassLoader classLoader;
    private final Set<ModInfo<LoadableMod<?>>> modsToLoad = new LinkedHashSet();
    private final Map<String, ModInfo<Loadable<?>>> disabledContainers = new HashMap();
    private final Map<String, LoadableMod<?>> enabledContainers = new HashMap();
    private final Set<LoadableMod<?>> enumeratedContainers = new HashSet();
    private final List<TweakContainer<File>> tweakContainers = new ArrayList<TweakContainer<File>>();
    private final List<ModInfo<Loadable<?>>> injectedTweaks = new ArrayList();
    private final List<EnumeratorModule> modules = new ArrayList<EnumeratorModule>();
    private final String[] supportedPrefixes;
    protected EnumeratorState state = EnumeratorState.INIT;

    public LiteLoaderEnumerator(LoaderEnvironment environment, LoaderProperties properties, LaunchClassLoader classLoader) {
        this.environment = environment;
        this.properties = properties;
        this.tweaker = (LiteLoaderTweaker)environment.getTweaker();
        this.classLoader = classLoader;
        this.supportedPrefixes = this.getSupportedPrefixes(environment);
        this.getSharedModList();
    }

    private String[] getSupportedPrefixes(LoaderEnvironment environment) {
        ArrayList<String> prefixes = new ArrayList<String>();
        for (LiteAPI api : environment.getAPIProvider().getAPIs()) {
            String prefix;
            List<EnumeratorModule> apiModules = api.getEnumeratorModules();
            if (apiModules != null) {
                for (EnumeratorModule module : apiModules) {
                    this.registerModule(module);
                }
            }
            if ((prefix = api.getModClassPrefix()) == null) continue;
            LiteLoaderLogger.info("Adding supported mod class prefix '%s'", prefix);
            prefixes.add(prefix);
        }
        return prefixes.toArray(new String[prefixes.size()]);
    }

    private void checkState(EnumeratorState state, String action) {
        if (this.state != state) {
            throw new IllegalStateException("Illegal enumerator state whilst performing " + action + ", expecting " + (Object)((Object)state) + " but current state is " + (Object)((Object)this.state));
        }
    }

    private void gotoState(EnumeratorState state) {
        if (state.checkGotoState(this.state)) {
            this.state = state;
        }
    }

    public LoaderEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public Map<String, Map<String, String>> getSharedModList() {
        try {
            HashMap sharedModList = (HashMap)Launch.blackboard.get("modList");
            if (sharedModList == null) {
                sharedModList = new HashMap();
                Launch.blackboard.put("modList", sharedModList);
            }
            return sharedModList;
        }
        catch (Exception ex) {
            LiteLoaderLogger.warning("Shared mod list was invalid or not accessible, this isn't especially bad but something isn't quite right", new Object[0]);
            return null;
        }
    }

    @Override
    public void registerModule(EnumeratorModule module) {
        this.checkState(EnumeratorState.INIT, "registerModule");
        if (module != null && !this.modules.contains(module)) {
            LiteLoaderLogger.info("Registering discovery module %s: [%s]", module.getClass().getSimpleName(), module);
            this.modules.add(module);
            module.init(this.environment, this.properties);
        }
    }

    @Override
    public Collection<? extends ModInfo<LoadableMod<?>>> getModsToLoad() {
        this.checkState(EnumeratorState.FINALISED, "getModsToLoad");
        return Collections.unmodifiableSet(this.modsToLoad);
    }

    @Override
    public Collection<? extends ModInfo<Loadable<?>>> getDisabledContainers() {
        this.checkState(EnumeratorState.FINALISED, "getDisabledContainers");
        return this.disabledContainers.values();
    }

    @Override
    public List<? extends ModInfo<Loadable<?>>> getInjectedTweaks() {
        this.checkState(EnumeratorState.FINALISED, "getInjectedTweaks");
        return this.injectedTweaks;
    }

    @Override
    public int modsToLoadCount() {
        return this.modsToLoad.size();
    }

    @Override
    public String getModMetaData(Class<? extends LiteMod> modClass, String metaDataKey, String defaultValue) {
        this.checkState(EnumeratorState.FINALISED, "getModMetaData");
        return this.getContainerForMod(modClass).getMetaValue(metaDataKey, defaultValue);
    }

    @Override
    public LoadableMod<?> getContainer(String identifier) {
        this.checkState(EnumeratorState.FINALISED, "getContainer");
        return this.getContainerById(identifier);
    }

    private LoadableMod<?> getContainerById(String identifier) {
        LoadableMod<?> container = this.enabledContainers.get(identifier);
        return container != null ? container : LoadableMod.NONE;
    }

    @Override
    public LoadableMod<?> getContainer(Class<? extends LiteMod> modClass) {
        this.checkState(EnumeratorState.FINALISED, "getContainer");
        return this.getContainerForMod(modClass);
    }

    private LoadableMod<?> getContainerForMod(Class<? extends LiteMod> modClass) {
        for (ModInfo<LoadableMod<?>> mod : this.modsToLoad) {
            if (!modClass.equals(mod.getModClass())) continue;
            return mod.getContainer();
        }
        return LoadableMod.NONE;
    }

    @Override
    public String getIdentifier(Class<? extends LiteMod> modClass) {
        String modClassName = modClass.getSimpleName();
        for (ModInfo<LoadableMod<?>> mod : this.modsToLoad) {
            if (!modClassName.equals(mod.getModClassSimpleName())) continue;
            return mod.getIdentifier();
        }
        return LiteLoaderEnumerator.getModClassName(modClass);
    }

    @Override
    public void onPreInit() {
        this.discoverContainers();
        this.injectDiscoveredTweaks();
    }

    private void discoverContainers() {
        this.gotoState(EnumeratorState.DISCOVER);
        for (EnumeratorModule module : this.modules) {
            try {
                module.enumerate(this, this.environment.getProfile());
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumerator Module %s encountered an error whilst enumerating", module.getClass().getName());
            }
        }
    }

    private void injectDiscoveredTweaks() {
        this.gotoState(EnumeratorState.INJECT);
        for (TweakContainer<File> tweakContainer : this.tweakContainers) {
            this.addTweaksFrom(tweakContainer);
        }
    }

    @Override
    public void onInit() {
        try {
            this.gotoState(EnumeratorState.INJECT);
            for (EnumeratorModule module : this.modules) {
                try {
                    module.injectIntoClassLoader(this, this.classLoader);
                }
                catch (Throwable th) {
                    LiteLoaderLogger.warning(th, "Enumerator Module %s encountered an error whilst injecting", module.getClass().getName());
                }
            }
            this.gotoState(EnumeratorState.REGISTER);
            for (EnumeratorModule module : this.modules) {
                try {
                    module.registerMods(this, this.classLoader);
                }
                catch (Throwable th) {
                    LiteLoaderLogger.warning(th, "Enumerator Module %s encountered an error whilst registering mods", module.getClass().getName());
                }
            }
            LiteLoaderLogger.info("Mod class discovery completed", new Object[0]);
            this.gotoState(EnumeratorState.FINALISED);
        }
        catch (IllegalStateException ex) {
            Throwables.propagate((Throwable)ex);
        }
        catch (Throwable th) {
            LiteLoaderLogger.warning(th, "Mod class discovery failed", new Object[0]);
        }
    }

    @Override
    public final boolean registerModContainer(LoadableMod<?> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerModContainer");
        if (container != null) {
            if (!container.isEnabled(this.environment)) {
                LiteLoaderLogger.info("Container %s is disabled", container.getLocation());
                this.registerDisabledContainer(container);
                return false;
            }
            if (!this.checkDependencies(container)) {
                LiteLoaderLogger.info("Container %s is missing one or more dependencies", container.getLocation());
                this.registerDisabledContainer(container);
                return false;
            }
            if (!this.checkAPIRequirements(container)) {
                LiteLoaderLogger.info("Container %s is missing one or more required APIs", container.getLocation());
                this.registerDisabledContainer(container);
                return false;
            }
            this.registerEnabledContainer(container);
        }
        return true;
    }

    protected void registerEnabledContainer(LoadableMod<?> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerEnabledContainer");
        this.disabledContainers.remove(container.getIdentifier());
        this.enabledContainers.put(container.getIdentifier(), container);
    }

    protected void registerDisabledContainer(LoadableMod<?> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerDisabledContainer");
        this.enabledContainers.remove(container.getIdentifier());
        this.disabledContainers.put(container.getIdentifier(), new NonMod((Loadable<?>)container, false));
    }

    @Override
    public boolean registerTweakContainer(TweakContainer<File> container) {
        this.checkState(EnumeratorState.DISCOVER, "registerTweakContainer");
        if (!container.isEnabled(this.environment)) {
            LiteLoaderLogger.info("Mod %s is disabled for profile %s, not injecting tranformers", container.getIdentifier(), this.environment.getProfile());
            return false;
        }
        this.tweakContainers.add(container);
        return true;
    }

    private void addTweaksFrom(TweakContainer<File> tweakContainer) {
        this.checkState(EnumeratorState.INJECT, "addTweaksFrom");
        if (this.checkDependencies(tweakContainer)) {
            if (tweakContainer.hasTweakClass()) {
                this.addTweakFrom(tweakContainer);
            }
            if (tweakContainer.hasClassTransformers()) {
                this.addClassTransformersFrom(tweakContainer, tweakContainer.getClassTransformerClassNames());
            }
        }
    }

    private void addTweakFrom(TweakContainer<File> container) {
        try {
            String tweakClass = container.getTweakClassName();
            int tweakPriority = container.getTweakPriority();
            LiteLoaderLogger.info("Mod file '%s' provides tweakClass '%s', adding to Launch queue with priority %d", container.getName(), tweakClass, tweakPriority);
            if (this.tweaker.addCascadedTweaker(tweakClass, tweakPriority)) {
                String[] classPathEntries;
                LiteLoaderLogger.info("tweakClass '%s' was successfully added", tweakClass);
                container.injectIntoClassPath(this.classLoader, true);
                if (container.isExternalJar()) {
                    this.injectedTweaks.add(new NonMod((Loadable<?>)container, true));
                }
                if ((classPathEntries = container.getClassPathEntries()) != null) {
                    for (String classPathEntry : classPathEntries) {
                        try {
                            File classPathJar = new File(this.environment.getGameDirectory(), classPathEntry);
                            URL classPathJarUrl = classPathJar.toURI().toURL();
                            LiteLoaderLogger.info("Adding Class-Path entry: %s", classPathEntry);
                            LiteLoaderTweaker.addURLToParentClassLoader(classPathJarUrl);
                            this.classLoader.addURL(classPathJarUrl);
                        }
                        catch (MalformedURLException ex) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private void addClassTransformersFrom(TweakContainer<File> container, List<String> classTransformerClasses) {
        try {
            for (String classTransformerClass : classTransformerClasses) {
                LiteLoaderLogger.info("Mod file '%s' provides classTransformer '%s', adding to class loader", container.getName(), classTransformerClass);
                if (!this.tweaker.getTransformerManager().injectTransformer(classTransformerClass)) continue;
                LiteLoaderLogger.info("classTransformer '%s' was successfully added", classTransformerClass);
                container.injectIntoClassPath(this.classLoader, true);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void registerModsFrom(LoadableMod<?> container, boolean registerContainer) {
        this.checkState(EnumeratorState.REGISTER, "registerModsFrom");
        if (this.disabledContainers.containsValue(container)) {
            throw new IllegalArgumentException("Attempted to register mods from a disabled container '" + container.getName() + "'");
        }
        if (this.enumeratedContainers.contains(container)) {
            return;
        }
        this.enumeratedContainers.add(container);
        LinkedList<Class<LiteMod>> modClasses = LiteLoaderEnumerator.getSubclassesFor(container, (ClassLoader)this.classLoader, LiteMod.class, this.supportedPrefixes);
        for (Class clazz : modClasses) {
            Mod mod = new Mod(container, clazz);
            this.registerMod(mod);
        }
        if (modClasses.size() > 0) {
            LiteLoaderLogger.info("Found %d potential matches", modClasses.size());
            this.disabledContainers.remove(container.getIdentifier());
            this.enabledContainers.put(container.getIdentifier(), container);
        }
    }

    @Override
    public void registerMod(ModInfo<LoadableMod<?>> mod) {
        this.checkState(EnumeratorState.REGISTER, "registerMod");
        if (this.modsToLoad.contains(mod)) {
            LiteLoaderLogger.warning("Mod name collision for mod with class '%s', maybe you have more than one copy?", mod.getModClassSimpleName());
        }
        this.modsToLoad.add(mod);
    }

    private static <T> LinkedList<Class<? extends T>> getSubclassesFor(LoadableMod<?> container, ClassLoader classloader, Class<T> superClass, String[] supportedPrefixes) {
        LinkedList<Class<T>> classes = new LinkedList<Class<T>>();
        if (container != null) {
            try {
                for (String fullClassName : container.getContainedClassNames()) {
                    String className;
                    boolean isDefaultPackage = fullClassName.lastIndexOf(46) == -1;
                    String string = className = isDefaultPackage ? fullClassName : fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                    if (supportedPrefixes != null && supportedPrefixes.length != 0 && !LiteLoaderEnumerator.startsWithAny(className, supportedPrefixes)) continue;
                    LiteLoaderEnumerator.checkAndAddClass(classloader, superClass, classes, fullClassName);
                }
            }
            catch (OutdatedLoaderException ex) {
                classes.clear();
                LiteLoaderLogger.info("Error searching in '%s', missing API component '%s', your loader is probably out of date", container, ex.getMessage());
            }
            catch (Throwable th) {
                LiteLoaderLogger.warning(th, "Enumeration error", new Object[0]);
            }
        }
        return classes;
    }

    private static <T> void checkAndAddClass(ClassLoader classloader, Class<T> superClass, LinkedList<Class<? extends T>> classes, String className) throws OutdatedLoaderException {
        if (className.indexOf(36) > -1) {
            return;
        }
        try {
            Class<?> subClass = classloader.loadClass(className);
            if (subClass != null && !superClass.equals(subClass) && superClass.isAssignableFrom(subClass) && !subClass.isInterface() && !classes.contains(subClass)) {
                Class<?> matchingClass = subClass;
                classes.add(matchingClass);
            }
        }
        catch (Throwable th) {
            if (th.getCause() != null) {
                String missingClassName = th.getCause().getMessage();
                if (th.getCause() instanceof NoClassDefFoundError && missingClassName != null && missingClassName.startsWith("com/mumfrey/liteloader/")) {
                    throw new OutdatedLoaderException(missingClassName.substring(missingClassName.lastIndexOf(47) + 1));
                }
            }
            LiteLoaderLogger.warning(th, "checkAndAddClass error while checking '%s'", className);
        }
    }

    @Override
    public boolean checkAPIRequirements(LoadableMod<?> container) {
        boolean result = true;
        APIProvider apiProvider = this.environment.getAPIProvider();
        for (String identifier : container.getRequiredAPIs()) {
            if (apiProvider.isAPIAvailable(identifier)) continue;
            container.registerMissingAPI(identifier);
            result = false;
        }
        return result;
    }

    public boolean checkDependencies(TweakContainer<File> tweakContainer) {
        if (tweakContainer instanceof LoadableMod) {
            return this.checkDependencies((LoadableMod)((Object)tweakContainer));
        }
        return true;
    }

    @Override
    public boolean checkDependencies(LoadableMod<?> base) {
        if (base == null || !base.hasDependencies()) {
            return true;
        }
        HashSet<String> circularDependencySet = new HashSet<String>();
        circularDependencySet.add(base.getIdentifier());
        boolean result = this.checkDependencies(base, base, circularDependencySet);
        LiteLoaderLogger.info("Dependency check for %s %s", base.getIdentifier(), result ? "passed" : "failed");
        return result;
    }

    private boolean checkDependencies(LoadableMod<?> base, LoadableMod<?> container, Set<String> circularDependencySet) {
        if (container.getDependencies().size() == 0) {
            return true;
        }
        boolean result = true;
        for (String dependency : container.getDependencies()) {
            if (circularDependencySet.contains(dependency)) continue;
            circularDependencySet.add(dependency);
            LoadableMod<?> dependencyContainer = this.getContainerById(dependency);
            if (dependencyContainer != LoadableMod.NONE) {
                if (this.environment.getEnabledModsList().isEnabled(this.environment.getProfile(), dependency)) {
                    result &= this.checkDependencies(base, dependencyContainer, circularDependencySet);
                    continue;
                }
                base.registerMissingDependency(dependency);
                result = false;
                continue;
            }
            base.registerMissingDependency(dependency);
            result = false;
        }
        return result;
    }

    public static String getModClassName(LiteMod mod) {
        return LiteLoaderEnumerator.getModClassName(mod.getClass());
    }

    public static String getModClassName(Class<? extends LiteMod> mod) {
        return mod.getSimpleName().substring(7);
    }

    private static boolean startsWithAny(String string, String[] candidates) {
        for (String candidate : candidates) {
            if (!string.startsWith(candidate)) continue;
            return true;
        }
        return false;
    }

    public static enum EnumeratorState {
        INIT(null),
        DISCOVER(INIT),
        INJECT(DISCOVER),
        REGISTER(INJECT),
        FINALISED(REGISTER);

        private final EnumeratorState previousState;

        private EnumeratorState(EnumeratorState previousState) {
            this.previousState = previousState;
        }

        public boolean checkGotoState(EnumeratorState fromState) {
            if (fromState != this && fromState != this.previousState) {
                throw new IllegalStateException("Attempted to move to an invalid enumerator state " + (Object)((Object)this) + ", expected to be in state " + (Object)((Object)this.previousState) + " but current state is " + (Object)((Object)fromState));
            }
            return true;
        }
    }
}

