/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.messaging;

import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.messaging.Message;
import com.mumfrey.liteloader.messaging.Messenger;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MessageBus
implements InterfaceProvider {
    private static MessageBus instance;
    private final Map<String, FastIterable<Messenger>> messengers = new HashMap<String, FastIterable<Messenger>>();
    private final Deque<Message> messageQueue = new LinkedList<Message>();
    private boolean enableMessaging = false;

    private MessageBus() {
    }

    public static MessageBus getInstance() {
        if (instance == null) {
            instance = new MessageBus();
        }
        return instance;
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(Messenger.class);
    }

    @Override
    public void initProvider() {
    }

    public void onStartupComplete() {
        this.enableMessaging = true;
        while (this.messageQueue.size() > 0) {
            Message msg = this.messageQueue.pop();
            this.dispatchMessage(msg);
        }
    }

    public void registerMessenger(Messenger messenger) {
        List<String> messageChannels = messenger.getMessageChannels();
        if (messageChannels == null) {
            LiteLoaderLogger.warning("Listener %s returned a null channel list for getMessageChannels(), this could indicate a problem with the listener", messenger.getName());
            return;
        }
        for (String channel : messageChannels) {
            if (channel != null && Message.isValidChannel(channel)) {
                LiteLoaderLogger.info("Listener %s is registering MessageBus channel %s", messenger.getName(), channel);
                this.getMessengerList(channel).add(messenger);
                continue;
            }
            LiteLoaderLogger.warning("Listener %s tried to register invalid MessageBus channel %s", messenger.getName(), channel);
        }
    }

    private void sendMessage(Message message) {
        if (this.enableMessaging) {
            this.dispatchMessage(message);
            return;
        }
        this.messageQueue.push(message);
    }

    private void dispatchMessage(Message message) {
        try {
            FastIterable<Messenger> messengerList = this.messengers.get(message.getChannel());
            if (messengerList != null) {
                messengerList.all().receiveMessage(message);
            }
        }
        catch (StackOverflowError err) {
            throw new RuntimeException("Stack overflow encountered dispatching message on channel '" + message.getChannel() + "'. Did you reply to yourself?");
        }
    }

    private FastIterable<Messenger> getMessengerList(String channel) {
        FastIterable<Messenger> messengerList = this.messengers.get(channel);
        if (messengerList == null) {
            messengerList = new HandlerList<Messenger>(Messenger.class);
            this.messengers.put(channel, messengerList);
        }
        return messengerList;
    }

    public static void send(String channel) {
        Message message = new Message(channel, null, null);
        MessageBus.getInstance().sendMessage(message);
    }

    public static void send(String channel, String value) {
        Message message = new Message(channel, value, null);
        MessageBus.getInstance().sendMessage(message);
    }

    public static void send(String channel, String value, Messenger sender) {
        Message message = new Message(channel, value, sender);
        MessageBus.getInstance().sendMessage(message);
    }

    public static void send(String channel, String value, Messenger sender, String replyChannel) {
        Message message = new Message(channel, value, sender, replyChannel);
        MessageBus.getInstance().sendMessage(message);
    }

    public static void send(String channel, Map<String, ?> payload) {
        Message message = new Message(channel, payload, null);
        MessageBus.getInstance().sendMessage(message);
    }

    public static void send(String channel, Map<String, ?> payload, Messenger sender) {
        Message message = new Message(channel, payload, sender);
        MessageBus.getInstance().sendMessage(message);
    }

    public static void send(String channel, Map<String, ?> payload, Messenger sender, String replyChannel) {
        Message message = new Message(channel, payload, sender, replyChannel);
        MessageBus.getInstance().sendMessage(message);
    }
}

