/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event;

import com.mumfrey.liteloader.core.runtime.Obf;
import com.mumfrey.liteloader.transformers.event.EventAlreadyInjectedException;
import com.mumfrey.liteloader.transformers.event.EventInfo;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.transformers.event.ReturnEventInfo;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Event
implements Comparable<Event> {
    private static int eventOrder = 0;
    private static final Set<Event> events = new HashSet<Event>();
    private static final List<Map<MethodNode, List<Event>>> proxyHandlerMethods = new ArrayList<Map<MethodNode, List<Event>>>();
    private static int proxyInnerClassIndex = 1;
    protected final String name;
    protected final boolean cancellable;
    private final int order;
    private final int priority;
    private Set<MethodInfo> listeners = new HashSet<MethodInfo>();
    protected MethodNode method;
    protected String eventDescriptor;
    protected int methodMAXS = 0;
    protected boolean methodIsStatic;
    protected Type methodReturnType;
    protected String eventInfoClass;
    protected Set<MethodInfo> pendingInjections;

    protected Event(String name, boolean cancellable, int priority) {
        this.name = name.toLowerCase();
        this.priority = priority;
        this.order = eventOrder++;
        this.cancellable = cancellable;
        if (events.contains(this)) {
            throw new IllegalArgumentException("Event " + name + " is already defined");
        }
        events.add(this);
    }

    public static Event getOrCreate(String name) {
        return Event.getOrCreate(name, false, 1000, false);
    }

    public static Event getOrCreate(String name, boolean cancellable) {
        return Event.getOrCreate(name, cancellable, 1000, true);
    }

    public static Event getOrCreate(String name, boolean cancellable, int priority) {
        return Event.getOrCreate(name, cancellable, priority, true);
    }

    protected static Event getOrCreate(String name, boolean cancellable, int priority, boolean defining) {
        Event event = Event.getEvent(name);
        if (event != null) {
            if (!event.cancellable && cancellable && defining) {
                throw new IllegalArgumentException("Attempted to define the event " + event.name + " with cancellable '" + cancellable + "' but the event is already defined with cancellable is '" + event.cancellable + "'");
            }
            return event;
        }
        return new Event(name, cancellable, priority);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isAttached() {
        return this.method != null;
    }

    void attach(MethodNode method) {
        if (this.method != null) {
            throw new IllegalStateException("Attempted to attach the event " + this.name + " to " + method.name + " but the event was already attached to " + this.method.name + "!");
        }
        this.method = method;
        this.methodReturnType = Type.getReturnType((String)method.desc);
        this.methodMAXS = method.maxStack;
        this.methodIsStatic = (method.access & 8) == 8;
        this.eventInfoClass = this.getEventInfoClassName();
        this.eventDescriptor = String.format("(L%s;%s)V", this.eventInfoClass, method.desc.substring(1, method.desc.indexOf(41)));
    }

    void detach() {
        this.method = null;
    }

    void addPendingInjection(MethodInfo targetMethod) {
        if (this.pendingInjections == null) {
            this.pendingInjections = new HashSet<MethodInfo>();
        }
        this.pendingInjections.add(targetMethod);
    }

    void notifyInjected(String method, String desc, String className) {
        MethodInfo thisInjection = null;
        if (this.pendingInjections != null) {
            for (MethodInfo pendingInjection : this.pendingInjections) {
                if (!pendingInjection.matches(method, desc, className)) continue;
                thisInjection = pendingInjection;
                break;
            }
        }
        if (thisInjection != null) {
            this.pendingInjections.remove(thisInjection);
        }
    }

    protected void validate(AbstractInsnNode injectionPoint, boolean cancellable, int globalEventID) {
        if (this.method == null) {
            throw new IllegalStateException("Attempted to inject the event " + this.name + " but the event is not attached!");
        }
    }

    final MethodNode inject(AbstractInsnNode injectionPoint, boolean cancellable, int globalEventID) {
        this.validate(injectionPoint, cancellable, globalEventID);
        MethodNode handler = new MethodNode(4105, Event.getHandlerName(globalEventID), this.eventDescriptor, null, null);
        Event.addMethodToActiveProxy(handler);
        LiteLoaderLogger.debug("Event %s is spawning handler %s in class %s", this.name, handler.name, Event.getActiveProxyRef());
        Type[] argumentTypes = Type.getArgumentTypes((String)this.method.desc);
        int ctorMAXS = 0;
        int invokeMAXS = argumentTypes.length;
        int eventInfoVar = this.method.maxLocals++;
        InsnList insns = new InsnList();
        insns.add((AbstractInsnNode)new TypeInsnNode(187, this.eventInfoClass));
        ++ctorMAXS;
        insns.add((AbstractInsnNode)new InsnNode(89));
        ++ctorMAXS;
        ++invokeMAXS;
        ctorMAXS += this.invokeEventInfoConstructor(insns, cancellable);
        insns.add((AbstractInsnNode)new VarInsnNode(58, eventInfoVar));
        insns.add((AbstractInsnNode)new VarInsnNode(25, eventInfoVar));
        Event.pushArgs(argumentTypes, insns, this.methodIsStatic);
        insns.add((AbstractInsnNode)new MethodInsnNode(184, Event.getActiveProxyRef(), handler.name, handler.desc, false));
        if (cancellable) {
            this.injectCancellationCode(insns, injectionPoint, eventInfoVar);
        }
        this.method.instructions.insertBefore(injectionPoint, insns);
        this.method.maxStack = Math.max(this.method.maxStack, Math.max(this.methodMAXS + ctorMAXS, this.methodMAXS + invokeMAXS));
        return handler;
    }

    protected int invokeEventInfoConstructor(InsnList insns, boolean cancellable) {
        int ctorMAXS = 0;
        insns.add((AbstractInsnNode)new LdcInsnNode((Object)this.name));
        ++ctorMAXS;
        insns.add((AbstractInsnNode)(this.methodIsStatic ? new InsnNode(1) : new VarInsnNode(25, 0)));
        ++ctorMAXS;
        insns.add((AbstractInsnNode)new InsnNode(cancellable ? 4 : 3));
        insns.add((AbstractInsnNode)new MethodInsnNode(183, this.eventInfoClass, Obf.constructor.name, EventInfo.getConstructorDescriptor(), false));
        return ++ctorMAXS;
    }

    protected String getEventInfoClassName() {
        return EventInfo.getEventInfoClassName(this.methodReturnType).replace('.', '/');
    }

    protected void injectCancellationCode(InsnList insns, AbstractInsnNode injectionPoint, int eventInfoVar) {
        insns.add((AbstractInsnNode)new VarInsnNode(25, eventInfoVar));
        insns.add((AbstractInsnNode)new MethodInsnNode(182, this.eventInfoClass, EventInfo.getIsCancelledMethodName(), EventInfo.getIsCancelledMethodSig(), false));
        LabelNode notCancelled = new LabelNode();
        insns.add((AbstractInsnNode)new JumpInsnNode(153, notCancelled));
        this.injectReturnCode(insns, injectionPoint, eventInfoVar);
        insns.add((AbstractInsnNode)notCancelled);
    }

    protected void injectReturnCode(InsnList insns, AbstractInsnNode injectionPoint, int eventInfoVar) {
        if (this.methodReturnType.equals((Object)Type.VOID_TYPE)) {
            insns.add((AbstractInsnNode)new InsnNode(177));
        } else {
            insns.add((AbstractInsnNode)new VarInsnNode(25, eventInfoVar));
            String accessor = ReturnEventInfo.getReturnAccessor(this.methodReturnType);
            String descriptor = ReturnEventInfo.getReturnDescriptor(this.methodReturnType);
            insns.add((AbstractInsnNode)new MethodInsnNode(182, this.eventInfoClass, accessor, descriptor, false));
            if (this.methodReturnType.getSort() == 10) {
                insns.add((AbstractInsnNode)new TypeInsnNode(192, this.methodReturnType.getInternalName()));
            }
            insns.add((AbstractInsnNode)new InsnNode(this.methodReturnType.getOpcode(172)));
        }
    }

    void addToHandler(MethodNode handler) {
        LiteLoaderLogger.debug("Adding event %s to handler %s", this.name, handler.name);
        Event.getEventsForHandlerMethod(handler).add(this);
    }

    public Event addListener(MethodInfo listener) {
        if (listener.hasDesc()) {
            throw new IllegalArgumentException("Descriptor is not allowed for listener methods");
        }
        if (this.pendingInjections != null && this.pendingInjections.size() == 0) {
            throw new EventAlreadyInjectedException("The event " + this.name + " was already injected and has 0 pending injections, addListener() is not allowed at this point");
        }
        this.listeners.add(listener);
        return this;
    }

    static Event getEvent(String eventName) {
        for (Event event : events) {
            if (!event.name.equalsIgnoreCase(eventName)) continue;
            return event;
        }
        return null;
    }

    static Set<MethodInfo> getEventListeners(String eventName) {
        return Event.getEventListeners(Event.getEvent(eventName));
    }

    static Set<MethodInfo> getEventListeners(Event event) {
        return event == null ? null : Collections.unmodifiableSet(event.listeners);
    }

    static ClassNode populateProxy(ClassNode classNode, int proxyIndex) {
        int handlerCount = 0;
        int invokeCount = 0;
        int lineNumber = proxyIndex < 2 ? 210 : 10;
        LiteLoaderLogger.info("Generating new Event Handler Proxy Class %s", classNode.name.replace('/', '.'));
        Map<MethodNode, List<Event>> handlerMethods = proxyHandlerMethods.get(proxyInnerClassIndex);
        ++proxyInnerClassIndex;
        for (Map.Entry<MethodNode, List<Event>> handler : handlerMethods.entrySet()) {
            MethodNode handlerMethod = handler.getKey();
            List<Event> handlerEvents = handler.getValue();
            Type[] args = Type.getArgumentTypes((String)handlerMethod.desc);
            classNode.methods.add(handlerMethod);
            ++handlerCount;
            InsnList insns = handlerMethod.instructions;
            for (Event event : handlerEvents) {
                Set<MethodInfo> listeners = event.listeners;
                if (listeners.size() <= 0) continue;
                LabelNode tryCatchStart = new LabelNode();
                LabelNode tryCatchEnd = new LabelNode();
                LabelNode tryCatchHandler1 = new LabelNode();
                LabelNode tryCatchHandler2 = new LabelNode();
                LabelNode tryCatchExit = new LabelNode();
                handlerMethod.tryCatchBlocks.add(new TryCatchBlockNode(tryCatchStart, tryCatchEnd, tryCatchHandler1, "java/lang/NoSuchMethodError"));
                handlerMethod.tryCatchBlocks.add(new TryCatchBlockNode(tryCatchStart, tryCatchEnd, tryCatchHandler2, "java/lang/NoClassDefFoundError"));
                insns.add((AbstractInsnNode)tryCatchStart);
                for (MethodInfo listener : listeners) {
                    ++invokeCount;
                    LabelNode lineNumberLabel = new LabelNode(new Label());
                    insns.add((AbstractInsnNode)lineNumberLabel);
                    insns.add((AbstractInsnNode)new LineNumberNode(++lineNumber, lineNumberLabel));
                    Event.pushArgs(args, insns, true);
                    insns.add((AbstractInsnNode)new MethodInsnNode(184, listener.ownerRef, listener.getOrInflectName(event.name), handlerMethod.desc, false));
                }
                insns.add((AbstractInsnNode)tryCatchEnd);
                insns.add((AbstractInsnNode)new JumpInsnNode(167, tryCatchExit));
                insns.add((AbstractInsnNode)tryCatchHandler1);
                insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insns.add((AbstractInsnNode)new MethodInsnNode(184, Obf.EventProxy.ref, "onMissingHandler", "(Ljava/lang/Error;Lcom/mumfrey/liteloader/transformers/event/EventInfo;)V", false));
                insns.add((AbstractInsnNode)new JumpInsnNode(167, tryCatchExit));
                insns.add((AbstractInsnNode)tryCatchHandler2);
                insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insns.add((AbstractInsnNode)new MethodInsnNode(184, Obf.EventProxy.ref, "onMissingClass", "(Ljava/lang/Error;Lcom/mumfrey/liteloader/transformers/event/EventInfo;)V", false));
                insns.add((AbstractInsnNode)new JumpInsnNode(167, tryCatchExit));
                insns.add((AbstractInsnNode)tryCatchExit);
            }
            insns.add((AbstractInsnNode)new InsnNode(177));
        }
        LiteLoaderLogger.info("Successfully generated event handler proxy class with %d handlers(s) and %d total invokations", handlerCount, invokeCount);
        return classNode;
    }

    private static List<Event> addMethodToActiveProxy(MethodNode handlerMethod) {
        while (proxyHandlerMethods.size() < proxyInnerClassIndex + 1) {
            proxyHandlerMethods.add(new LinkedHashMap());
        }
        ArrayList<Event> events = new ArrayList<Event>();
        proxyHandlerMethods.get(proxyInnerClassIndex).put(handlerMethod, events);
        return events;
    }

    private static List<Event> getEventsForHandlerMethod(MethodNode handlerMethod) {
        for (Map<MethodNode, List<Event>> handlers : proxyHandlerMethods) {
            List<Event> events = handlers.get(handlerMethod);
            if (events == null) continue;
            return events;
        }
        return Event.addMethodToActiveProxy(handlerMethod);
    }

    private static String getHandlerName(int globalEventID) {
        return String.format("$event%05x", globalEventID);
    }

    private static String getActiveProxyRef() {
        return Obf.EventProxy.ref + (proxyInnerClassIndex > 1 ? "$" + proxyInnerClassIndex : "");
    }

    private static void pushArgs(Type[] args, InsnList insns, boolean isStatic) {
        int argNumber = isStatic ? 0 : 1;
        for (Type type : args) {
            insns.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), argNumber));
            argNumber += type.getSize();
        }
    }

    @Override
    public int compareTo(Event other) {
        if (other == null) {
            return 0;
        }
        if (other.priority == this.priority) {
            return this.order - other.order;
        }
        return this.priority - other.priority;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Event) {
            return ((Event)other).name.equals(this.name);
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

