/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.transformers.event.inject;

import com.mumfrey.liteloader.transformers.event.Event;
import com.mumfrey.liteloader.transformers.event.InjectionPoint;
import com.mumfrey.liteloader.transformers.event.MethodInfo;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;

public class BeforeInvoke
extends InjectionPoint {
    protected final String[] methodNames;
    protected final String[] methodOwners;
    protected final String[] methodSignatures;
    protected final int ordinal;
    protected boolean logging = false;

    public BeforeInvoke(String ... methodNames) {
        this(methodNames, null, -1);
    }

    public BeforeInvoke(String methodName, int ordinal) {
        this(new String[]{methodName}, null, null, ordinal);
    }

    public BeforeInvoke(String[] methodNames, int ordinal) {
        this(methodNames, null, null, ordinal);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners) {
        this(methodNames, methodOwners, null, -1);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners, int ordinal) {
        this(methodNames, methodOwners, null, ordinal);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners, String[] methodSignatures) {
        this(methodNames, methodOwners, methodSignatures, -1);
    }

    public BeforeInvoke(String[] methodNames, String[] methodOwners, String[] methodSignatures, int ordinal) {
        if (methodNames == null || methodNames.length == 0) {
            throw new IllegalArgumentException("Method name selector must not be null");
        }
        if (methodSignatures != null && methodSignatures.length == 0) {
            methodSignatures = null;
        }
        if (methodOwners != null && methodOwners.length == 0) {
            methodOwners = null;
        }
        if (ordinal < 0) {
            ordinal = -1;
        }
        this.methodNames = methodNames;
        this.methodOwners = methodOwners;
        this.methodSignatures = methodSignatures;
        this.ordinal = ordinal;
    }

    public BeforeInvoke(MethodInfo method) {
        this(method, -1);
    }

    public BeforeInvoke(MethodInfo method, int ordinal) {
        int i;
        this.methodNames = method.getNames();
        this.methodOwners = method.getOwners();
        this.methodSignatures = method.getDescriptors();
        this.ordinal = ordinal;
        for (i = 0; i < this.methodOwners.length; ++i) {
            if (this.methodOwners[i] == null) continue;
            this.methodOwners[i] = this.methodOwners[i].replace('.', '/');
        }
        for (i = 0; i < this.methodSignatures.length; ++i) {
            if (this.methodSignatures[i] == null) continue;
            this.methodSignatures[i] = this.methodSignatures[i].replace('.', '/');
        }
    }

    public BeforeInvoke setLogging(boolean logging) {
        this.logging = logging;
        return this;
    }

    @Override
    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes, Event event) {
        int ordinal = 0;
        boolean found = false;
        if (this.logging) {
            LiteLoaderLogger.debug("================================================================================", new Object[0]);
            LiteLoaderLogger.debug("BeforeInvoke is searching for an injection point in method with descriptor %s", desc);
        }
        for (AbstractInsnNode insn : insns) {
            if (insn instanceof MethodInsnNode) {
                int index;
                MethodInsnNode node = (MethodInsnNode)insn;
                if (this.logging) {
                    LiteLoaderLogger.debug("BeforeInvoke is considering invokation NAME=%s DESC=%s OWNER=%s", node.name, node.desc, node.owner);
                }
                if ((index = BeforeInvoke.arrayIndexOf(this.methodNames, node.name, -1)) > -1 && this.logging) {
                    LiteLoaderLogger.debug("BeforeInvoke   found a matching invoke, checking owner/signature...", new Object[0]);
                }
                int ownerIndex = BeforeInvoke.arrayIndexOf(this.methodOwners, node.owner, index);
                int descIndex = BeforeInvoke.arrayIndexOf(this.methodSignatures, node.desc, index);
                if (index > -1 && ownerIndex == index && descIndex == index) {
                    if (this.logging) {
                        LiteLoaderLogger.debug("BeforeInvoke     found a matching invoke, checking preconditions...", new Object[0]);
                    }
                    if (this.matchesInsn(node, ordinal)) {
                        if (this.logging) {
                            LiteLoaderLogger.debug("BeforeInvoke         found a matching invoke at ordinal %d", ordinal);
                        }
                        nodes.add((AbstractInsnNode)node);
                        found = true;
                        if (this.ordinal == ordinal) break;
                    }
                    ++ordinal;
                }
            }
            this.inspectInsn(desc, insns, insn);
        }
        if (this.logging) {
            LiteLoaderLogger.debug("================================================================================", new Object[0]);
        }
        return found;
    }

    protected void inspectInsn(String desc, InsnList insns, AbstractInsnNode insn) {
    }

    protected boolean matchesInsn(MethodInsnNode node, int ordinal) {
        if (this.logging) {
            LiteLoaderLogger.debug("BeforeInvoke       comparing target ordinal %d with current ordinal %d", this.ordinal, ordinal);
        }
        return this.ordinal == -1 || this.ordinal == ordinal;
    }

    private static int arrayIndexOf(String[] haystack, String needle, int pos) {
        if (haystack == null) {
            return pos;
        }
        if (pos > -1 && pos < haystack.length && needle.equals(haystack[pos])) {
            return pos;
        }
        for (int index = 0; index < haystack.length; ++index) {
            if (!needle.equals(haystack[index])) continue;
            return index;
        }
        return -1;
    }
}

