/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.Bookshelf;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.buff.BuffHelper;
import net.darkhax.bookshelf.common.network.packet.PacketAddPlayerProperties;
import net.darkhax.bookshelf.common.network.packet.PacketRemovePlayerProperties;
import net.darkhax.bookshelf.common.network.packet.PacketSyncPlayerProperties;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class EntityProperties
implements IExtendedEntityProperties {
    public static final String PROP_NAME = "BookshelfData";
    public final EntityLivingBase entity;
    private List<BuffEffect> buffs = new ArrayList<BuffEffect>();

    private EntityProperties(EntityLivingBase entity) {
        this.entity = entity;
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound entityData = new NBTTagCompound();
        entityData.func_74782_a("BookshelfBuff", (NBTBase)BuffHelper.writeNBT(this.buffs));
        compound.func_74782_a(PROP_NAME, (NBTBase)entityData);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound playerData = compound.func_74775_l(PROP_NAME);
        this.buffs = BuffHelper.readNBT(playerData.func_150295_c("BookshelfBuff", 10));
    }

    public void init(Entity entity, World world) {
    }

    public void sync(boolean forced) {
        if (!this.buffs.isEmpty() || forced) {
            Bookshelf.network.sendToAllAround((IMessage)new PacketSyncPlayerProperties(this), new NetworkRegistry.TargetPoint(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 150.0));
        }
    }

    public static EntityProperties getProperties(EntityLivingBase entity) {
        return (EntityProperties)entity.getExtendedProperties(PROP_NAME);
    }

    public static EntityProperties setProperties(EntityLivingBase entity) {
        entity.registerExtendedProperties(PROP_NAME, (IExtendedEntityProperties)new EntityProperties(entity));
        return EntityProperties.getProperties(entity);
    }

    public static boolean hasProperties(EntityLivingBase entity) {
        return EntityProperties.getProperties(entity) != null;
    }

    public List<BuffEffect> getBuffs() {
        return this.buffs;
    }

    public EntityProperties setBuffs(List<BuffEffect> buffs) {
        this.buffs = buffs;
        return this;
    }

    public void remove(BuffEffect buff, boolean isRemote) {
        if (this.buffs != null) {
            BuffEffect ef = null;
            for (BuffEffect buffE : this.buffs) {
                if (!buffE.getBuff().equals(buff.getBuff())) continue;
                ef = buffE;
                break;
            }
            if (ef != null) {
                this.buffs.remove(ef);
                if (!isRemote) {
                    Bookshelf.network.sendToAllAround((IMessage)new PacketRemovePlayerProperties(this.entity, buff), new NetworkRegistry.TargetPoint(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 150.0));
                }
            }
        }
    }

    public void add(BuffEffect buff, boolean isRemote) {
        if (buff != null) {
            this.buffs.add(buff);
            if (!isRemote) {
                Bookshelf.network.sendToAllAround((IMessage)new PacketAddPlayerProperties(this.entity, buff), new NetworkRegistry.TargetPoint(this.entity.field_71093_bK, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 150.0));
            }
        }
    }
}

