/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.darkhax.bookshelf.lib.Constants;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class ColorObject {
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private float alpha = 1.0f;

    public ColorObject() {
        this(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ColorObject(ByteBuf buf) {
        this(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
    }

    public ColorObject(Color color) {
        this(color.getRed(), color.getGreen(), color.getBlue());
    }

    public ColorObject(boolean doAlpha) {
        this(ColorObject.getRandomColor(), ColorObject.getRandomColor(), ColorObject.getRandomColor(), doAlpha ? ColorObject.getRandomColor() : 1.0f);
    }

    public ColorObject(NBTTagCompound tag) {
        this.setRed(tag.func_74764_b("red") ? tag.func_74760_g("red") : 1.0f);
        this.setGreen(tag.func_74764_b("green") ? tag.func_74760_g("green") : 1.0f);
        this.setBlue(tag.func_74764_b("blue") ? tag.func_74760_g("blue") : 1.0f);
        this.setAlpha(tag.func_74764_b("alpha") ? tag.func_74760_g("alpha") : 1.0f);
    }

    public ColorObject(int rgb) {
        this((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f);
    }

    public ColorObject(int red, int green, int blue) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
    }

    public ColorObject(int red, int green, int blue, int alpha) {
        this((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 100.0f);
    }

    public ColorObject(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public ColorObject(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public void setRed(float amount) {
        this.red = amount < 0.0f ? 0.0f : (amount > 1.0f ? 1.0f : amount);
    }

    public float getRed() {
        return this.red < 0.0f ? 0.0f : (this.red > 1.0f ? 1.0f : this.red);
    }

    public void setGreen(float amount) {
        this.green = amount < 0.0f ? 0.0f : (amount > 1.0f ? 1.0f : amount);
    }

    public float getGreen() {
        return this.green < 0.0f ? 0.0f : (this.green > 1.0f ? 1.0f : this.green);
    }

    public void setBlue(float amount) {
        this.blue = amount < 0.0f ? 0.0f : (amount > 1.0f ? 1.0f : amount);
    }

    public float getBlue() {
        return this.blue < 0.0f ? 0.0f : (this.blue > 1.0f ? 1.0f : this.blue);
    }

    public void setAlpha(float amount) {
        this.alpha = amount < 0.0f ? 0.0f : (amount > 1.0f ? 1.0f : amount);
    }

    public float getAlpha() {
        return this.alpha < 0.0f ? 0.0f : (this.alpha > 1.0f ? 1.0f : this.alpha);
    }

    public NBTTagCompound getTagFromColor() {
        return this.writeToTag(new NBTTagCompound());
    }

    public int getIntFromColor() {
        int rgb = (int)(this.red * 255.0f);
        rgb = (rgb << 8) + (int)(this.green * 255.0f);
        rgb = (rgb << 8) + (int)(this.blue * 255.0f);
        return rgb;
    }

    public static float getRandomColor() {
        return Constants.RANDOM.nextFloat();
    }

    public boolean isGenericWhite() {
        return this.isGeneric(1.0f);
    }

    public boolean isGeneric(float color) {
        return this.red >= color && this.blue >= color && this.green >= color;
    }

    public ColorObject copy() {
        ColorObject clone = new ColorObject(false);
        clone.red = this.red;
        clone.green = this.green;
        clone.blue = this.blue;
        clone.alpha = this.alpha;
        return clone;
    }

    public NBTTagCompound writeToTag(NBTTagCompound tag) {
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74776_a("red", this.red);
        tag.func_74776_a("green", this.green);
        tag.func_74776_a("blue", this.blue);
        tag.func_74776_a("alpha", this.alpha);
        return tag;
    }

    public ItemStack writeToItemStack(ItemStack stack) {
        stack.func_77982_d(this.writeToTag(stack.func_77978_p()));
        return stack;
    }

    public void writeToBuffer(ByteBuf buf) {
        buf.writeFloat(this.red);
        buf.writeFloat(this.green);
        buf.writeFloat(this.blue);
        buf.writeFloat(this.alpha);
    }

    public String toString() {
        String output = EnumChatFormatting.RED + "" + (int)(this.red * 255.0f) + " " + EnumChatFormatting.GREEN + (int)(this.getGreen() * 255.0f) + " " + EnumChatFormatting.BLUE + (int)(this.blue * 255.0f);
        if (this.alpha < 1.0f) {
            output = output + " " + EnumChatFormatting.GRAY + (int)(100.0f - this.alpha * 100.0f);
        }
        return output;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColorObject) {
            ColorObject colorObj = (ColorObject)obj;
            return colorObj.red == this.red && colorObj.green == this.green && colorObj.blue == this.blue && colorObj.alpha == this.alpha;
        }
        return false;
    }
}

