/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import net.minecraft.entity.Entity;

public final class EntityUtils {
    public static double getDistanceBetweenEntities(Entity firstEntity, Entity secondEntity) {
        double distanceX = firstEntity.field_70165_t - secondEntity.field_70165_t;
        double distanceY = firstEntity.field_70163_u - secondEntity.field_70163_u;
        double distanceZ = firstEntity.field_70161_v - secondEntity.field_70161_v;
        return Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceX = destination.field_70165_t - entityToMove.field_70165_t;
        double distanceY = destination.field_70163_u - entityToMove.field_70163_u;
        double distanceZ = destination.field_70161_v - entityToMove.field_70161_v;
        double distance = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
        if (distance > 0.0) {
            entityToMove.field_70159_w = distanceX / distance * force;
            entityToMove.field_70181_x = distanceY / distance * force;
            entityToMove.field_70179_y = distanceZ / distance * force;
        }
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityUtils.getDistanceBetweenEntities(firstEntity, secondEntity) < maxDistance * maxDistance;
    }
}

