/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.UUID;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.MathsUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public final class PlayerUtils {
    private static final Field eventHandler = ReflectionHelper.findField(InventoryCrafting.class, (String[])new String[]{"eventHandler", "field_70465_c"});
    private static final Field containerPlayer = ReflectionHelper.findField(ContainerPlayer.class, (String[])new String[]{"thePlayer", "field_82862_h"});
    private static final Field slotPlayer = ReflectionHelper.findField(SlotCrafting.class, (String[])new String[]{"thePlayer", "field_75238_b"});
    @SideOnly(value=Side.CLIENT)
    public static Field currentBlockDamage;

    public static boolean canPlayerSleep(EntityPlayer player) {
        return !player.func_70608_bn() && player.func_70089_S() && player.field_70170_p.func_72820_D() > 12541L && player.field_70170_p.func_72820_D() < 23458L;
    }

    public static void tryAOEHarvest(EntityPlayer player, Material[] materials, int layers) {
        ItemStack stack = player.func_70694_bm();
        if (stack != null) {
            ItemStackUtils.prepareDataTag(stack);
            MovingObjectPosition lookPos = MathsUtils.rayTrace(player, 4.5);
            if (lookPos != null && player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                NBTTagCompound dataTag = stack.field_77990_d;
                int x = lookPos.field_72311_b;
                int y = lookPos.field_72312_c;
                int z = lookPos.field_72309_d;
                if (!dataTag.func_74764_b("bookshelfBreaking") || !dataTag.func_74767_n("bookshelfBreaking")) {
                    dataTag.func_74757_a("bookshelfBreaking", true);
                    int rangeX = layers;
                    int rangeY = layers;
                    int rangeZ = layers;
                    switch (lookPos.field_72310_e) {
                        case 1: {
                            rangeY = 0;
                            break;
                        }
                        case 3: {
                            rangeZ = 0;
                            break;
                        }
                        case 5: {
                            rangeX = 0;
                        }
                    }
                    for (int posX = x - rangeX; posX <= x + rangeX; ++posX) {
                        for (int posY = y - rangeY; posY <= y + rangeY; ++posY) {
                            for (int posZ = z - rangeZ; posZ <= z + rangeZ; ++posZ) {
                                Block block = playerMP.field_70170_p.func_147439_a(posX, posY, posZ);
                                for (Material mat : materials) {
                                    if (block == null || mat != block.func_149688_o() || !(block.func_149737_a((EntityPlayer)playerMP, playerMP.field_70170_p, x, posY, z) > 0.0f)) continue;
                                    playerMP.field_71134_c.func_73084_b(posX, posY, posZ);
                                }
                            }
                        }
                    }
                    dataTag.func_74757_a("bookshelfBreaking", false);
                }
            }
        }
    }

    public static boolean isPlayerReal(EntityPlayer player) {
        if (player == null || player.field_70170_p == null || player.getClass() != EntityPlayerMP.class) {
            return false;
        }
        return MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.contains(player);
    }

    public static EntityPlayer getPlayerFromUUID(World world, UUID playerID) {
        for (Object playerEntry : world.field_73010_i) {
            EntityPlayer player;
            if (!(playerEntry instanceof EntityPlayer) || !(player = (EntityPlayer)playerEntry).func_110124_au().equals(playerID)) continue;
            return player;
        }
        return null;
    }

    public static EntityPlayer getPlayerFromCrafting(InventoryCrafting inventory) {
        try {
            Container container = (Container)eventHandler.get(inventory);
            if (container instanceof ContainerPlayer) {
                return (EntityPlayer)containerPlayer.get(container);
            }
            if (container instanceof ContainerWorkbench) {
                return (EntityPlayer)slotPlayer.get(container.func_75139_a(0));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getBlockDamage() {
        if (currentBlockDamage == null) {
            return 0.0f;
        }
        try {
            return currentBlockDamage.getFloat(Minecraft.func_71410_x().field_71442_b);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return 0.0f;
    }
}

