/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.MathUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class BlockMiner {
    protected final World world;
    protected final TileEntity owner;
    protected final int x;
    protected final int y;
    protected final int z;
    protected final int minerId;
    private boolean hasMined;
    private boolean hasFailed;
    private int energyRequired;
    private int energyAccepted;

    public BlockMiner(World world, TileEntity owner, int x, int y, int z) {
        this.world = world;
        this.owner = owner;
        this.x = x;
        this.y = y;
        this.z = z;
        this.minerId = world.field_73012_v.nextInt();
    }

    public boolean hasMined() {
        return this.hasMined;
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public void mineStack(ItemStack stack) {
        stack.field_77994_a -= Utils.addToRandomInventoryAround(this.owner.func_145831_w(), this.owner.field_145851_c, this.owner.field_145848_d, this.owner.field_145849_e, stack);
        if (stack.field_77994_a > 0) {
            stack.field_77994_a -= Utils.addToRandomInjectableAround(this.owner.func_145831_w(), this.owner.field_145851_c, this.owner.field_145848_d, this.owner.field_145849_e, ForgeDirection.UNKNOWN, stack);
        }
        if (stack.field_77994_a > 0) {
            float f = this.world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = this.world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = this.world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(this.owner.func_145831_w(), (double)((float)this.owner.field_145851_c + f), (double)((float)this.owner.field_145848_d + f1 + 0.5f), (double)((float)this.owner.field_145849_e + f2), stack);
            entityitem.lifespan = BuildCraftCore.itemLifespan * 20;
            entityitem.field_145804_b = 10;
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)this.world.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)this.world.field_73012_v.nextGaussian() * f3 + 1.0f;
            entityitem.field_70179_y = (float)this.world.field_73012_v.nextGaussian() * f3;
            this.owner.func_145831_w().func_72838_d((Entity)entityitem);
        }
    }

    public void invalidate() {
        this.world.func_147443_d(this.minerId, this.x, this.y, this.z, -1);
    }

    public int acceptEnergy(int offeredAmount) {
        if (BlockUtils.isUnbreakableBlock(this.world, this.x, this.y, this.z)) {
            this.hasFailed = true;
            return 0;
        }
        this.energyRequired = BlockUtils.computeBlockBreakEnergy(this.world, this.x, this.y, this.z);
        int usedAmount = MathUtils.clamp(offeredAmount, 0, Math.max(0, this.energyRequired - this.energyAccepted));
        this.energyAccepted += usedAmount;
        if (this.energyAccepted >= this.energyRequired) {
            this.world.func_147443_d(this.minerId, this.x, this.y, this.z, -1);
            this.hasMined = true;
            Block block = this.world.func_147439_a(this.x, this.y, this.z);
            int meta = this.world.func_72805_g(this.x, this.y, this.z);
            BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(this.x, this.y, this.z, this.world, block, meta, (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.owner.func_145831_w(), this.owner.field_145851_c, this.owner.field_145848_d, this.owner.field_145849_e).get());
            MinecraftForge.EVENT_BUS.post((Event)breakEvent);
            if (!breakEvent.isCanceled()) {
                List<ItemStack> stacks = BlockUtils.getItemStackFromBlock((WorldServer)this.world, this.x, this.y, this.z);
                if (stacks != null) {
                    for (ItemStack s : stacks) {
                        if (s == null) continue;
                        this.mineStack(s);
                    }
                }
                this.world.func_72889_a(null, 2001, this.x, this.y, this.z, Block.func_149682_b((Block)block) + (meta << 12));
                this.world.func_147468_f(this.x, this.y, this.z);
            } else {
                this.hasFailed = true;
            }
        } else {
            this.world.func_147443_d(this.minerId, this.x, this.y, this.z, MathUtils.clamp((int)Math.floor(this.energyAccepted * 10 / this.energyRequired), 0, 9));
        }
        return usedAmount;
    }
}

