/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item.filter;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.network.NetworkUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.ModItemFilterGui;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModItemFilter
implements IItemFilter {
    private final String[] mods = new String[3];
    private boolean blacklist = false;

    public String setMod(int index, ItemStack itemStack) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        if (itemStack == null || itemStack.func_77973_b() == null) {
            this.setMod(index, (String)null);
            return null;
        }
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)itemStack.func_77973_b());
        if (ui == null) {
            this.setMod(index, (String)null);
            return null;
        }
        String targetMod = ui.modId;
        if (targetMod == null) {
            this.setMod(index, (String)null);
            return null;
        }
        this.setMod(index, targetMod);
        return targetMod;
    }

    public void setMod(int index, String mod) {
        if (index < 0 || index >= this.mods.length) {
            return;
        }
        this.mods[index] = mod;
    }

    public String getModAt(int index) {
        if (index < 0 || index >= this.mods.length) {
            return null;
        }
        return this.mods[index];
    }

    public void setBlacklist(boolean value) {
        this.blacklist = value;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean doesItemPassFilter(NetworkedInventory inv, ItemStack item) {
        if (item == null || item.func_77973_b() == null) {
            return false;
        }
        GameRegistry.UniqueIdentifier ui = GameRegistry.findUniqueIdentifierFor((Item)item.func_77973_b());
        if (ui == null) {
            return false;
        }
        String targetMod = ui.modId;
        if (targetMod != null) {
            for (String mod : this.mods) {
                if (!targetMod.equals(mod)) continue;
                return !this.blacklist;
            }
        }
        return this.blacklist;
    }

    @Override
    public boolean doesFilterCaptureStack(NetworkedInventory inv, ItemStack item) {
        return false;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void createGhostSlots(List<GhostSlot> slots, int xOffset, int yOffset, Runnable cb) {
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemFilterGui getGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        return new ModItemFilterGui(gui, itemConduit, isInput);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = nbtRoot.func_74779_i("mod" + i);
            this.mods[i] = mod == null || mod.isEmpty() || "-".equals(mod) ? null : mod;
            this.blacklist = nbtRoot.func_74764_b("blacklist") ? nbtRoot.func_74767_n("blacklist") : false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        for (int i = 0; i < this.mods.length; ++i) {
            String mod = this.mods[i];
            if (mod == null || mod.trim().isEmpty()) {
                nbtRoot.func_74778_a("mod" + i, "-");
                continue;
            }
            nbtRoot.func_74778_a("mod" + i, mod);
        }
        nbtRoot.func_74757_a("blacklist", this.blacklist);
    }

    @Override
    public void writeToByteBuf(ByteBuf buf) {
        NBTTagCompound root = new NBTTagCompound();
        this.writeToNBT(root);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    @Override
    public void readFromByteBuf(ByteBuf buf) {
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readFromNBT(tag);
    }
}

