/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.hypercube.HyperCubeModel;
import crazypants.enderio.machine.hypercube.HyperCubeModel2;
import crazypants.enderio.machine.hypercube.IModel;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class HyperCubeRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer {
    private IModel model;
    private BoundingBox bb;
    private boolean adjustForItem = false;

    public HyperCubeRenderer() {
        float scale = 0.7f;
        if (Config.useAlternateTesseractModel) {
            this.model = new HyperCubeModel2();
            scale = 0.8f;
            this.adjustForItem = true;
        } else {
            this.model = new HyperCubeModel();
        }
        this.bb = BoundingBox.UNIT_CUBE.scale(scale, scale, scale);
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        TileHyperCube cube = (TileHyperCube)te;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        this.model.render(cube, x, y, z);
        if (cube.getChannel() != null) {
            this.renderPower(te.func_145831_w(), x, y, z, cube.getChannel() != null);
        }
        GL11.glDisable((int)32826);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.adjustForItem) {
            switch (type) {
                case ENTITY: {
                    this.renderItem(0.0f, 0.0f, 0.0f);
                    return;
                }
                case EQUIPPED: 
                case EQUIPPED_FIRST_PERSON: {
                    this.renderItem(0.0f, 1.0f, 1.0f);
                    return;
                }
                case INVENTORY: {
                    this.renderItem(0.0f, 0.0f, 0.0f);
                    return;
                }
            }
            this.renderItem(0.0f, 0.0f, 0.0f);
            return;
        }
        this.renderItem(0.0f, 0.0f, 0.0f);
    }

    private void renderPower(World world, double x, double y, double z, boolean isActive) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        RenderUtil.bindBlockTexture();
        IIcon icon = EnderIO.blockHyperCube.getPortalIcon();
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (!isActive) {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        CubeRenderer.render((BoundingBox)this.bb, (IIcon)icon);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void renderItem(float x, float y, float z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        this.model.render();
        GL11.glPopMatrix();
    }
}

