/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vertex;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.obelisk.BlockObeliskAbstract;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ObeliskRenderer
implements ISimpleBlockRenderingHandler {
    private static final VertXForm2 xform2 = new VertXForm2();
    private static final VertXForm3 xform3 = new VertXForm3();
    private static final float WIDE_PINCH = 0.9f;
    private static final float WIDTH = 0.50624996f;
    private static final float HEIGHT = 0.475f;
    private static final BoundingBox bb1 = BoundingBox.UNIT_CUBE.scale(0.50624996f, 0.475f, 1.0f).translate(0.0f, -0.2625f, 0.0f);
    private static final BoundingBox bb2 = BoundingBox.UNIT_CUBE.scale(1.0f, 0.475f, 0.50624996f).translate(0.0f, -0.2625f, 0.0f);
    private static final int BOTTOM = ForgeDirection.DOWN.ordinal();
    private static final int TOP = ForgeDirection.UP.ordinal();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        Tessellator.field_78398_a.func_78382_b();
        this.renderWorldBlock(null, 0, 0, 0, block, 0, renderer);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2896);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        IIcon[] icons;
        if (world != null) {
            RenderUtil.setTesselatorBrightness((IBlockAccess)world, (int)x, (int)y, (int)z);
            if (renderer.func_147744_b()) {
                icons = new IIcon[6];
                for (int i = 0; i < icons.length; ++i) {
                    icons[i] = renderer.field_147840_d;
                }
            } else {
                icons = RenderUtil.getBlockTextures((IBlockAccess)world, (int)x, (int)y, (int)z);
            }
        } else {
            icons = RenderUtil.getBlockTextures((Block)block, (int)0);
        }
        IIcon[] bottomIcons = new IIcon[6];
        for (int i = 1; i < bottomIcons.length; ++i) {
            bottomIcons[i] = IconUtil.blankTexture;
        }
        bottomIcons[ObeliskRenderer.BOTTOM] = icons[BOTTOM];
        icons[ObeliskRenderer.BOTTOM] = IconUtil.blankTexture;
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        ObeliskRenderer.xform2.isX = false;
        CubeRenderer.render((BoundingBox)bb1, (IIcon[])icons, (VertexTransform)xform2, (boolean)true);
        ObeliskRenderer.xform2.isX = true;
        icons[ObeliskRenderer.TOP] = IconUtil.blankTexture;
        CubeRenderer.render((BoundingBox)bb2, (IIcon[])icons, (VertexTransform)xform2, (boolean)true);
        CubeRenderer.render((BoundingBox)BoundingBox.UNIT_CUBE, (IIcon[])bottomIcons, (VertexTransform)xform3, (boolean)true);
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockObeliskAbstract.defaultObeliskRenderId;
    }

    private static class VertXForm3
    implements VertexTransform {
        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            vec.x -= 0.5;
            vec.x *= (double)0.9f;
            vec.x += 0.5;
            vec.z -= 0.5;
            vec.z *= (double)0.9f;
            vec.z += 0.5;
        }

        public void applyToNormal(Vector3f vec) {
        }
    }

    private static class VertXForm2
    implements VertexTransform {
        boolean isX = true;

        public void apply(Vertex vertex) {
            this.apply(vertex.xyz);
        }

        public void apply(Vector3d vec) {
            double pinch = 0.9f;
            if (vec.y > 0.2) {
                pinch = 0.5;
            }
            if (this.isX) {
                vec.x -= 0.5;
                vec.x *= pinch;
                vec.x += 0.5;
            } else {
                vec.z -= 0.5;
                vec.z *= pinch;
                vec.z += 0.5;
            }
        }

        public void applyToNormal(Vector3f vec) {
        }
    }
}

