/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.TechneModelRenderer;
import com.enderio.core.client.render.TechneUtil;
import com.enderio.core.common.util.BlockCoord;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.teleport.telepad.BlockTelePad;
import crazypants.enderio.teleport.telepad.TileTelePad;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.common.util.ForgeDirection;

public class TelePadRenderer
extends TechneModelRenderer {
    private final Collection<GroupObject> strippedModel = Lists.newArrayList();

    public TelePadRenderer() {
        super(TechneUtil.getModel((String)EnderIO.DOMAIN, (String)"models/telePad"), BlockTelePad.renderId);
        for (String s : this.model.keySet()) {
            if (s.equals("glass") || s.contains("blade")) continue;
            this.strippedModel.add((GroupObject)this.model.get(s));
        }
    }

    protected Collection<GroupObject> getModel() {
        return this.strippedModel;
    }

    protected Collection<GroupObject> getModel(Block block, int metadata) {
        return this.getModel();
    }

    protected Collection<GroupObject> getModel(IBlockAccess world, int x, int y, int z) {
        return this.getModel();
    }

    Map<String, GroupObject> getFullModel() {
        return this.model;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileTelePad te = (TileTelePad)world.func_147438_o(x, y, z);
        boolean ret = true;
        if (te.inNetwork()) {
            if (renderer.func_147744_b()) {
                IIcon icon = renderer.field_147840_d;
                renderer.func_147768_a(block, (double)x, (double)y, (double)z, icon);
                renderer.func_147806_b(block, (double)x, (double)y, (double)z, icon);
                BlockCoord bc = te.getLocation();
                if (!this.isTelepad(world, bc, ForgeDirection.EAST)) {
                    renderer.func_147764_f(block, (double)x, (double)y, (double)z, icon);
                }
                if (!this.isTelepad(world, bc, ForgeDirection.WEST)) {
                    renderer.func_147798_e(block, (double)x, (double)y, (double)z, icon);
                }
                if (!this.isTelepad(world, bc, ForgeDirection.SOUTH)) {
                    renderer.func_147734_d(block, (double)x, (double)y, (double)z, icon);
                }
                if (!this.isTelepad(world, bc, ForgeDirection.NORTH)) {
                    renderer.func_147761_c(block, (double)x, (double)y, (double)z, icon);
                }
            } else if (te.isMaster()) {
                super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
            } else {
                ret = false;
            }
        } else {
            renderer.func_147784_q(block, x, y, z);
        }
        return ret;
    }

    private boolean isTelepad(IBlockAccess world, BlockCoord pos, ForgeDirection dir) {
        return pos.getLocation(dir).getTileEntity(world) instanceof TileTelePad;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        Tessellator.field_78398_a.func_78382_b();
        CubeRenderer.render((Block)block, (int)metadata);
        Tessellator.field_78398_a.func_78381_a();
    }
}

