/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.RF;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAverageCounter;

public class RFTileEntityAverageCounter
extends TileEntityAverageCounter
implements IEnergyHandler {
    protected EnergyStorage storage = new EnergyStorage(32000);
    private int rec;
    private int send;
    private int duration;
    private int AVG;

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        this.rec = maxReceive;
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void initData() {
        super.initData();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.getNeibough()) {
            if (this.storage.getEnergyStored() > 0) {
                this.transferEnergy();
            }
            if (!this.field_145850_b.field_72995_K) {
                this.index = (this.index + 1) % 220;
                this.data[this.index] = 0.0;
                this.duration = this.period * 20;
                this.clientAverage = this.AVG = this.duration * this.send;
                this.data[this.index] = this.AVG;
                this.setPowerType((byte)1);
                this.send = 0;
                this.rec = 0;
            }
        }
    }

    private boolean getNeibough() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (tile instanceof RFTileEntityAverageCounter || !(tile instanceof IEnergyHandler)) continue;
            return true;
        }
        return false;
    }

    protected void transferEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (tile instanceof RFTileEntityAverageCounter || !(tile instanceof IEnergyHandler)) continue;
            IEnergyHandler receiver = (IEnergyHandler)tile;
            this.sendMaxTo(receiver, direction.getOpposite());
        }
    }

    public int sendMaxTo(IEnergyHandler pEnergyHandler, ForgeDirection pFrom) {
        this.send = Math.min(this.storage.getEnergyStored(), 128);
        return this.extractEnergy(pFrom, pEnergyHandler.receiveEnergy(pFrom, Math.min(this.storage.getEnergyStored(), 128), false), false);
    }
}

