/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityHowlerAlarm;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearNetworkHelper;

public class PacketClientSound
implements IMessage,
IMessageHandler<PacketClientSound, IMessage> {
    private int x;
    private int y;
    private int z;
    private byte slot;
    private String soundName;

    public PacketClientSound() {
    }

    public PacketClientSound(int x, int y, int z, byte slot, String soundName) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.slot = slot;
        this.soundName = soundName;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readByte();
        this.soundName = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundName);
    }

    public IMessage onMessage(PacketClientSound message, MessageContext ctx) {
        TileEntity tileEntity = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityHowlerAlarm) {
            ((TileEntityHowlerAlarm)tileEntity).setSoundName(message.soundName);
        } else if (tileEntity instanceof TileEntityInfoPanel) {
            ItemStack stack = ((TileEntityInfoPanel)tileEntity).func_70301_a(message.slot);
            if (stack == null || !(stack.func_77973_b() instanceof IPanelDataSource)) {
                return null;
            }
            new CardWrapperImpl(stack, -1).setTitle(message.soundName);
            NuclearNetworkHelper.setSensorCardTitle((TileEntityInfoPanel)tileEntity, message.slot, message.soundName);
        }
        return null;
    }
}

