/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;

public class PacketDispSettingsUpdate
implements IMessage,
IMessageHandler<PacketDispSettingsUpdate, IMessage> {
    private int x;
    private int y;
    private int z;
    private byte slot;
    private UUID key;
    private int value;
    private long most;
    private long least;

    public PacketDispSettingsUpdate() {
    }

    public PacketDispSettingsUpdate(int x, int y, int z, byte slot, UUID key, int value) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.slot = slot;
        this.key = key;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readByte();
        this.most = buf.readLong();
        this.least = buf.readLong();
        this.value = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.slot);
        buf.writeLong(this.key.getMostSignificantBits());
        buf.writeLong(this.key.getLeastSignificantBits());
        buf.writeInt(this.value);
    }

    public IMessage onMessage(PacketDispSettingsUpdate message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tileEntity == null || !(tileEntity instanceof TileEntityInfoPanel)) {
            return null;
        }
        TileEntityInfoPanel panel = (TileEntityInfoPanel)tileEntity;
        panel.getDisplaySettingsForSlot(message.slot).put(new UUID(message.most, message.least), message.value);
        panel.resetCardData();
        return null;
    }
}

