/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.panel.http;

import argo.format.CompactJsonFormatter;
import argo.format.JsonFormatter;
import argo.jdom.JsonArrayNodeBuilder;
import argo.jdom.JsonNodeBuilder;
import argo.jdom.JsonNodeBuilders;
import argo.jdom.JsonObjectNodeBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.panel.http.HttpCardSender;

public class Request
implements Runnable {
    private static final JsonFormatter JSON_FORMATTER = new CompactJsonFormatter();
    private final URL url;
    private final ConcurrentHashMap<Long, JsonNodeBuilder> unsent;

    public Request(URL url, ConcurrentHashMap<Long, JsonNodeBuilder> unsent) {
        this.url = url;
        this.unsent = unsent;
    }

    private String formatData() {
        JsonObjectNodeBuilder builder = JsonNodeBuilders.anObjectBuilder();
        JsonArrayNodeBuilder array = JsonNodeBuilders.anArrayBuilder();
        ArrayList list = new ArrayList(this.unsent.keySet());
        for (Long key : list) {
            array.withElement(this.unsent.get(key));
            this.unsent.remove(key);
        }
        builder.withField("key", JsonNodeBuilders.aStringBuilder((String)IC2NuclearControl.instance.httpSensorKey)).withField("data", (JsonNodeBuilder)array);
        return JSON_FORMATTER.format(builder.build());
    }

    @Override
    public void run() {
        try {
            boolean isIdRequest;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            boolean bl = isIdRequest = this.unsent == null;
            if (isIdRequest) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String line = reader.readLine();
                if (line != null) {
                    HttpCardSender.instance.availableIds.add(Long.parseLong(line.trim()));
                }
                reader.close();
            } else {
                String data = this.formatData();
                byte[] bytes = data.getBytes("UTF-8");
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", "" + bytes.length);
                DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
                outStream.write(bytes);
                outStream.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                reader.readLine();
                outStream.close();
                reader.close();
                connection.disconnect();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

