/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.harvestcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public abstract class RecipeHandlerHCBase
extends RecipeHandlerBase {
    protected abstract String getRecipeSubID();

    public String getGuiTexture() {
        return String.format("neiintegration:textures/harvestcraft/%s.png", this.getRecipeSubID());
    }

    @Override
    public String getRecipeID() {
        return "harvestcraft." + this.getRecipeSubID();
    }

    public void loadTransferRects() {
        this.addTransferRect(68, 21, 24, 17);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)160, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(68, 21, 160, 0, 24, 16, 80, 0);
    }

    public abstract Map<ItemStack, ItemStack> getRecipes();

    public List<ItemStack> getFuelItems() {
        return Collections.singletonList(this.getFuelItem());
    }

    public ItemStack getFuelItem() {
        return null;
    }

    @Override
    public void loadAllRecipes() {
        for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
            this.arecipes.add(new CachedHCRecipe(recipe.getKey(), recipe.getValue(), this.getFuelItems()));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
            if (!Utils.areStacksSameTypeCraftingSafe(recipe.getValue(), result)) continue;
            this.arecipes.add(new CachedHCRecipe(recipe.getKey(), recipe.getValue(), this.getFuelItems()));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        ingredient = ingredient.func_77946_l();
        ingredient.field_77994_a = 1;
        for (ItemStack itemStack : this.getFuelItems()) {
            if (!Utils.areStacksSameTypeCraftingSafe(itemStack, ingredient)) continue;
            for (Map.Entry<ItemStack, ItemStack> recipe : this.getRecipes().entrySet()) {
                this.arecipes.add(new CachedHCRecipe(recipe.getKey(), recipe.getValue(), Collections.singletonList(ingredient)));
            }
            return;
        }
        for (Map.Entry entry : this.getRecipes().entrySet()) {
            if (!Utils.areStacksSameTypeCraftingSafe((ItemStack)entry.getKey(), ingredient)) continue;
            this.arecipes.add(new CachedHCRecipe(ingredient, (ItemStack)entry.getValue(), this.getFuelItems()));
        }
    }

    public class CachedHCRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public PositionedStack output;
        public PositionedStack fuels;

        public CachedHCRecipe(ItemStack input, ItemStack output, List<ItemStack> fuels) {
            this.input = new PositionedStack((Object)input, 45, 4);
            this.output = new PositionedStack((Object)output, 105, 22);
            this.fuels = new PositionedStack(fuels, 45, 40);
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getOtherStack() {
            this.randomRenderPermutation(this.fuels, RecipeHandlerHCBase.this.cycleticks / 20);
            return this.fuels;
        }
    }
}

