/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    private static final Track[] EMPTY_TRACK_ARRAY = new Track[0];
    protected float divisionType;
    protected int resolution;
    protected Vector tracks;

    public Sequence(float fDivisionType, int nResolution) throws InvalidMidiDataException {
        this(fDivisionType, nResolution, 0);
    }

    public Sequence(float fDivisionType, int nResolution, int nNumTracks) throws InvalidMidiDataException {
        if (fDivisionType != 0.0f && fDivisionType != 24.0f && fDivisionType != 25.0f && fDivisionType != 29.97f && fDivisionType != 30.0f) {
            throw new InvalidMidiDataException("Invalid division type: " + fDivisionType);
        }
        this.divisionType = fDivisionType;
        this.resolution = nResolution;
        this.tracks = new Vector();
        for (int i = 0; i < nNumTracks; ++i) {
            this.createTrack();
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Track createTrack() {
        Track track = new Track();
        Vector vector = this.tracks;
        synchronized (vector) {
            this.tracks.add(track);
        }
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTrack(Track track) {
        Vector vector = this.tracks;
        synchronized (vector) {
            return this.tracks.remove(track);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Track[] getTracks() {
        Vector vector = this.tracks;
        synchronized (vector) {
            return this.tracks.toArray(EMPTY_TRACK_ARRAY);
        }
    }

    public long getMicrosecondLength() {
        if (this.getDivisionType() != 0.0f) {
            return (long)((float)(this.getTickLength() * 1000000L) / (this.getDivisionType() * (float)this.getResolution()));
        }
        return -1L;
    }

    public long getTickLength() {
        long lLength = 0L;
        for (Track track : this.tracks) {
            lLength = Math.max(lLength, track.ticks());
        }
        return lLength;
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

