/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;
import org.tritonus.share.TDebug;

public abstract class FloatControl
extends Control {
    private float m_fValue;
    private float m_fMinimum;
    private float m_fMaximum;
    private float m_fPrecision;
    private int m_nUpdatePeriod;
    private String m_strUnits;
    private String m_strMinLabel;
    private String m_strMidLabel;
    private String m_strMaxLabel;

    protected FloatControl(Type type, float fMinimum, float fMaximum, float fPrecision, int nUpdatePeriod, float fInitialValue, String strUnits, String strMinLabel, String strMidLabel, String strMaxLabel) {
        super(type);
        if (TDebug.TraceControl) {
            TDebug.out("FloatControl.<init>: begin");
        }
        this.m_fMinimum = fMinimum;
        this.m_fMaximum = fMaximum;
        this.m_fPrecision = fPrecision;
        this.m_nUpdatePeriod = nUpdatePeriod;
        this.m_fValue = fInitialValue;
        this.m_nUpdatePeriod = nUpdatePeriod;
        this.m_strMinLabel = strMinLabel;
        this.m_strMidLabel = strMidLabel;
        this.m_strMaxLabel = strMaxLabel;
        if (TDebug.TraceControl) {
            TDebug.out("FloatControl.<init>: end");
        }
    }

    protected FloatControl(Type type, float fMinimum, float fMaximum, float fPrecision, int nUpdatePeriod, float fInitialValue, String strUnits) {
        this(type, fMinimum, fMaximum, fPrecision, nUpdatePeriod, fInitialValue, strUnits, "Left", "Center", "Right");
    }

    public void setValue(float fValue) {
        this.m_fValue = fValue;
    }

    public float getValue() {
        return this.m_fValue;
    }

    public float getMaximum() {
        return this.m_fMaximum;
    }

    public float getMinimum() {
        return this.m_fMinimum;
    }

    public String getUnits() {
        return this.m_strUnits;
    }

    public String getMinLabel() {
        return this.m_strMinLabel;
    }

    public String getMidLabel() {
        return this.m_strMidLabel;
    }

    public String getMaxLabel() {
        return this.m_strMaxLabel;
    }

    public float getPrecision() {
        return this.m_fPrecision;
    }

    public int getUpdatePeriod() {
        return this.m_nUpdatePeriod;
    }

    public void shift(float fFrom, float fTo, int nMicroseconds) {
        this.setValue(fTo);
    }

    public String toString() {
        return super.toString() + " [value = " + this.getValue() + "]";
    }

    public static class Type
    extends Control.Type {
        public static final Type MASTER_GAIN = new Type("MASTER_GAIN");
        public static final Type AUX_SEND = new Type("AUX_SEND");
        public static final Type AUX_RETURN = new Type("AUX_RETURN");
        public static final Type REVERB_SEND = new Type("REVERB_SEND");
        public static final Type REVERB_RETURN = new Type("REVERB_RETURN");
        public static final Type VOLUME = new Type("VOLUME");
        public static final Type PAN = new Type("PAN");
        public static final Type BALANCE = new Type("BALANCE");
        public static final Type SAMPLE_RATE = new Type("SAMPLE RATE");

        protected Type(String strName) {
            super(strName);
        }
    }
}

