/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.core;

import java.util.Iterator;
import java.util.Set;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;
import org.tritonus.core.TInit;
import org.tritonus.share.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAudioConfig {
    private static Set<AudioFileWriter> sm_audioFileWriters = null;
    private static Set<AudioFileReader> sm_audioFileReaders = null;
    private static Set<FormatConversionProvider> sm_formatConversionProviders = null;
    private static Set<MixerProvider> sm_mixerProviders = null;
    private static Mixer.Info sm_defaultMixerInfo;

    private TAudioConfig() {
    }

    private static void registerAudioFileReaders() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                AudioFileReader provider = (AudioFileReader)obj;
                TAudioConfig.addAudioFileReader(provider);
            }
        };
        TInit.registerClasses(AudioFileReader.class, action);
    }

    private static void registerAudioFileWriters() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                AudioFileWriter provider = (AudioFileWriter)obj;
                TAudioConfig.addAudioFileWriter(provider);
            }
        };
        TInit.registerClasses(AudioFileWriter.class, action);
    }

    private static void registerFormatConversionProviders() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                FormatConversionProvider provider = (FormatConversionProvider)obj;
                TAudioConfig.addFormatConversionProvider(provider);
            }
        };
        TInit.registerClasses(FormatConversionProvider.class, action);
    }

    private static void registerMixerProviders() {
        TInit.ProviderRegistrationAction action = null;
        action = new TInit.ProviderRegistrationAction(){

            public void register(Object obj) throws Exception {
                MixerProvider provider = (MixerProvider)obj;
                TAudioConfig.addMixerProvider(provider);
            }
        };
        TInit.registerClasses(MixerProvider.class, action);
    }

    public static synchronized void addAudioFileReader(AudioFileReader provider) {
        TAudioConfig.getAudioFileReadersImpl().add(provider);
    }

    public static synchronized void removeAudioFileReader(AudioFileReader provider) {
        TAudioConfig.getAudioFileReadersImpl().remove(provider);
    }

    public static synchronized Iterator<AudioFileReader> getAudioFileReaders() {
        return TAudioConfig.getAudioFileReadersImpl().iterator();
    }

    private static synchronized Set<AudioFileReader> getAudioFileReadersImpl() {
        if (sm_audioFileReaders == null) {
            sm_audioFileReaders = new ArraySet<AudioFileReader>();
            TAudioConfig.registerAudioFileReaders();
        }
        return sm_audioFileReaders;
    }

    public static synchronized void addAudioFileWriter(AudioFileWriter provider) {
        TAudioConfig.getAudioFileWritersImpl().add(provider);
    }

    public static synchronized void removeAudioFileWriter(AudioFileWriter provider) {
        TAudioConfig.getAudioFileWritersImpl().remove(provider);
    }

    public static synchronized Iterator<AudioFileWriter> getAudioFileWriters() {
        return TAudioConfig.getAudioFileWritersImpl().iterator();
    }

    private static synchronized Set<AudioFileWriter> getAudioFileWritersImpl() {
        if (sm_audioFileWriters == null) {
            sm_audioFileWriters = new ArraySet<AudioFileWriter>();
            TAudioConfig.registerAudioFileWriters();
        }
        return sm_audioFileWriters;
    }

    public static synchronized void addFormatConversionProvider(FormatConversionProvider provider) {
        TAudioConfig.getFormatConversionProvidersImpl().add(provider);
    }

    public static synchronized void removeFormatConversionProvider(FormatConversionProvider provider) {
        TAudioConfig.getFormatConversionProvidersImpl().remove(provider);
    }

    public static synchronized Iterator<FormatConversionProvider> getFormatConversionProviders() {
        return TAudioConfig.getFormatConversionProvidersImpl().iterator();
    }

    private static synchronized Set<FormatConversionProvider> getFormatConversionProvidersImpl() {
        if (sm_formatConversionProviders == null) {
            sm_formatConversionProviders = new ArraySet<FormatConversionProvider>();
            TAudioConfig.registerFormatConversionProviders();
        }
        return sm_formatConversionProviders;
    }

    public static synchronized void addMixerProvider(MixerProvider provider) {
        TAudioConfig.getMixerProvidersImpl().add(provider);
    }

    public static synchronized void removeMixerProvider(MixerProvider provider) {
        TAudioConfig.getMixerProvidersImpl().remove(provider);
    }

    public static synchronized Iterator<MixerProvider> getMixerProviders() {
        return TAudioConfig.getMixerProvidersImpl().iterator();
    }

    private static synchronized Set<MixerProvider> getMixerProvidersImpl() {
        if (sm_mixerProviders == null) {
            sm_mixerProviders = new ArraySet<MixerProvider>();
            TAudioConfig.registerMixerProviders();
        }
        return sm_mixerProviders;
    }

    public static Mixer.Info getDefaultMixerInfo() {
        return sm_defaultMixerInfo;
    }
}

