/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.Block;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pcl.OpenFM.GUI.GuiRadioBase;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.TileEntity.TileEntityRadio;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheralProvider", modid="ComputerCraft")})
public class BlockRadio
extends Block
implements ITileEntityProvider,
IPeripheralProvider {
    @SideOnly(value=Side.CLIENT)
    public static IIcon sideIcon;
    @SideOnly(value=Side.CLIENT)
    public static IIcon frontIcon;
    public GuiRadioBase guiRadio;
    private Random random;

    public BlockRadio() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("OpenFM.Radio");
        this.func_149672_a(Block.field_149766_f);
        this.random = new Random();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        sideIcon = ir.func_94245_a("openfm:radio_side");
        frontIcon = ir.func_94245_a("openfm:radio_front");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 2: {
                if (meta == 1) {
                    return frontIcon;
                }
                return sideIcon;
            }
            case 3: {
                if (meta == 0 || meta == 3) {
                    return frontIcon;
                }
                return sideIcon;
            }
            case 4: {
                if (meta == 4) {
                    return frontIcon;
                }
                return sideIcon;
            }
            case 5: {
                if (meta == 2) {
                    return frontIcon;
                }
                return sideIcon;
            }
        }
        return sideIcon;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float clickX, float clickY, float clickZ) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)OpenFM.instance, 0, world, x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        TileEntityRadio t = (TileEntityRadio)world.func_147438_o(x, y, z);
        if (t == null) {
            return;
        }
        this.dropContent(t, world, t.field_145851_c, t.field_145848_d, t.field_145849_e);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (t instanceof TileEntityRadio && t.stations.size() > 0) {
            ItemStack stack = new ItemStack(block, 1);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (t.streamURL != null) {
                stack.func_77978_p().func_74778_a("streamurl", t.streamURL);
            }
            if (t.getScreenText() != null) {
                stack.func_77978_p().func_74778_a("screenText", t.getScreenText());
            }
            stack.func_77978_p().func_74768_a("screenColor", t.getScreenColor());
            for (int i = 0; i < t.getStationCount(); ++i) {
                if (t.stations.get(i) == null) continue;
                stack.func_77978_p().func_74778_a("station" + i, t.stations.get(i));
                stack.func_77978_p().func_74768_a("stationCount", i + 1);
            }
            items.add(stack);
            world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, (ItemStack)items.get(0)));
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        return null;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLiving, ItemStack par6ItemStack) {
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        par1World.func_72921_c(par2, par3, par4, l + 1, 2);
        TileEntity te = par1World.func_147438_o(par2, par3, par4);
        ((TileEntityRadio)te).owner = par5EntityLiving.func_110124_au().toString();
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        boolean flag = world.func_72864_z(x, y, z);
        try {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            if (block.func_149744_f()) {
                TileEntity tileEntity = side == Side.SERVER ? MinecraftServer.func_71276_C().func_130014_f_().func_147438_o(x, y, z) : FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(x, y, z);
                ((TileEntityRadio)tileEntity).setRedstoneInput(flag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dropContent(IInventory chest, World world, int xCoord, int yCoord, int zCoord) {
        if (chest == null) {
            return;
        }
        for (int i1 = 0; i1 < chest.func_70302_i_(); ++i1) {
            ItemStack itemstack = chest.func_70301_a(i1);
            if (itemstack == null) continue;
            float offsetX = this.random.nextFloat() * 0.8f + 0.1f;
            float offsetY = this.random.nextFloat() * 0.8f + 0.1f;
            float offsetZ = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int stackSize = this.random.nextInt(21) + 10;
                if (stackSize > itemstack.field_77994_a) {
                    stackSize = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= stackSize;
                EntityItem entityitem = new EntityItem(world, (double)((float)xCoord + offsetX), (double)((float)yCoord + offsetY), (double)((float)zCoord + offsetZ), new ItemStack(itemstack.func_77973_b(), stackSize, itemstack.func_77960_j()));
                float velocity = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * velocity;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * velocity + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * velocity;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public boolean shouldCheckWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRadio(world);
    }

    @Optional.Method(modid="ComputerCraft")
    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityRadio) {
            return (IPeripheral)te;
        }
        return null;
    }
}

