/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM;

import cpw.mods.fml.client.GuiIngameModOptions;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pcl.OpenFM.CommonProxy;
import pcl.OpenFM.ContentRegistry;
import pcl.OpenFM.GUI.OFMGuiHandler;
import pcl.OpenFM.Handler.ClientEvent;
import pcl.OpenFM.Handler.ServerEvent;
import pcl.OpenFM.OFMConfiguration;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.player.PlayerDispatcher;

@Mod(modid="openfm", name="OpenFM", version="0.1.0.43", dependencies="", guiFactory="pcl.OpenFM.GUI.OFMGuiFactory")
public class OpenFM {
    public static final String MODID = "openfm";
    @Mod.Instance(value="openfm")
    public static OpenFM instance;
    @SidedProxy(clientSide="pcl.OpenFM.ClientProxy", serverSide="pcl.OpenFM.CommonProxy")
    public static CommonProxy proxy;
    public static List<PlayerDispatcher> playerList;
    public Configuration config;
    public static final Logger logger;
    public static File configFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        configFile = new File(event.getModConfigurationDirectory() + "/openfm/openfm.cfg");
        OFMConfiguration.init(configFile);
        if (event.getSourceFile().getName().endsWith(".jar") && event.getSide().isClient() && OFMConfiguration.enableMUD) {
            logger.info("Registering mod with OpenUpdater.");
            try {
                Class.forName("pcl.mud.OpenUpdater").getDeclaredMethod("registerMod", ModContainer.class, URL.class, URL.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), new URL("http://PC-Logix.com/OpenFM/get_latest_build.php?mcver=1.7.10"), new URL("http://PC-Logix.com/OpenFM/changelog.php?mcver=1.7.10"));
            }
            catch (Throwable e) {
                logger.info("OpenUpdater is not installed, not registering.");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(GuiOpenEvent event) {
        if (event.gui instanceof GuiIngameModOptions) {
            event.gui = new GuiModList((GuiScreen)new GuiIngameMenu());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new OFMGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvent());
        FMLCommonHandler.instance().bus().register((Object)new ClientEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvent());
        FMLCommonHandler.instance().bus().register((Object)new ServerEvent());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        ContentRegistry.init();
        proxy.initTileEntities();
        proxy.registerRenderers();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals(MODID)) {
            OFMConfiguration.sync();
        }
    }

    public static void killAllStreams() {
        if (playerList != null) {
            for (PlayerDispatcher p : playerList) {
                p.stop();
            }
        }
    }

    static {
        playerList = new ArrayList<PlayerDispatcher>();
        logger = LogManager.getFormatterLogger((String)MODID);
    }
}

