/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM.TileEntity;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import pcl.OpenFM.Block.BlockSpeaker;
import pcl.OpenFM.ContentRegistry;
import pcl.OpenFM.Items.ItemMemoryCard;
import pcl.OpenFM.OFMConfiguration;
import pcl.OpenFM.OpenFM;
import pcl.OpenFM.misc.Speaker;
import pcl.OpenFM.network.Message.MessageTERadioBlock;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.player.OGGPlayer;
import pcl.OpenFM.player.PlayerDispatcher;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers"), @Optional.Interface(iface="li.cil.oc.api.network.ManagedPeripheral", modid="OpenComputers"), @Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")})
public class TileEntityRadio
extends TileEntity
implements IPeripheral,
SimpleComponent,
ManagedPeripheral,
IInventory {
    public PlayerDispatcher mp3Player = null;
    public OGGPlayer oggPlayer = null;
    public boolean useMP3 = true;
    public boolean isPlaying = false;
    public boolean isValid = true;
    public String streamURL = "";
    private World world;
    public float volume = 0.3f;
    private boolean redstoneInput = false;
    public boolean listenToRedstone = false;
    private boolean scheduledRedstoneInput = false;
    private boolean scheduleRedstoneInput = false;
    public ArrayList<Speaker> speakers = new ArrayList();
    private int screenColor = 255;
    private String screenText = "OpenFM";
    public List<String> stations = new ArrayList<String>();
    private int stationCount = 0;
    public boolean isLocked;
    public String owner = "";
    public ItemStack[] RadioItemStack = new ItemStack[1];
    int th = 0;
    int loops = 0;
    public static final int numMethods;
    public static final String[] methodNames;
    public static final Map<String, Integer> methodIds;

    public TileEntityRadio(World w) {
        this.world = w;
        if (this.isPlaying) {
            try {
                this.startStream();
            }
            catch (Exception e) {
                this.stopStream();
            }
        }
    }

    public TileEntityRadio() {
        if (this.isPlaying) {
            try {
                this.startStream();
            }
            catch (Exception e) {
                this.stopStream();
            }
        }
    }

    public void setWorld(World w) {
        this.world = w;
    }

    public void startStream() throws Exception {
        this.isValid = true;
        OFMConfiguration.init(OpenFM.configFile);
        if (OFMConfiguration.enableStreams) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            String decoder = null;
            if (!OpenFM.playerList.contains(this.mp3Player)) {
                if (side == Side.CLIENT) {
                    OkHttpClient client = new OkHttpClient();
                    Request request = new Request.Builder().url(this.streamURL).build();
                    Response response = null;
                    AudioFileFormat baseFileFormat = null;
                    try {
                        response = client.newCall(request).execute();
                    }
                    catch (IOException e1) {
                        this.isValid = false;
                        this.streamURL = null;
                        this.stopStream();
                    }
                    try {
                        BufferedInputStream bis = new BufferedInputStream(response.body().byteStream());
                        baseFileFormat = AudioSystem.getAudioFileFormat(bis);
                    }
                    catch (IOException | UnsupportedAudioFileException e1) {
                        this.isValid = false;
                        this.streamURL = null;
                        this.stopStream();
                        OpenFM.logger.info((Object)e1);
                    }
                    if (this.isValid) {
                        AudioFileFormat.Type type = baseFileFormat.getType();
                        OpenFM.logger.info(type.toString());
                        if (type.toString().equals("MP3")) {
                            decoder = "mp3";
                        } else if (type.toString().equals("OGG")) {
                            decoder = "ogg";
                        }
                        if (decoder != null && this.isValid) {
                            this.isPlaying = true;
                            OpenFM.logger.info("Starting Stream: " + this.streamURL + " at X:" + this.field_145851_c + " Y:" + this.field_145848_d + " Z:" + this.field_145849_e);
                            this.mp3Player = new PlayerDispatcher(decoder, this.streamURL, this.world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            OpenFM.playerList.add(this.mp3Player);
                        }
                    }
                } else if (this.isValid) {
                    this.isPlaying = true;
                }
            }
        } else {
            this.stopStream();
        }
    }

    public void stopStream() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (OpenFM.playerList.contains(this.mp3Player)) {
            if (side == Side.CLIENT) {
                this.mp3Player.stop();
            }
            OpenFM.playerList.remove(this.mp3Player);
            this.isPlaying = false;
        }
        this.isPlaying = false;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145843_s() {
        this.stopStream();
        super.func_145843_s();
    }

    public void func_145845_h() {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            ++this.th;
            if (this.th >= OFMConfiguration.maxSpeakers) {
                for (Speaker s : this.speakers) {
                    Block sb = this.func_145831_w().func_147439_a((int)s.x, (int)s.y, (int)s.z);
                    if (sb instanceof BlockSpeaker) continue;
                    if (!this.func_145831_w().func_72938_d((int)((int)s.x), (int)((int)s.z)).field_76636_d) break;
                    this.speakers.remove(s);
                    break;
                }
            }
            if (!(Minecraft.func_71410_x().field_71439_g == null || this.mp3Player == null && this.oggPlayer == null || this.func_145837_r())) {
                float vol = this.getClosest();
                if (vol > 10000.0f * this.volume) {
                    if (this.mp3Player != null) {
                        this.mp3Player.setVolume(0.0f);
                    } else if (this.oggPlayer != null) {
                        this.oggPlayer.setVolume(0.0f);
                    }
                } else {
                    float v2 = 10000.0f / vol / 100.0f;
                    if (v2 > 1.0f) {
                        if (this.mp3Player != null) {
                            this.mp3Player.setVolume(1.0f * this.volume * this.volume);
                        } else if (this.oggPlayer != null) {
                            this.oggPlayer.setVolume(1.0f * this.volume * this.volume);
                        }
                    } else if (this.mp3Player != null) {
                        this.mp3Player.setVolume(v2 * this.volume * this.volume);
                    } else if (this.oggPlayer != null) {
                        this.oggPlayer.setVolume(v2 * this.volume * this.volume);
                    }
                }
                if (vol == 0.0f) {
                    this.func_145843_s();
                }
            }
        } else {
            if (this.isPlaying()) {
                if (this.loops >= 40) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTERadioBlock(this), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
                    this.loops = 0;
                } else {
                    ++this.loops;
                }
                ++this.th;
                if (this.th >= 60) {
                    for (Speaker s : this.speakers) {
                        if (this.field_145850_b.func_147439_a((int)s.x, (int)s.y, (int)s.z) instanceof BlockSpeaker) continue;
                        if (!this.field_145850_b.func_72938_d((int)((int)s.x), (int)((int)s.z)).field_76636_d) break;
                        this.speakers.remove(s);
                        break;
                    }
                }
            }
            if (this.scheduleRedstoneInput && this.listenToRedstone) {
                if (!this.scheduledRedstoneInput && this.redstoneInput) {
                    boolean bl = this.isPlaying = !this.isPlaying;
                    if (this.func_145831_w() != null) {
                        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTERadioBlock((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, this.func_145831_w(), this.streamURL, this.isPlaying, this.volume, 1));
                    }
                }
                this.redstoneInput = this.scheduledRedstoneInput;
                this.scheduleRedstoneInput = false;
                this.scheduledRedstoneInput = false;
            }
        }
    }

    public void setStreamURL(String url) {
        this.streamURL = url;
    }

    public String getStreamURL() {
        return this.streamURL;
    }

    public void addStation(String station) {
        if (station != null && !this.stations.contains(station)) {
            this.stations.add(station);
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageTERadioBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b, station, 42), this.func_145831_w().field_73011_w.field_76574_g);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145844_m();
            this.func_70296_d();
        }
    }

    public void delStation(String station) {
        if (station != null && this.stations.contains(station)) {
            this.stations.remove(station);
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageTERadioBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b, station, 43), this.func_145831_w().field_73011_w.field_76574_g);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145844_m();
            this.func_70296_d();
        }
    }

    public String getNext(String uid) {
        int idx = this.stations.indexOf(uid);
        if (idx < 0 || idx + 1 == this.stations.size()) {
            return uid;
        }
        return this.stations.get(idx + 1);
    }

    public String getPrevious(String uid) {
        int idx = this.stations.indexOf(uid);
        if (idx <= 0 || idx - 1 == this.stations.size()) {
            return uid;
        }
        return this.stations.get(idx - 1);
    }

    public void setVolume(float vol) {
        this.volume = vol;
    }

    public boolean isListeningToRedstoneInput() {
        return this.listenToRedstone;
    }

    public void setScreenColor(Integer color) {
        this.screenColor = color;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145844_m();
        this.func_70296_d();
    }

    public void setRedstoneInput(boolean input) {
        if (input) {
            this.scheduledRedstoneInput = input;
        }
        this.scheduleRedstoneInput = true;
    }

    public void setScreenText(String text) {
        this.screenText = text;
    }

    public String getScreenText() {
        return this.screenText;
    }

    public int addSpeaker(World w, double x, double y, double z) {
        int ret = this.canAddSpeaker(w, x, y, z);
        if (ret == 0) {
            this.speakers.add(new Speaker(x, y, z, w));
        }
        return ret;
    }

    public int canAddSpeaker(World w, double x, double y, double z) {
        if (this.speakers.size() >= 10) {
            return 1;
        }
        for (Speaker s : this.speakers) {
            if (s.x != x || s.y != y || s.z != z) continue;
            return 2;
        }
        return 0;
    }

    public float getVolume() {
        return this.volume;
    }

    private float getClosest() {
        float closest = (float)this.func_145835_a(Minecraft.func_71410_x().field_71439_g.field_70165_t, Minecraft.func_71410_x().field_71439_g.field_70163_u, Minecraft.func_71410_x().field_71439_g.field_70161_v);
        if (!this.speakers.isEmpty()) {
            for (Speaker s : this.speakers) {
                float distance = (float)Math.pow(Minecraft.func_71410_x().field_71439_g.func_70011_f(s.x, s.y, s.z), 2.0);
                if (!(closest > distance)) continue;
                closest = distance;
            }
        }
        return closest;
    }

    public int getScreenColor() {
        return this.screenColor;
    }

    public String getComponentName() {
        return "openfm_radio";
    }

    public int getStationCount() {
        return this.stationCount;
    }

    public void setStationCount(int stationCount) {
        this.stationCount = stationCount;
    }

    public Packet func_145844_m() {
        for (Speaker s : this.speakers) {
            PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageTERadioBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b, "", false, 1.0f, 15, s.x, s.y, s.z), this.func_145831_w().field_73011_w.field_76574_g);
        }
        if (this.streamURL != null) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTERadioBlock(this), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 30.0));
        }
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_145841_b(tagCom);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 6, tagCom);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        this.streamURL = nbt.func_74779_i("streamurl");
        this.volume = nbt.func_74760_g("volume");
        this.listenToRedstone = nbt.func_74767_n("input");
        this.redstoneInput = nbt.func_74767_n("lastInput");
        this.isPlaying = nbt.func_74767_n("lastState");
        int speakersCount = nbt.func_74762_e("speakersCount");
        this.setStationCount(nbt.func_74762_e("stationCount"));
        this.screenColor = nbt.func_74762_e("screenColor");
        this.isLocked = nbt.func_74767_n("isLocked");
        this.owner = nbt.func_74779_i("owner");
        this.screenText = nbt.func_74779_i("screenText").length() < 1 ? "OpenFM" : nbt.func_74779_i("screenText");
        for (i = 0; i < speakersCount; ++i) {
            double x = nbt.func_74769_h("speakerX" + i);
            double y = nbt.func_74769_h("speakerY" + i);
            double z = nbt.func_74769_h("speakerZ" + i);
            this.addSpeaker(this.func_145831_w(), x, y, z);
        }
        for (i = 0; i < this.getStationCount(); ++i) {
            this.stations.add(nbt.func_74779_i("station" + i));
        }
        NBTTagList var2 = nbt.func_150295_c("Items", (int)nbt.func_74732_a());
        this.RadioItemStack = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.RadioItemStack.length) continue;
            this.RadioItemStack[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        if (this.streamURL != null) {
            nbt.func_74778_a("streamurl", this.streamURL);
        }
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74757_a("input", this.listenToRedstone);
        nbt.func_74757_a("lastInput", this.redstoneInput);
        nbt.func_74757_a("lastState", this.isPlaying);
        nbt.func_74768_a("speakersCount", this.speakers.size());
        nbt.func_74768_a("screenColor", this.screenColor);
        if (this.screenText != null) {
            nbt.func_74778_a("screenText", this.screenText);
        }
        nbt.func_74757_a("isLocked", this.isLocked);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner);
        }
        for (i = 0; i < this.speakers.size(); ++i) {
            nbt.func_74780_a("speakerX" + i, this.speakers.get((int)i).x);
            nbt.func_74780_a("speakerY" + i, this.speakers.get((int)i).y);
            nbt.func_74780_a("speakerZ" + i, this.speakers.get((int)i).z);
        }
        for (i = 0; i < this.stations.size(); ++i) {
            String s = this.stations.get(i);
            if (s == null || s == null) continue;
            nbt.func_74778_a("station" + i, s);
            nbt.func_74768_a("stationCount", i + 1);
        }
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.RadioItemStack.length; ++var3) {
            if (this.RadioItemStack[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.RadioItemStack[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
    }

    public Object[] callMethod(int method, Object[] args) {
        if (method < 0 || method >= numMethods) {
            throw new IllegalArgumentException("Invalid method number");
        }
        ComputerMethod computerMethod = ComputerMethod.values()[method];
        switch (computerMethod) {
            case getAttachedSpeakerCount: {
                return new Object[]{this.speakers.size()};
            }
            case setScreenColor: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                this.setScreenColor((int)Math.round((Double)args[0]));
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_145844_m();
                this.func_70296_d();
                return new Object[]{true};
            }
            case getScreenColor: {
                return new Object[]{this.getScreenColor()};
            }
            case setListenRedstone: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                this.setRedstoneInput((Boolean)args[0]);
                return new Object[]{this.isListeningToRedstoneInput()};
            }
            case getListenRedstone: {
                return new Object[]{this.isListeningToRedstoneInput()};
            }
            case isPlaying: {
                return new Object[]{this.isPlaying()};
            }
            case stop: {
                this.stopStream();
                this.isPlaying = false;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_145844_m();
                return new Object[]{true};
            }
            case play: 
            case start: {
                try {
                    this.startStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_145844_m();
                return new Object[]{true};
            }
            case greet: {
                return new Object[]{"Lasciate ogne speranza, voi ch'intrate"};
            }
            case getAttachedSpeakers: {
                return new Object[]{this.speakers.size()};
            }
            case setScreenText: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                this.setScreenText((String)args[0]);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_145844_m();
                this.func_70296_d();
                return new Object[]{true};
            }
            case volDown: {
                float v = (float)((double)this.volume - 0.1);
                if (v > 0.0f && v <= 1.0f) {
                    this.setVolume(v);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_145844_m();
                    return new Object[]{Float.valueOf(this.getVolume())};
                }
                return new Object[]{false};
            }
            case volUp: {
                float v1 = (float)((double)this.volume + 0.1);
                if (v1 > 0.0f && v1 <= 1.0f) {
                    this.setVolume(v1);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_145844_m();
                    return new Object[]{Float.valueOf(this.getVolume())};
                }
                return new Object[]{false};
            }
            case setVol: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                Double x = new Double((Double)args[0]);
                float v2 = x.floatValue() / 10.0f + 1.0E-4f;
                if (v2 > 0.0f && v2 <= 1.0f) {
                    this.setVolume(v2);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_145844_m();
                    return new Object[]{Float.valueOf(this.getVolume())};
                }
                return new Object[]{false};
            }
            case getVol: {
                return new Object[]{Float.valueOf(this.getVolume())};
            }
            case setURL: {
                if (args.length != 1) {
                    return new Object[]{false, "Insufficient number of arguments, expected 1"};
                }
                if (args[0] != null) {
                    String tempURL = new String((byte[])args[0], StandardCharsets.UTF_8);
                    if (tempURL == null || tempURL.length() <= 1) {
                        return new Object[]{false, "Error parsing URL in packet"};
                    }
                    this.streamURL = tempURL;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.func_145844_m();
                    return new Object[]{true};
                }
                return new Object[]{false, "Error parsing URL in packet"};
            }
        }
        return new Object[]{false, "Not implemented."};
    }

    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] arguments = new Object[args.count()];
        for (int i = 0; i < args.count(); ++i) {
            arguments[i] = args.checkAny(i);
        }
        Integer methodId = methodIds.get(method);
        if (methodId == null) {
            throw new NoSuchMethodError();
        }
        return this.callMethod(methodId, arguments);
    }

    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return methodNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return "openfm_radio";
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return methodNames;
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException {
        try {
            return this.callMethod(method, arguments);
        }
        catch (Exception e) {
            throw new LuaException(e.getMessage());
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return ((Object)((Object)this)).hashCode() == other.hashCode();
    }

    public int func_70302_i_() {
        return this.RadioItemStack.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.RadioItemStack[i];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        if (this.func_70301_a(i) != null) {
            ItemStack var2 = this.func_70301_a(i);
            this.func_70299_a(i, null);
            return var2;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.RadioItemStack[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "ofm_radio";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 && itemstack.func_77973_b() instanceof ItemMemoryCard;
    }

    public void writeDataToCard() {
        if (this.func_70301_a(0) != null) {
            this.RadioItemStack[0] = new ItemStack(ContentRegistry.itemMemoryCard);
            this.RadioItemStack[0].func_77982_d(new NBTTagCompound());
            this.RadioItemStack[0].field_77990_d.func_74778_a("screenText", this.screenText);
            this.RadioItemStack[0].field_77990_d.func_74768_a("screenColor", this.screenColor);
            this.RadioItemStack[0].field_77990_d.func_74778_a("streamURL", this.streamURL);
            this.RadioItemStack[0].field_77990_d.func_74768_a("stationCount", this.stationCount);
            for (int i = 0; i < this.getStationCount(); ++i) {
                this.RadioItemStack[0].field_77990_d.func_74778_a("station" + i, this.stations.get(i));
            }
            this.RadioItemStack[0].func_151001_c(this.screenText);
        }
    }

    public void readDataFromCard() {
        if (this.func_70301_a(0) != null && this.RadioItemStack[0].func_77942_o()) {
            this.screenText = this.RadioItemStack[0].func_77978_p().func_74779_i("screenText");
            this.screenColor = this.RadioItemStack[0].func_77978_p().func_74762_e("screenColor");
            this.streamURL = this.RadioItemStack[0].func_77978_p().func_74779_i("streamURL");
            this.stationCount = this.RadioItemStack[0].func_77978_p().func_74762_e("stationCount");
            for (int i = 0; i < this.getStationCount(); ++i) {
                this.stations.add(this.RadioItemStack[0].field_77990_d.func_74779_i("station" + i));
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_145844_m();
            this.func_70296_d();
        }
    }

    static {
        ComputerMethod[] methods;
        numMethods = ComputerMethod.values().length;
        methodNames = new String[numMethods];
        for (ComputerMethod method : methods = ComputerMethod.values()) {
            TileEntityRadio.methodNames[method.ordinal()] = method.toString();
        }
        methodIds = new HashMap<String, Integer>();
        for (int i = 0; i < numMethods; ++i) {
            methodIds.put(methodNames[i], i);
        }
    }

    public static enum ComputerMethod {
        getAttachedSpeakerCount,
        setScreenColor,
        getScreenColor,
        setListenRedstone,
        getListenRedstone,
        isPlaying,
        stop,
        play,
        start,
        greet,
        setURL,
        getVol,
        setVol,
        volUp,
        volDown,
        setScreenText,
        getAttachedSpeakers;

    }
}

