/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.bymarcin.openglasses.block.OpenGlassesTerminalBlock;
import com.bymarcin.openglasses.config.Config;
import com.bymarcin.openglasses.drivers.DriverHostCard;
import com.bymarcin.openglasses.drivers.DriverTerminal;
import com.bymarcin.openglasses.event.minecraft.AnvilEvent;
import com.bymarcin.openglasses.event.minecraft.server.ServerEventHandler;
import com.bymarcin.openglasses.integration.opencomputers.ocProgramDisks;
import com.bymarcin.openglasses.integration.opensecurity.OpenSecurity;
import com.bymarcin.openglasses.item.OpenGlassesHostCard;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.manual.Manual;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.network.packet.GlassesStackNBT;
import com.bymarcin.openglasses.network.packet.HostInfoPacket;
import com.bymarcin.openglasses.network.packet.TerminalStatusPacket;
import com.bymarcin.openglasses.proxy.ClientProxy;
import com.bymarcin.openglasses.proxy.CommonProxy;
import com.bymarcin.openglasses.surface.OCServerSurface;
import com.bymarcin.openglasses.tileentity.OpenGlassesTerminalTileEntity;
import java.util.HashSet;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.DriverItem;
import li.cil.oc.api.driver.EnvironmentProvider;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import techguns.capabilities.TGExtendedPlayer;
import techguns.capabilities.TGExtendedPlayerCapProvider;

@Mod(modid="openglasses", version="@VERSION@-53", guiFactory="com.bymarcin.openglasses.config.ConfigGUI", dependencies="required-after:opencomputers@[1.7.1,);required-after:commons0815@[1.3.7,);required-after:guitoolkit;required-after:rendertoolkit;after:baubles;after:rtfm;after:opensecurity", acceptedMinecraftVersions="[1.12.2]")
public class OpenGlasses {
    public static final String MODID = "openglasses";
    static final String GUIFACTORY = "com.bymarcin.openglasses.config.ConfigGUI";
    @SidedProxy(clientSide="com.bymarcin.openglasses.proxy.ClientProxy", serverSide="com.bymarcin.openglasses.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static boolean baubles;
    public static boolean techguns;
    public static boolean absoluteRenderingAllowed;
    public static int widgetLimit;
    public static boolean opensecurity;
    private HashSet<Item> modItems = new HashSet();
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        baubles = Loader.isModLoaded((String)"baubles");
        techguns = Loader.isModLoaded((String)"techguns");
        opensecurity = Loader.isModLoaded((String)"opensecurity") && OpenSecurity.isCompatible();
        Config.preInit();
        Manual.preInit();
        NetworkRegistry.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
        OpenGlassesTerminalBlock.DEFAULT_BLOCK = new OpenGlassesTerminalBlock();
        this.modItems.add((Item)new ItemBlock((Block)OpenGlassesTerminalBlock.DEFAULT_BLOCK).setRegistryName(OpenGlassesTerminalBlock.DEFAULT_BLOCK.getRegistryName()));
        GameRegistry.registerTileEntity(OpenGlassesTerminalTileEntity.class, (ResourceLocation)new ResourceLocation(MODID, "openglassesterminalte"));
        OpenGlassesItem.DEFAULT_STACK = new ItemStack((Item)new OpenGlassesItem());
        OpenGlassesItem.initGlassesStack(OpenGlassesItem.DEFAULT_STACK);
        this.modItems.add(OpenGlassesItem.DEFAULT_STACK.func_77973_b());
        OpenGlassesHostCard.DEFAULTSTACK = new ItemStack((Item)new OpenGlassesHostCard());
        this.modItems.add(OpenGlassesHostCard.DEFAULTSTACK.func_77973_b());
        proxy.init();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Item item : this.modItems) {
            ClientProxy.registermodel(item, 0);
        }
        for (Item manualItem : Manual.items) {
            ClientProxy.registermodel(manualItem, 0);
        }
    }

    public static boolean isGlassesStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof OpenGlassesItem;
    }

    public static ItemStack getGlassesStack(EntityPlayer player) {
        if (player == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack glassesStack = (ItemStack)player.field_71071_by.field_70460_b.get(EntityEquipmentSlot.HEAD.func_188454_b());
        if (OpenGlasses.isGlassesStack(glassesStack)) {
            return glassesStack;
        }
        if (baubles && !(glassesStack = OpenGlasses.getGlassesStackBaubles(player)).func_190926_b()) {
            return glassesStack;
        }
        if (techguns && !(glassesStack = OpenGlasses.getGlassesStackTechguns(player)).func_190926_b()) {
            return glassesStack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getGlassesStackBaubles(EntityPlayer e) {
        IBaublesItemHandler handler = BaublesApi.getBaublesHandler((EntityPlayer)e);
        if (handler == null) {
            return null;
        }
        ItemStack baublesStack = handler.getStackInSlot(4);
        return OpenGlasses.isGlassesStack(baublesStack) ? baublesStack : ItemStack.field_190927_a;
    }

    public static ItemStack getGlassesStackTechguns(EntityPlayer e) {
        if (!e.hasCapability(TGExtendedPlayerCapProvider.TG_EXTENDED_PLAYER, null)) {
            return null;
        }
        TGExtendedPlayer tgExtendedPlayer = TGExtendedPlayer.get((EntityPlayer)e);
        ItemStack techgunsStack = tgExtendedPlayer.getTGInventory().func_70301_a(0);
        return OpenGlasses.isGlassesStack(techgunsStack) ? techgunsStack : ItemStack.field_190927_a;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.registerPacket(GlassesEventPacket.class, Side.SERVER);
        NetworkRegistry.registerPacket(TerminalStatusPacket.class, Side.CLIENT);
        NetworkRegistry.registerPacket(HostInfoPacket.class, Side.CLIENT);
        NetworkRegistry.registerPacket(GlassesStackNBT.class, Side.CLIENT);
        Driver.add((DriverItem)DriverHostCard.driver);
        Driver.add((EnvironmentProvider)DriverTerminal.driver);
        Driver.add((DriverItem)DriverTerminal.driver);
        Config.load();
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : this.modItems) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Item manualItem : Manual.items) {
            event.getRegistry().register((IForgeRegistryEntry)manualItem);
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)OpenGlassesTerminalBlock.DEFAULT_BLOCK);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ocProgramDisks.register();
        MinecraftForge.EVENT_BUS.register((Object)AnvilEvent.instances);
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventHandler());
        proxy.postInit();
    }

    @Mod.EventHandler
    public static void onServerStopped(FMLServerStoppedEvent event) {
        OCServerSurface.onServerStopped();
    }

    static {
        baubles = false;
        techguns = false;
        absoluteRenderingAllowed = true;
        widgetLimit = 255;
        opensecurity = false;
        creativeTab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)OpenGlassesTerminalBlock.DEFAULT_BLOCK);
            }
        };
    }
}

