/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.event.minecraft.client;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.gui.GlassesGui;
import com.bymarcin.openglasses.gui.InteractGui;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.utils.GlassesInstance;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientKeyboardEvents {
    public static KeyBinding interactGUIKey = new KeyBinding("key.openglasses.interact", (IKeyConflictContext)KeyConflictContext.IN_GAME, 46, "key.categories." + "openglasses".toLowerCase());
    public static KeyBinding stableInteractGUIKey = new KeyBinding("key.openglasses.stable_interact", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, 46, "key.categories." + "openglasses".toLowerCase());
    public static KeyBinding glassesConfigKey = new KeyBinding("key.openglasses.config", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.SHIFT, 46, "key.categories." + "openglasses".toLowerCase());
    public static KeyBinding nightvisionModeKey = new KeyBinding("key.openglasses.nightvision", (IKeyConflictContext)KeyConflictContext.IN_GAME, 49, "key.categories." + "openglasses".toLowerCase());
    public static KeyBinding thermalvisionModeKey = new KeyBinding("key.openglasses.thermalvision", (IKeyConflictContext)KeyConflictContext.IN_GAME, 48, "key.categories." + "openglasses".toLowerCase());
    public static KeyBinding openSecurityModeKey = new KeyBinding("key.openglasses.opensecurity", (IKeyConflictContext)KeyConflictContext.IN_GAME, 24, "key.categories." + "openglasses".toLowerCase());

    public ClientKeyboardEvents() {
        ClientRegistry.registerKeyBinding((KeyBinding)interactGUIKey);
        ClientRegistry.registerKeyBinding((KeyBinding)stableInteractGUIKey);
        ClientRegistry.registerKeyBinding((KeyBinding)nightvisionModeKey);
        ClientRegistry.registerKeyBinding((KeyBinding)thermalvisionModeKey);
        ClientRegistry.registerKeyBinding((KeyBinding)glassesConfigKey);
        if (OpenGlasses.opensecurity) {
            ClientRegistry.registerKeyBinding((KeyBinding)openSecurityModeKey);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (OCClientSurface.glasses.get().func_190926_b()) {
            return;
        }
        if (glassesConfigKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GlassesGui(false));
            return;
        }
        if (interactGUIKey.func_151468_f()) {
            this.openOverlay(false);
            return;
        }
        if (stableInteractGUIKey.func_151468_f()) {
            this.openOverlay(true);
            return;
        }
        for (UpgradeItem upgrade : OpenGlassesItem.upgrades) {
            upgrade.onKeyInput();
        }
    }

    private void openOverlay(boolean stable) {
        OCClientSurface.glasses.getConditions().setOverlay(true);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new InteractGui(stable));
        for (GlassesInstance.HostClient host : OCClientSurface.glasses.getHosts().values()) {
            if (!host.sendOverlayEvents) continue;
            NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(host.uuid, GlassesEventPacket.EventType.ACTIVATE_OVERLAY));
        }
    }
}

