/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.event.minecraft.client;

import com.bymarcin.openglasses.item.upgrades.UpgradeGeolyzer;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.utils.GlassesInstance;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientWorldInteractionEvents {
    @SubscribeEvent
    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty e) {
        ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_LEFT, (PlayerInteractEvent)e);
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        OCClientSurface.instance();
        if (OCClientSurface.glasses.get().func_190926_b()) {
            return;
        }
        OCClientSurface.instance();
        if (UpgradeGeolyzer.hasUpgrade(OCClientSurface.glasses.get())) {
            ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_BLOCK_LEFT, (PlayerInteractEvent)e);
        } else {
            ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_LEFT, (PlayerInteractEvent)e);
        }
    }

    @SubscribeEvent
    public static void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty e) {
        ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_RIGHT, (PlayerInteractEvent)e);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem e) {
        ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_RIGHT, (PlayerInteractEvent)e);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        OCClientSurface.instance();
        if (OCClientSurface.glasses.get().func_190926_b()) {
            return;
        }
        OCClientSurface.instance();
        if (UpgradeGeolyzer.hasUpgrade(OCClientSurface.glasses.get())) {
            ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_BLOCK_RIGHT, (PlayerInteractEvent)e);
        } else {
            ClientWorldInteractionEvents.onInteractEvent(GlassesEventPacket.EventType.INTERACT_WORLD_RIGHT, (PlayerInteractEvent)e);
        }
    }

    private static void onInteractEvent(GlassesEventPacket.EventType type, PlayerInteractEvent event) {
        OCClientSurface.instance();
        if (OCClientSurface.glasses.get().func_190926_b()) {
            return;
        }
        if (OCClientSurface.instance().getHosts().size() == 0) {
            return;
        }
        if (!event.getSide().isClient()) {
            return;
        }
        if (!event.getHand().equals((Object)EnumHand.MAIN_HAND)) {
            return;
        }
        OCClientSurface.instance();
        for (GlassesInstance.HostClient host : OCClientSurface.glasses.getHosts().values()) {
            if (!host.sendWorldEvents) continue;
            NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(host.uuid, type, event.getPos(), event.getFace()));
        }
    }
}

