/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.gui;

import ben_mkiv.guitoolkit.client.widget.prettyButton;
import ben_mkiv.guitoolkit.client.widget.prettyElement;
import ben_mkiv.guitoolkit.client.widget.prettyGuiList;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import com.bymarcin.openglasses.gui.hostGuiElement;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesNotificationsNBT;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.utils.OpenGlassesHostClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

class NotificationList
extends prettyGuiList {
    private ArrayList<ArrayList<prettyElement>> guiElements = new ArrayList();
    private ArrayList<NBTTagCompound> elements = new ArrayList();

    NotificationList(int width, int height, int top, int left, int entryHeight, int screenWidth, int screenHeight) {
        super(width, height, top, top + height, left, entryHeight, screenWidth, screenHeight);
    }

    public void update() {
        HashSet<NBTTagCompound> glassesNotifications = new HashSet<NBTTagCompound>(OpenGlassesNotificationsNBT.getNotifications(OCClientSurface.glasses.get()));
        if (this.elements.size() == glassesNotifications.size() && this.elements.containsAll(glassesNotifications)) {
            return;
        }
        this.elements.clear();
        this.guiElements.clear();
        this.elements.addAll(glassesNotifications);
        for (NBTTagCompound tag : this.elements) {
            ArrayList<LinkRequestButton> listElements = new ArrayList<LinkRequestButton>();
            switch (OpenGlassesNotificationsNBT.NotifiactionType.values()[tag.func_74762_e("type")]) {
                case LINKREQUEST: {
                    listElements.add(new LinkRequestButton(tag, 0, 22, 60, 20, "accept link", true));
                    listElements.add(new LinkRequestButton(tag, 60, 22, 60, 20, "deny link", false));
                }
            }
            this.guiElements.add(listElements);
        }
    }

    public int getSize() {
        return this.elements.size();
    }

    protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        switch (OpenGlassesNotificationsNBT.NotifiactionType.values()[this.elements.get(slotIdx).func_74762_e("type")]) {
            case LINKREQUEST: {
                this.drawLinkRequest(this.elements.get(slotIdx), slotTop, this.isSelected(slotIdx));
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        for (prettyElement element : this.guiElements.get(slotIdx)) {
            element.setRenderY(slotTop);
            element.setRenderX(this.left);
            if (!(element instanceof prettyButton)) continue;
            ((prettyButton)element).field_146124_l = this.isSelected(slotIdx);
            ((prettyButton)element).func_191745_a(mc, this.mouseX, this.mouseY, mc.func_184121_ak());
        }
    }

    protected void elementClicked(int index, boolean doubleClick) {
        for (prettyElement element : this.guiElements.get(index)) {
            if (!(element instanceof hostGuiElement.hostAction) || !(element instanceof GuiButton) || !((GuiButton)element).func_146115_a()) continue;
            element.clicked();
        }
        super.elementClicked(index, doubleClick);
    }

    private void drawLinkRequest(NBTTagCompound tag, int slotTop, boolean isSelected) {
        UUID hostUUID = tag.func_186857_a("host");
        OpenGlassesHostClient host = OCClientSurface.instance().getHost(hostUUID);
        Vec3d renderPosition = host.getRenderPosition(0.5f);
        String text = "link request";
        if (host.terminalName.length() > 0) {
            text = text + " from '" + host.terminalName + "'";
        }
        if (renderPosition.equals((Object)ClientSurface.vec3d000)) {
            text = text + " (distance: unknown)";
        } else {
            int distance = (int)Math.ceil(Minecraft.func_71410_x().field_71439_g.func_174791_d().func_72438_d(renderPosition));
            text = text + " (distance: " + distance + " blocks)";
        }
        int textColor = isSelected ? 0xFFFFFF : 0xDADADA;
        Minecraft.func_71410_x().field_71466_p.func_78276_b(text, this.left + 3, slotTop + 2, textColor);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(hostUUID.toString(), this.left + 3, slotTop + 13, textColor);
    }

    class LinkRequestButton
    extends hostGuiElement.hostButton
    implements hostGuiElement.hostAction {
        boolean acceptLinkRequest;

        LinkRequestButton(NBTTagCompound tag, int x, int y, int width, int height, String label, boolean acceptLink) {
            super(tag.func_186857_a("host"), x, y, width, height, label);
            this.acceptLinkRequest = acceptLink;
        }

        public void clicked() {
            if (!this.field_146124_l) {
                return;
            }
            if (this.acceptLinkRequest) {
                NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(this.getUniqueId(), GlassesEventPacket.EventType.ACCEPT_LINK));
            } else {
                NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(this.getUniqueId(), GlassesEventPacket.EventType.DENY_LINK));
            }
        }
    }
}

