/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.item.OpenGlassesNBT.OpenGlassesHostsNBT;
import com.bymarcin.openglasses.item.upgrades.UpgradeBatteryTier1;
import com.bymarcin.openglasses.item.upgrades.UpgradeBatteryTier2;
import com.bymarcin.openglasses.item.upgrades.UpgradeBatteryTier3;
import com.bymarcin.openglasses.item.upgrades.UpgradeDatabase1;
import com.bymarcin.openglasses.item.upgrades.UpgradeDatabase2;
import com.bymarcin.openglasses.item.upgrades.UpgradeDatabase3;
import com.bymarcin.openglasses.item.upgrades.UpgradeDaylightDetector;
import com.bymarcin.openglasses.item.upgrades.UpgradeGeolyzer;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeKeyboard;
import com.bymarcin.openglasses.item.upgrades.UpgradeMotionSensor;
import com.bymarcin.openglasses.item.upgrades.UpgradeNavigation;
import com.bymarcin.openglasses.item.upgrades.UpgradeNightvision;
import com.bymarcin.openglasses.item.upgrades.UpgradeOpenSecurity;
import com.bymarcin.openglasses.item.upgrades.UpgradeTank;
import com.bymarcin.openglasses.item.upgrades.UpgradeThermalVision;
import com.bymarcin.openglasses.manual.IItemWithDocumentation;
import com.bymarcin.openglasses.surface.OCClientSurface;
import com.bymarcin.openglasses.surface.OCServerSurface;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import techguns.api.tginventory.TGSlotType;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class OpenGlassesItem
extends ItemArmor
implements IItemWithDocumentation,
IBauble {
    public static ItemStack DEFAULT_STACK;
    public static HashSet<UpgradeItem> upgrades;

    public OpenGlassesItem() {
        super(ItemArmor.ArmorMaterial.IRON, 0, EntityEquipmentSlot.HEAD);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(OpenGlasses.creativeTab);
        this.func_77655_b("openglasses");
        this.setRegistryName("openglasses");
    }

    public static void initGlassesStack(ItemStack glassesStack) {
        glassesStack.func_77982_d(new NBTTagCompound());
        NBTTagCompound glassesTag = glassesStack.func_77978_p();
        glassesTag.func_74768_a("widgetLimit", 9);
        glassesTag.func_74768_a("upkeepCost", 1);
        glassesTag.func_74768_a("radarRange", 0);
        glassesTag.func_74768_a("Energy", 0);
        glassesTag.func_186854_a("UUID", UUID.randomUUID());
        glassesTag.func_74768_a("EnergyCapacity", 50000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack creativeGlasses = DEFAULT_STACK.func_77946_l();
        NBTTagCompound creativeTag = creativeGlasses.func_77978_p();
        creativeTag.func_74768_a("Energy", 5000000);
        creativeTag.func_74768_a("EnergyCapacity", 5000000);
        creativeTag.func_74768_a("widgetLimit", 255);
        creativeTag.func_74757_a("isCreative", true);
        creativeTag.func_74768_a("radarRange", 128);
        for (UpgradeItem upgrade : upgrades) {
            creativeGlasses = upgrade.install(creativeGlasses);
        }
        creativeTag.func_74768_a("upkeepCost", 0);
        subItems.add((Object)DEFAULT_STACK);
        subItems.add((Object)creativeGlasses);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (stack.func_77978_p() == null) {
            OpenGlassesItem.initGlassesStack(stack);
        }
        if (nbt != null) {
            NBTTagCompound stackNBT = stack.func_77978_p();
            stackNBT.func_179237_a(nbt);
        }
        return new EnergyCapabilityProvider(stack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "openglasses:textures/models/glasses.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound tag = stack.func_77978_p();
        tooltip.add("linked to " + OpenGlassesHostsNBT.getHostsFromNBT(stack).size() + " hosts");
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add("hold [\u00a7fLSHIFT\u00a77] to show upgrades");
        } else {
            for (UpgradeItem upgrade : upgrades) {
                tooltip.addAll(upgrade.getTooltip(stack));
            }
        }
        int widgetCount = OCClientSurface.instances.getWidgetCount(null, null);
        tooltip.add("\u00a73using " + widgetCount + "/" + tag.func_74762_e("widgetLimit") + " widgets\u00a77");
        int energyUsage = tag.func_74762_e("upkeepCost");
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        tooltip.add(String.format("\u00a7a%s/%s FE\u00a77", storage.getEnergyStored(), storage.getMaxEnergyStored()));
        tooltip.add("\u00a72usage " + energyUsage + " FE/tick\u00a77");
    }

    public static void upgradeUpkeepCost(ItemStack stack) {
        int upkeepCost = 1;
        if (stack.func_77978_p().func_74767_n("isCreative")) {
            upkeepCost = 0;
        } else {
            for (UpgradeItem upgrade : upgrades) {
                if (!upgrade.isInstalled(stack)) continue;
                upkeepCost += upgrade.getEnergyUsageCurrent(stack);
            }
        }
        stack.func_77978_p().func_74768_a("upkeepCost", upkeepCost);
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "Glasses";
    }

    public void func_77663_a(ItemStack glassesStack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack glasses = OpenGlasses.getGlassesStack((EntityPlayer)entity);
        if (glasses.func_190926_b()) {
            return;
        }
        if (glasses.equals(glassesStack)) {
            OpenGlassesItem.consumeEnergy(glassesStack);
        }
    }

    public boolean showDurabilityBar(ItemStack glassesStack) {
        IEnergyStorage storage = OpenGlassesItem.getEnergyStorage(glassesStack);
        return storage.getEnergyStored() < storage.getMaxEnergyStored();
    }

    public double getDurabilityForDisplay(ItemStack glassesStack) {
        IEnergyStorage storage = OpenGlassesItem.getEnergyStorage(glassesStack);
        return 1.0 - 1.0 / (double)storage.getMaxEnergyStored() * (double)storage.getEnergyStored();
    }

    private static void consumeEnergy(ItemStack glassesStack) {
        OpenGlassesItem.getEnergyStorage(glassesStack).extractEnergy(glassesStack.func_77978_p().func_74762_e("upkeepCost"), false);
    }

    public static double getEnergyStored(ItemStack glassesStack) {
        if (!glassesStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return 0.0;
        }
        return OpenGlassesItem.getEnergyStorage(glassesStack).getEnergyStored();
    }

    private static IEnergyStorage getEnergyStorage(ItemStack glassesStack) {
        return (IEnergyStorage)glassesStack.getCapability(CapabilityEnergy.ENERGY, null);
    }

    @Optional.Method(modid="techguns")
    public TGSlotType getSlot(ItemStack var1) {
        return TGSlotType.FACESLOT;
    }

    @Optional.Method(modid="techguns")
    public void onPlayerTick(ItemStack item, TickEvent.PlayerTickEvent event) {
        OpenGlassesItem.consumeEnergy(item);
    }

    @Optional.Method(modid="techguns")
    public void onEquipped(ItemStack itemstack, EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            OCServerSurface.equipmentChanged((EntityPlayerMP)player, itemstack);
        }
    }

    @Optional.Method(modid="techguns")
    public void onUnequipped(ItemStack itemstack, EntityPlayer player) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            OCServerSurface.equipmentChanged((EntityPlayerMP)player, ItemStack.field_190927_a);
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.HEAD;
    }

    @Optional.Method(modid="baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            OCServerSurface.equipmentChanged((EntityPlayerMP)player, itemstack);
        }
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            OCServerSurface.equipmentChanged((EntityPlayerMP)player, ItemStack.field_190927_a);
        }
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        OpenGlassesItem.consumeEnergy(itemstack);
    }

    static {
        upgrades = new HashSet();
        upgrades.add(new UpgradeBatteryTier1());
        upgrades.add(new UpgradeBatteryTier2());
        upgrades.add(new UpgradeBatteryTier3());
        upgrades.add(new UpgradeDatabase1());
        upgrades.add(new UpgradeDatabase2());
        upgrades.add(new UpgradeDatabase3());
        upgrades.add(new UpgradeDaylightDetector());
        upgrades.add(new UpgradeGeolyzer());
        upgrades.add(new UpgradeKeyboard());
        upgrades.add(new UpgradeMotionSensor());
        upgrades.add(new UpgradeNightvision());
        upgrades.add(new UpgradeTank());
        upgrades.add(new UpgradeNavigation());
        upgrades.add(new UpgradeThermalVision());
        if (OpenGlasses.opensecurity) {
            upgrades.add(new UpgradeOpenSecurity());
        }
    }

    private static class EnergyCapabilityProvider
    implements ICapabilityProvider {
        final EnergyStorage storage;

        EnergyCapabilityProvider(final ItemStack stack) {
            this.storage = new EnergyStorage(0, 1000, 1000){

                public int getEnergyStored() {
                    return stack.func_77978_p().func_74762_e("Energy");
                }

                public int getMaxEnergyStored() {
                    return stack.func_77978_p().func_74762_e("EnergyCapacity");
                }

                void setEnergyStored(int energy) {
                    stack.func_77978_p().func_74768_a("Energy", energy);
                }

                public int receiveEnergy(int receive, boolean simulate) {
                    int energy = this.getEnergyStored();
                    int energyReceived = Math.min(this.getMaxEnergyStored() - energy, Math.min(this.maxReceive, receive));
                    if (!simulate) {
                        this.setEnergyStored(energy + energyReceived);
                    }
                    return energyReceived;
                }

                public int extractEnergy(int extract, boolean simulate) {
                    if (!this.canExtract()) {
                        return 0;
                    }
                    int energy = this.getEnergyStored();
                    int energyExtracted = Math.min(energy, Math.min(this.maxExtract, extract));
                    if (!simulate) {
                        this.setEnergyStored(energy - energyExtracted);
                    }
                    return energyExtracted;
                }
            };
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)this.storage;
            }
            return null;
        }
    }
}

