/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item.OpenGlassesNBT;

import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.surface.OCServerSurface;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;

public class OpenGlassesHostsNBT {
    public static void link(ItemStack glassesStack, UUID hostUUID, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound newTag = new NBTTagCompound();
        newTag.func_186854_a("host", hostUUID);
        newTag.func_186854_a("userUUID", player.func_146103_bH().getId());
        newTag.func_74778_a("user", player.func_146103_bH().getName());
        newTag.func_186854_a("ownerUUID", player.func_110124_au());
        HashSet<NBTTagCompound> hosts = OpenGlassesHostsNBT.getHostsFromNBT(glassesStack);
        hosts.add(newTag);
        OpenGlassesHostsNBT.writeHostsToNBT(hosts, glassesStack);
        GlassesNBT.syncStackNBT(glassesStack, (EntityPlayerMP)player);
    }

    public static void unlink(UUID uuid, ItemStack glassesStack, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        HashSet<NBTTagCompound> hosts = OpenGlassesHostsNBT.getHostsFromNBT(glassesStack);
        hosts.remove(OpenGlassesHostsNBT.getHostFromNBT(uuid, glassesStack));
        OpenGlassesHostsNBT.writeHostsToNBT(hosts, glassesStack);
        GlassesNBT.syncStackNBT(glassesStack, (EntityPlayerMP)player);
        OCServerSurface.instance().unsubscribePlayer((EntityPlayerMP)player);
    }

    public static NBTTagCompound getHostFromNBT(UUID hostUUID, ItemStack glassesStack) {
        if (glassesStack.func_190926_b()) {
            return null;
        }
        return OpenGlassesHostsNBT.getHostFromNBT(hostUUID, glassesStack.func_77978_p());
    }

    public static NBTTagCompound getHostFromNBT(UUID hostUUID, NBTTagCompound nbt) {
        HashSet<NBTTagCompound> hosts = OpenGlassesHostsNBT.getHostsFromNBT(nbt);
        for (NBTTagCompound hostNBT : hosts) {
            if (!hostNBT.func_186857_a("host").equals(hostUUID)) continue;
            return hostNBT;
        }
        return null;
    }

    private static void writeHostsToNBT(HashSet<NBTTagCompound> hosts, ItemStack glassesStack) {
        int i = 0;
        NBTTagCompound hostsNBT = new NBTTagCompound();
        for (NBTTagCompound tag : hosts) {
            hostsNBT.func_74782_a("host" + i++, (NBTBase)tag);
        }
        glassesStack.func_77978_p().func_74782_a("hosts", (NBTBase)hostsNBT);
    }

    public static void writeHostToNBT(ItemStack glassesStack, NBTTagCompound hostNBT) {
        HashSet<NBTTagCompound> hosts = OpenGlassesHostsNBT.getHostsFromNBT(glassesStack);
        for (NBTTagCompound host : hosts) {
            if (!host.func_186857_a("host").equals(hostNBT.func_186857_a("host"))) continue;
            hosts.remove(host);
            break;
        }
        hosts.add(hostNBT);
        OpenGlassesHostsNBT.writeHostsToNBT(hosts, glassesStack);
    }

    public static HashSet<NBTTagCompound> getHostsFromNBT(ItemStack glassesStack) {
        return OpenGlassesHostsNBT.getHostsFromNBT(glassesStack.func_77978_p());
    }

    public static HashSet<NBTTagCompound> getHostsFromNBT(NBTTagCompound tag) {
        HashSet<NBTTagCompound> hosts = new HashSet<NBTTagCompound>();
        if (tag.func_74764_b("hosts")) {
            NBTTagCompound nbt = tag.func_74775_l("hosts");
            int i = 0;
            while (nbt.func_74764_b("host" + i)) {
                hosts.add(nbt.func_74775_l("host" + i));
                ++i;
            }
        }
        return hosts;
    }

    public static void setRenderResolution(Vec3d resolution, ItemStack glassesStack, UUID hostUUID) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (resolution.equals((Object)new Vec3d(0.0, 0.0, 0.0))) {
            OpenGlassesHostsNBT.removeHostInformation(glassesStack, hostUUID, "resolution");
        } else {
            nbt.func_74780_a("x", resolution.field_72450_a);
            nbt.func_74780_a("y", resolution.field_72448_b);
            OpenGlassesHostsNBT.addHostInformation(glassesStack, hostUUID, "resolution", nbt);
        }
    }

    private static void addHostInformation(ItemStack glassesStack, UUID hostUUID, String name, NBTTagCompound tag) {
        NBTTagCompound nbt = OpenGlassesHostsNBT.getHostFromNBT(hostUUID, glassesStack);
        if (nbt != null) {
            nbt.func_74782_a(name, (NBTBase)tag);
            OpenGlassesHostsNBT.writeHostToNBT(glassesStack, nbt);
        }
    }

    private static void removeHostInformation(ItemStack glassesStack, UUID hostUUID, String name) {
        NBTTagCompound nbt = OpenGlassesHostsNBT.getHostFromNBT(hostUUID, glassesStack);
        if (nbt != null && nbt.func_74764_b(name)) {
            nbt.func_82580_o(name);
            OpenGlassesHostsNBT.writeHostToNBT(glassesStack, nbt);
        }
    }
}

