/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.item.upgrades;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.event.minecraft.client.ClientKeyboardEvents;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.OCClientSurface;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UpgradeOpenSecurity
extends UpgradeItem {
    @Override
    public ItemStack install(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74767_n("opensecurity")) {
            tag.func_74757_a("opensecurity", true);
        }
        return stack;
    }

    @Override
    public int getEnergyUsage() {
        return 1;
    }

    @Override
    public int getUpgradeExperienceCost() {
        return 20;
    }

    @Override
    public boolean isUpgradeItem(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().getRegistryName().equals((Object)new ResourceLocation("opensecurity", "nanodna"));
    }

    public static boolean hasUpgrade(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("opensecurity");
    }

    @Override
    public boolean isInstalled(ItemStack stack) {
        return UpgradeOpenSecurity.hasUpgrade(stack);
    }

    @Override
    public List<String> getTooltip(ItemStack stack) {
        if (!OpenGlasses.opensecurity) {
            return new ArrayList<String>();
        }
        ArrayList<String> tooltip = new ArrayList<String>();
        if (UpgradeOpenSecurity.hasUpgrade(stack)) {
            tooltip.add("opensecurity: installed");
        } else {
            tooltip.add("opensecurity: not installed");
            tooltip.add("\u00a78requires OpenSecurity NanoDNA\u00a77");
        }
        return tooltip;
    }

    private static void setMode(ItemStack glassesStack, boolean active) {
        if (!OpenGlasses.isGlassesStack(glassesStack)) {
            return;
        }
        glassesStack.func_77978_p().func_74757_a("osActive", active);
    }

    public static boolean getMode(ItemStack glassesStack) {
        return glassesStack.func_77978_p().func_74767_n("osActive");
    }

    public static void toggleMode(EntityPlayer player) {
        ItemStack stack = OpenGlasses.getGlassesStack(player);
        if (OpenGlasses.isGlassesStack(stack)) {
            UpgradeOpenSecurity.setMode(stack, !UpgradeOpenSecurity.getMode(stack));
            player.func_146105_b((ITextComponent)new TextComponentString("opensecurity overlay active: " + UpgradeOpenSecurity.getMode(stack)), true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput() {
        if (!OpenGlasses.opensecurity || !ClientKeyboardEvents.openSecurityModeKey.func_151468_f()) {
            return;
        }
        if (!UpgradeOpenSecurity.hasUpgrade(OCClientSurface.glasses.get())) {
            return;
        }
        NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(null, GlassesEventPacket.EventType.TOGGLE_OPENSECURITY));
    }
}

