/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.lua.luafunction;

import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.common.widgets.WidgetModifier;
import com.bymarcin.openglasses.lua.LuaFunction;
import com.bymarcin.openglasses.lua.luafunction.modifiers.ModifierAutoTranslate;
import com.bymarcin.openglasses.lua.luafunction.modifiers.ModifierColor;
import com.bymarcin.openglasses.lua.luafunction.modifiers.ModifierLuaBase;
import com.bymarcin.openglasses.lua.luafunction.modifiers.ModifierRotate;
import com.bymarcin.openglasses.lua.luafunction.modifiers.ModifierScale;
import com.bymarcin.openglasses.lua.luafunction.modifiers.ModifierTranslate;
import java.util.ArrayList;
import java.util.UUID;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;

public class Modifiers
extends LuaFunction {
    @Override
    @Callback(direct=true)
    public Object[] call(Context context, Arguments arguments) {
        super.call(context, arguments);
        Widget widget = this.getSelf().getWidget();
        if (widget != null) {
            UUID hostUUID = this.getSelf().getHost().getUUID();
            int widgetId = this.getSelf().getWidgetRef();
            ArrayList<ModifierLuaBase> values = new ArrayList<ModifierLuaBase>();
            int i = 0;
            for (WidgetModifier mod : widget.WidgetModifierList.modifiers) {
                switch (mod.getType()) {
                    case COLOR: {
                        values.add(new ModifierColor(widgetId, i, hostUUID));
                        break;
                    }
                    case ROTATE: {
                        values.add(new ModifierRotate(widgetId, i, hostUUID));
                        break;
                    }
                    case SCALE: {
                        values.add(new ModifierScale(widgetId, i, hostUUID));
                        break;
                    }
                    case TRANSLATE: {
                        values.add(new ModifierTranslate(widgetId, i, hostUUID));
                        break;
                    }
                    case AUTOTRANSLATE: {
                        values.add(new ModifierAutoTranslate(widgetId, i, hostUUID));
                    }
                }
                ++i;
            }
            return new Object[]{values};
        }
        throw new RuntimeException("Component does not exists!");
    }

    @Override
    public String getName() {
        return "modifiers";
    }
}

