/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.network.packet;

import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.network.Packet;
import com.bymarcin.openglasses.surface.OCClientSurface;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GlassesStackNBT
extends Packet<GlassesStackNBT, IMessage> {
    NBTTagCompound tagCompound;

    public GlassesStackNBT(ItemStack glassesStack) {
        this.tagCompound = glassesStack.func_77978_p();
    }

    public GlassesStackNBT() {
    }

    @Override
    protected void read() throws IOException {
        this.tagCompound = this.readNBT();
    }

    @Override
    protected void write() throws IOException {
        this.writeNBT(this.tagCompound);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected IMessage executeOnClient() {
        UUID tagUUID = this.tagCompound.func_186857_a("uuid");
        ItemStack glasses = this.findGlassesStack(tagUUID);
        if (!glasses.func_190926_b()) {
            glasses.func_77982_d(this.tagCompound);
            if (!OCClientSurface.glasses.get().func_190926_b() && GlassesNBT.getUniqueId(OCClientSurface.glasses.get()).equals(tagUUID)) {
                OCClientSurface.instance().initLocalGlasses(glasses);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private ItemStack findGlassesStack(UUID uniqueId) {
        ItemStack glassesStack = OpenGlasses.getGlassesStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (!glassesStack.func_190926_b() && GlassesNBT.getUniqueId(glassesStack).equals(uniqueId)) {
            return glassesStack;
        }
        ItemStack mainHand = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (OpenGlasses.isGlassesStack(mainHand) && GlassesNBT.getUniqueId(mainHand).equals(uniqueId)) {
            return mainHand;
        }
        ItemStack offHand = Minecraft.func_71410_x().field_71439_g.func_184592_cb();
        if (OpenGlasses.isGlassesStack(offHand) && GlassesNBT.getUniqueId(offHand).equals(uniqueId)) {
            return offHand;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected IMessage executeOnServer(EntityPlayerMP player) {
        return null;
    }
}

