/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import reifnsk.minimap.GLTexture;

public class Waypoint {
    private static final int MAX_TYPE_VALUE = 1;
    public static final int NORMAL = 0;
    public static final int DEATH_POINT = 1;
    protected static final GLTexture[] FILE = new GLTexture[]{GLTexture.WAYPOINT1, GLTexture.WAYPOINT2};
    protected static final GLTexture[] MARKER = new GLTexture[]{GLTexture.MARKER1, GLTexture.MARKER2};
    public String name;
    public int x;
    public int y;
    public int z;
    public boolean enable;
    public float red;
    public float green;
    public float blue;
    public int type;

    public Waypoint(String name, int x, int y, int z, boolean flag, float r, float g, float b) {
        this.name = name == null ? "" : name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.enable = flag;
        this.red = r;
        this.green = g;
        this.blue = b;
    }

    protected Waypoint(String name, int x, int y, int z, boolean flag, float r, float g, float b, int type) {
        this.name = name == null ? "" : name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.enable = flag;
        this.red = r;
        this.green = g;
        this.blue = b;
        this.type = Math.max(0, type <= 1 ? type : 0);
    }

    protected Waypoint(Waypoint pt) {
        this.set(pt);
    }

    protected void set(Waypoint pt) {
        this.name = pt.name;
        this.x = pt.x;
        this.y = pt.y;
        this.z = pt.z;
        this.enable = pt.enable;
        this.red = pt.red;
        this.green = pt.green;
        this.blue = pt.blue;
        this.type = Math.max(0, pt.type <= 1 ? pt.type : 0);
    }

    protected static Waypoint load(String line) {
        try {
            String[] elements = line.split(":");
            String name = elements[0];
            int x = Integer.parseInt(elements[1]);
            int y = Integer.parseInt(elements[2]);
            int z = Integer.parseInt(elements[3]);
            boolean flag = Boolean.parseBoolean(elements[4]);
            int rgb = Integer.parseInt(elements[5], 16);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb >> 0 & 0xFF) / 255.0f;
            int type = elements.length >= 7 ? Integer.parseInt(elements[6]) : 0;
            return new Waypoint(name, x, y, z, flag, r, g, b, type);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String toString() {
        int r = (int)(this.red * 255.0f) & 0xFF;
        int g = (int)(this.green * 255.0f) & 0xFF;
        int b = (int)(this.blue * 255.0f) & 0xFF;
        int rgb = r << 16 | g << 8 | b;
        return String.format(this.type == 0 ? "%s:%d:%d:%d:%s:%06X" : "%s:%d:%d:%d:%s:%06X:%d", this.name, this.x, this.y, this.z, this.enable, rgb, this.type);
    }
}

