/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smart.moving.IEntityPlayerSP;
import net.smart.moving.Orientation;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.config.SmartMovingOptions;

public abstract class SmartMovingBase
extends SmartMovingContext {
    public final EntityPlayer sp;
    public final EntityPlayerSP esp;
    public final IEntityPlayerSP isp;
    public static final int CollidedPositiveX = 1;
    public static final int CollidedNegativeX = 2;
    public static final int CollidedPositiveY = 4;
    public static final int CollidedNegativeY = 8;
    public static final int CollidedPositiveZ = 16;
    public static final int CollidedNegativeZ = 32;

    public SmartMovingBase(EntityPlayer sp, IEntityPlayerSP isp) {
        this.sp = sp;
        this.isp = isp;
        if (sp instanceof EntityPlayerSP) {
            this.esp = (EntityPlayerSP)sp;
            if (Minecraft.func_71410_x().field_71439_g == null) {
                Options.resetForNewGame();
                Config = Options;
            }
        } else {
            this.esp = null;
        }
    }

    protected void moveFlying(float moveUpward, float moveStrafing, float moveForward, float speedFactor, boolean treeDimensional) {
        float diffMotionXStrafing = 0.0f;
        float diffMotionXForward = 0.0f;
        float diffMotionZStrafing = 0.0f;
        float diffMotionZForward = 0.0f;
        float total = MathHelper.func_76129_c((float)(moveStrafing * moveStrafing + moveForward * moveForward));
        if (total >= 0.01f) {
            if (total < 1.0f) {
                total = 1.0f;
            }
            float moveStrafingFactor = moveStrafing / total;
            float moveForwardFactor = moveForward / total;
            float sin = MathHelper.func_76126_a((float)(this.sp.field_70177_z * 3.141593f / 180.0f));
            float cos = MathHelper.func_76134_b((float)(this.sp.field_70177_z * 3.141593f / 180.0f));
            diffMotionXStrafing = moveStrafingFactor * cos;
            diffMotionXForward = -moveForwardFactor * sin;
            diffMotionZStrafing = moveStrafingFactor * sin;
            diffMotionZForward = moveForwardFactor * cos;
        }
        float rotation = treeDimensional ? this.sp.field_70125_A / 57.295776f : 0.0f;
        float divingHorizontalFactor = MathHelper.func_76134_b((float)rotation);
        float divingVerticalFactor = -MathHelper.func_76126_a((float)rotation) * Math.signum(moveForward);
        float diffMotionX = diffMotionXForward * divingHorizontalFactor + diffMotionXStrafing;
        float diffMotionY = MathHelper.func_76129_c((float)(diffMotionXForward * diffMotionXForward + diffMotionZForward * diffMotionZForward)) * divingVerticalFactor + moveUpward;
        float diffMotionZ = diffMotionZForward * divingHorizontalFactor + diffMotionZStrafing;
        float total2 = MathHelper.func_76129_c((float)(MathHelper.func_76129_c((float)(diffMotionX * diffMotionX + diffMotionZ * diffMotionZ)) + diffMotionY * diffMotionY));
        if (total2 > 0.01f) {
            float factor = speedFactor / total2;
            this.sp.field_70159_w += (double)(diffMotionX * factor);
            this.sp.field_70181_x += (double)(diffMotionY * factor);
            this.sp.field_70179_y += (double)(diffMotionZ * factor);
        }
    }

    protected Block supportsCeilingClimbing(int i, int j, int k) {
        String blockName;
        Block block = this.sp.field_70170_p.func_147439_a(i, j, k);
        if (block == null) {
            return null;
        }
        Dictionary configuration = (Dictionary)SmartMovingBase.Config._ceilingClimbConfigurationObject.value;
        Set metaDatas = (Set)configuration.get(block);
        if (metaDatas == null && (blockName = block.func_149739_a()) != null && !blockName.isEmpty() && (metaDatas = (Set)configuration.get(blockName)) == null && blockName.startsWith("tile.") && blockName.length() > 5) {
            metaDatas = (Set)configuration.get(blockName.substring(5));
        }
        if (metaDatas == null) {
            return null;
        }
        if (metaDatas.isEmpty()) {
            return block;
        }
        if (metaDatas.contains(this.sp.field_70170_p.func_72805_g(i, j, k))) {
            return block;
        }
        return null;
    }

    protected boolean isLava(Block block) {
        if (block == Block.func_149684_b((String)"lava") || block == Block.func_149684_b((String)"flowing_lava")) {
            return true;
        }
        return block != null && block.func_149688_o() == Material.field_151587_i;
    }

    protected float getLiquidBorder(int i, int j, int k) {
        Block block = this.sp.field_70170_p.func_147439_a(i, j, k);
        if (block == Block.func_149684_b((String)"water") || block == Block.func_149684_b((String)"flowing_water")) {
            return this.getNormalWaterBorder(i, j, k);
        }
        if (SmartMovingOptions.hasFiniteLiquid) {
            float f;
            float finiteLiquidBorder = this.getFiniteLiquidWaterBorder(i, j, k, block);
            if (f > 0.0f) {
                return finiteLiquidBorder;
            }
        }
        if (block == Block.func_149684_b((String)"lava") || block == Block.func_149684_b((String)"flowing_lava")) {
            return (Boolean)SmartMovingBase.Config._lavaLikeWater.value != false ? this.getNormalWaterBorder(i, j, k) : 0.0f;
        }
        Material material = this.sp.field_70170_p.func_147439_a(i, j, k).func_149688_o();
        if (material == null || material == Material.field_151587_i) {
            return (Boolean)SmartMovingBase.Config._lavaLikeWater.value != false ? 1.0f : 0.0f;
        }
        if (material == Material.field_151586_h) {
            return this.getNormalWaterBorder(i, j, k);
        }
        if (material.func_76224_d()) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected float getNormalWaterBorder(int i, int j, int k) {
        int blockMetaData = this.sp.field_70170_p.func_72805_g(i, j, k);
        if (blockMetaData >= 8) {
            return 1.0f;
        }
        if (blockMetaData == 0) {
            if (this.sp.field_70170_p.func_147437_c(i, j + 1, k)) {
                return 0.8875f;
            }
            return 1.0f;
        }
        return (float)(8 - blockMetaData) / 8.0f;
    }

    protected float getFiniteLiquidWaterBorder(int i, int j, int k, Block block) {
        int type = Orientation.getFiniteLiquidWater(block);
        if (type > 0) {
            if (type == 2) {
                return 1.0f;
            }
            if (type == 1) {
                Block aboveBlock = this.sp.field_70170_p.func_147439_a(i, j + 1, k);
                if (Orientation.getFiniteLiquidWater(aboveBlock) > 0) {
                    return 1.0f;
                }
                return (float)(this.sp.field_70170_p.func_72805_g(i, j, k) + 1) / 16.0f;
            }
        }
        return 0.0f;
    }

    public boolean isFacedToLadder(boolean isSmall) {
        return this.getOnLadder(1, true, isSmall) > 0;
    }

    public boolean isFacedToSolidVine(boolean isSmall) {
        return this.getOnVine(1, true, isSmall) > 0;
    }

    public boolean isOnLadderOrVine(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, isSmall) > 0;
    }

    public boolean isOnVine(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, false, true, isSmall) > 0;
    }

    public boolean isOnLadder(boolean isSmall) {
        return this.getOnLadderOrVine(1, false, true, false, isSmall) > 0;
    }

    protected int getOnLadder(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, true, false, isSmall);
    }

    protected int getOnVine(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, false, true, isSmall);
    }

    protected int getOnLadderOrVine(int maxResult, boolean faceOnly, boolean isSmall) {
        return this.getOnLadderOrVine(maxResult, faceOnly, true, true, isSmall);
    }

    protected int getOnLadderOrVine(int maxResult, boolean faceOnly, boolean ladder, boolean vine, boolean isSmall) {
        int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int minj = MathHelper.func_76128_c((double)this.sp.field_70121_D.field_72338_b);
        int k = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        if (Config.isStandardBaseClimb()) {
            Block block = this.sp.field_70170_p.func_147439_a(i, minj, k);
            if (ladder) {
                if (vine) {
                    return Orientation.isClimbable(this.sp.field_70170_p, i, minj, k) ? 1 : 0;
                }
                return block != Block.func_149684_b((String)"vine") && Orientation.isClimbable(this.sp.field_70170_p, i, minj, k) ? 1 : 0;
            }
            if (vine) {
                return block == Block.func_149684_b((String)"vine") && Orientation.isClimbable(this.sp.field_70170_p, i, minj, k) ? 1 : 0;
            }
            return 0;
        }
        if (isSmall) {
            --minj;
        }
        HashSet<Orientation> facedOnlyTo = null;
        if (faceOnly) {
            facedOnlyTo = Orientation.getClimbingOrientations(this.sp, true, false);
        }
        int result = 0;
        int maxj = MathHelper.func_76128_c((double)(this.sp.field_70121_D.field_72338_b + Math.ceil(this.sp.field_70121_D.field_72337_e - this.sp.field_70121_D.field_72338_b))) - 1;
        for (int j = minj; j <= maxj; ++j) {
            Block block = this.sp.field_70170_p.func_147439_a(i, j, k);
            if (ladder) {
                boolean localLadder = Orientation.isKnownLadder(block);
                Orientation localLadderOrientation = null;
                if (localLadder) {
                    localLadderOrientation = Orientation.getKnownLadderOrientation(this.sp.field_70170_p, i, j, k);
                    if (facedOnlyTo == null || facedOnlyTo.contains((Object)localLadderOrientation)) {
                        ++result;
                    }
                }
                for (Orientation direction : facedOnlyTo != null ? facedOnlyTo : Orientation.Orthogonals) {
                    Orientation remoteLadderOrientation;
                    Block remoteBlock;
                    if (result >= maxResult) {
                        return result;
                    }
                    if (direction == localLadderOrientation || !Orientation.isKnownLadder(remoteBlock = this.sp.field_70170_p.func_147439_a(i + direction._i, j, k + direction._k)) || (remoteLadderOrientation = Orientation.getKnownLadderOrientation(this.sp.field_70170_p, i + direction._i, j, k + direction._k)).rotate(180) != direction) continue;
                    ++result;
                }
            }
            if (result >= maxResult) {
                return result;
            }
            if (vine && Orientation.isVine(block)) {
                if (facedOnlyTo == null) {
                    ++result;
                } else {
                    for (Orientation climbOrientation : facedOnlyTo) {
                        if (!climbOrientation.hasVineOrientation(this.sp.field_70170_p, i, j, k) || !climbOrientation.isRemoteSolid(this.sp.field_70170_p, i, j, k)) continue;
                        ++result;
                        break;
                    }
                }
            }
            if (result < maxResult) continue;
            return result;
        }
        return result;
    }

    public boolean climbingUpIsBlockedByLadder() {
        int k;
        int j;
        int i;
        Orientation orientation;
        if (this.sp.field_70123_F && this.sp.field_70124_G && !this.sp.field_70122_E && this.esp.field_71158_b.field_78900_b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && Orientation.isLadder(this.sp.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.sp.field_70165_t), j = MathHelper.func_76128_c((double)this.sp.field_70121_D.field_72337_e), k = MathHelper.func_76128_c((double)this.sp.field_70161_v)))) {
            return Orientation.getKnownLadderOrientation(this.sp.field_70170_p, i, j, k) == orientation;
        }
        return false;
    }

    public boolean climbingUpIsBlockedByTrapDoor() {
        int k;
        int j;
        int i;
        Orientation orientation;
        if (this.sp.field_70123_F && this.sp.field_70124_G && !this.sp.field_70122_E && this.esp.field_71158_b.field_78900_b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && Orientation.isTrapDoor(this.sp.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.sp.field_70165_t), j = MathHelper.func_76128_c((double)this.sp.field_70121_D.field_72337_e), k = MathHelper.func_76128_c((double)this.sp.field_70161_v)))) {
            return Orientation.getOpenTrapDoorOrientation(this.sp.field_70170_p, i, j, k) == orientation;
        }
        return false;
    }

    public boolean climbingUpIsBlockedByCobbleStoneWall() {
        int k;
        int j;
        int i;
        Orientation orientation;
        if (this.sp.field_70123_F && this.sp.field_70124_G && !this.sp.field_70122_E && this.esp.field_71158_b.field_78900_b > 0.0f && (orientation = Orientation.getOrientation(this.sp, 20.0f, true, false)) != null && this.sp.field_70170_p.func_147439_a(i = MathHelper.func_76128_c((double)this.sp.field_70165_t), j = MathHelper.func_76128_c((double)this.sp.field_70121_D.field_72337_e), k = MathHelper.func_76128_c((double)this.sp.field_70161_v)) == Block.func_149684_b((String)"cobblestone_wall")) {
            return !((BlockWall)Block.func_149684_b((String)"cobblestone_wall")).func_150091_e((IBlockAccess)this.sp.field_70170_p, i - orientation._i, j, k - orientation._k);
        }
        return false;
    }

    private List<?> getPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        double minY = this.sp.field_70121_D.field_72338_b;
        double maxY = this.sp.field_70121_D.field_72337_e;
        this.sp.field_70121_D.field_72338_b = yMin;
        this.sp.field_70121_D.field_72337_e = yMax;
        List result = this.sp.field_70170_p.func_72945_a((Entity)this.sp, horizontalTolerance == 0.0 ? this.sp.field_70121_D : this.sp.field_70121_D.func_72331_e(-horizontalTolerance, 0.0, -horizontalTolerance));
        this.sp.field_70121_D.field_72338_b = minY;
        this.sp.field_70121_D.field_72337_e = maxY;
        return result;
    }

    protected boolean isPlayerInSolidBetween(double yMin, double yMax) {
        return this.getPlayerSolidBetween(yMin, yMax, 0.0).size() > 0;
    }

    protected double getMaxPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        List<?> solids = this.getPlayerSolidBetween(yMin, yMax, horizontalTolerance);
        double result = yMin;
        for (int i = 0; i < solids.size(); ++i) {
            AxisAlignedBB box = (AxisAlignedBB)solids.get(i);
            if (!this.isCollided(box, yMin, yMax, horizontalTolerance)) continue;
            result = Math.max(result, box.field_72337_e);
        }
        return Math.min(result, yMax);
    }

    protected double getMinPlayerSolidBetween(double yMin, double yMax, double horizontalTolerance) {
        List<?> solids = this.getPlayerSolidBetween(yMin, yMax, horizontalTolerance);
        double result = yMax;
        for (int i = 0; i < solids.size(); ++i) {
            AxisAlignedBB box = (AxisAlignedBB)solids.get(i);
            if (!this.isCollided(box, yMin, yMax, horizontalTolerance)) continue;
            result = Math.min(result, box.field_72338_b);
        }
        return Math.max(result, yMin);
    }

    protected boolean isInLiquid() {
        return this.getMaxPlayerLiquidBetween(this.sp.field_70121_D.field_72338_b, this.sp.field_70121_D.field_72337_e) != this.sp.field_70121_D.field_72338_b || this.getMinPlayerLiquidBetween(this.sp.field_70121_D.field_72338_b, this.sp.field_70121_D.field_72337_e) != this.sp.field_70121_D.field_72337_e;
    }

    protected double getMaxPlayerLiquidBetween(double yMin, double yMax) {
        int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int jMin = MathHelper.func_76128_c((double)yMin);
        int jMax = MathHelper.func_76128_c((double)yMax);
        int k = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        for (int j = jMax; j >= jMin; --j) {
            float swimWaterBorder = this.getLiquidBorder(i, j, k);
            if (!(swimWaterBorder > 0.0f)) continue;
            return (float)j + swimWaterBorder;
        }
        return yMin;
    }

    protected double getMinPlayerLiquidBetween(double yMin, double yMax) {
        int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int jMin = MathHelper.func_76128_c((double)yMin);
        int jMax = MathHelper.func_76128_c((double)yMax);
        int k = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        for (int j = jMin; j <= jMax; ++j) {
            float swimWaterBorder = this.getLiquidBorder(i, j, k);
            if (!(swimWaterBorder > 0.0f)) continue;
            if ((double)j > yMin) {
                return j;
            }
            if (!((double)((float)j + swimWaterBorder) > yMin)) continue;
            return yMin;
        }
        return yMax;
    }

    public boolean isCollided(AxisAlignedBB box, double yMin, double yMax, double horizontalTolerance) {
        return box.field_72336_d >= this.sp.field_70121_D.field_72340_a - horizontalTolerance && box.field_72340_a <= this.sp.field_70121_D.field_72336_d + horizontalTolerance && box.field_72337_e >= yMin && box.field_72338_b <= yMax && box.field_72334_f >= this.sp.field_70121_D.field_72339_c - horizontalTolerance && box.field_72339_c <= this.sp.field_70121_D.field_72334_f + horizontalTolerance;
    }

    private boolean isBlockTranslucent(int i, int j, int k) {
        return this.sp.field_70170_p.func_147445_c(i, j, k, false);
    }

    public boolean pushOutOfBlocks(double d, double d1, double d2, boolean top) {
        int i = MathHelper.func_76128_c((double)d);
        int j = MathHelper.func_76128_c((double)d1);
        int k = MathHelper.func_76128_c((double)d2);
        double d3 = d - (double)i;
        double d4 = d2 - (double)k;
        if (this.isBlockTranslucent(i, j, k) || top && this.isBlockTranslucent(i, j + 1, k)) {
            boolean flag = !this.isBlockTranslucent(i - 1, j, k) && (!top || !this.isBlockTranslucent(i - 1, j + 1, k));
            boolean flag1 = !this.isBlockTranslucent(i + 1, j, k) && (!top || !this.isBlockTranslucent(i + 1, j + 1, k));
            boolean flag2 = !this.isBlockTranslucent(i, j, k - 1) && (!top || !this.isBlockTranslucent(i, j + 1, k - 1));
            boolean flag3 = !this.isBlockTranslucent(i, j, k + 1) && (!top || !this.isBlockTranslucent(i, j + 1, k + 1));
            int byte0 = -1;
            double d5 = 9999.0;
            if (flag && d3 < d5) {
                d5 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d5) {
                d5 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d5) {
                d5 = d4;
                byte0 = 4;
            }
            if (flag3 && 1.0 - d4 < d5) {
                byte0 = 5;
            }
            float f = 0.1f;
            if (byte0 == 0) {
                this.sp.field_70159_w = -f;
            }
            if (byte0 == 1) {
                this.sp.field_70159_w = f;
            }
            if (byte0 == 4) {
                this.sp.field_70179_y = -f;
            }
            if (byte0 == 5) {
                this.sp.field_70179_y = f;
            }
        }
        return false;
    }

    public boolean isInsideOfMaterial(Material material) {
        if (SmartMovingOptions.hasFiniteLiquid && material == Material.field_151586_h) {
            int k;
            int j;
            double d = this.sp.field_70163_u + (double)this.sp.func_70047_e();
            int i = MathHelper.func_76128_c((double)this.sp.field_70165_t);
            Block l = this.sp.field_70170_p.func_147439_a(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d)), k = MathHelper.func_76128_c((double)this.sp.field_70161_v));
            if (l != null) {
                float f;
                float border = this.getFiniteLiquidWaterBorder(i, j, k, l);
                if (f > 0.0f) {
                    float f2 = 1.0f - border - 0.1111111f;
                    float f1 = (float)(j + 1) - f2;
                    return d < (double)f1;
                }
            }
            return false;
        }
        return this.isp.localIsInsideOfMaterial(material);
    }

    public int calculateSeparateCollisions(double par1, double par3, double par5) {
        boolean flag;
        float ySize = this.sp.field_70139_V;
        boolean isInWeb = this.isp.getIsInWebField();
        AxisAlignedBB boundingBox = this.sp.field_70121_D.func_72329_c();
        boolean onGround = this.sp.field_70122_E;
        World worldObj = this.sp.field_70170_p;
        EntityPlayer _this = this.sp;
        boolean field_9293_aM = this.sp.field_70135_K;
        float stepHeight = this.sp.field_70138_W;
        ySize *= 0.4f;
        if (isInWeb) {
            isInWeb = false;
            par1 *= 0.25;
            par3 *= (double)0.05f;
            par5 *= 0.25;
        }
        double d2 = par1;
        double d3 = par3;
        double d4 = par5;
        AxisAlignedBB axisalignedbb = boundingBox.func_72329_c();
        boolean bl = flag = onGround && this.isSneaking();
        if (flag) {
            double d5 = 0.05;
            while (par1 != 0.0 && worldObj.func_72945_a((Entity)_this, boundingBox.func_72325_c(par1, -1.0, 0.0)).size() == 0) {
                par1 = par1 < d5 && par1 >= -d5 ? 0.0 : (par1 > 0.0 ? (par1 -= d5) : (par1 += d5));
                d2 = par1;
            }
            while (par5 != 0.0 && worldObj.func_72945_a((Entity)_this, boundingBox.func_72325_c(0.0, -1.0, par5)).size() == 0) {
                par5 = par5 < d5 && par5 >= -d5 ? 0.0 : (par5 > 0.0 ? (par5 -= d5) : (par5 += d5));
                d4 = par5;
            }
            while (par1 != 0.0 && par5 != 0.0 && worldObj.func_72945_a((Entity)_this, boundingBox.func_72325_c(par1, -1.0, par5)).size() == 0) {
                par1 = par1 < d5 && par1 >= -d5 ? 0.0 : (par1 > 0.0 ? (par1 -= d5) : (par1 += d5));
                par5 = par5 < d5 && par5 >= -d5 ? 0.0 : (par5 > 0.0 ? (par5 -= d5) : (par5 += d5));
                d2 = par1;
                d4 = par5;
            }
        }
        List list = worldObj.func_72945_a((Entity)_this, boundingBox.func_72321_a(par1, par3, par5));
        for (int i = 0; i < list.size(); ++i) {
            par3 = ((AxisAlignedBB)list.get(i)).func_72323_b(boundingBox, par3);
        }
        boundingBox.func_72317_d(0.0, par3, 0.0);
        if (!field_9293_aM && d3 != par3) {
            par5 = 0.0;
            par3 = 0.0;
            par1 = 0.0;
        }
        boolean flag1 = onGround || d3 != par3 && d3 < 0.0;
        for (int j = 0; j < list.size(); ++j) {
            par1 = ((AxisAlignedBB)list.get(j)).func_72316_a(boundingBox, par1);
        }
        boundingBox.func_72317_d(par1, 0.0, 0.0);
        if (!field_9293_aM && d2 != par1) {
            par5 = 0.0;
            par3 = 0.0;
            par1 = 0.0;
        }
        for (int k = 0; k < list.size(); ++k) {
            par5 = ((AxisAlignedBB)list.get(k)).func_72322_c(boundingBox, par5);
        }
        boundingBox.func_72317_d(0.0, 0.0, par5);
        if (!field_9293_aM && d4 != par5) {
            par5 = 0.0;
            par3 = 0.0;
            par1 = 0.0;
        }
        if (stepHeight > 0.0f && flag1 && (flag || ySize < 0.05f) && (d2 != par1 || d4 != par5)) {
            double d6 = par1;
            double d8 = par3;
            double d10 = par5;
            par1 = d2;
            par3 = stepHeight;
            par5 = d4;
            AxisAlignedBB axisalignedbb1 = boundingBox.func_72329_c();
            boundingBox.func_72328_c(axisalignedbb);
            List list1 = worldObj.func_72945_a((Entity)_this, boundingBox.func_72321_a(par1, par3, par5));
            for (int j2 = 0; j2 < list1.size(); ++j2) {
                par3 = ((AxisAlignedBB)list1.get(j2)).func_72323_b(boundingBox, par3);
            }
            boundingBox.func_72317_d(0.0, par3, 0.0);
            if (!field_9293_aM && d3 != par3) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            for (int k2 = 0; k2 < list1.size(); ++k2) {
                par1 = ((AxisAlignedBB)list1.get(k2)).func_72316_a(boundingBox, par1);
            }
            boundingBox.func_72317_d(par1, 0.0, 0.0);
            if (!field_9293_aM && d2 != par1) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            for (int l2 = 0; l2 < list1.size(); ++l2) {
                par5 = ((AxisAlignedBB)list1.get(l2)).func_72322_c(boundingBox, par5);
            }
            boundingBox.func_72317_d(0.0, 0.0, par5);
            if (!field_9293_aM && d4 != par5) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            }
            if (!field_9293_aM && d3 != par3) {
                par5 = 0.0;
                par3 = 0.0;
                par1 = 0.0;
            } else {
                par3 = -stepHeight;
                for (int i3 = 0; i3 < list1.size(); ++i3) {
                    par3 = ((AxisAlignedBB)list1.get(i3)).func_72323_b(boundingBox, par3);
                }
                boundingBox.func_72317_d(0.0, par3, 0.0);
            }
            if (d6 * d6 + d10 * d10 >= par1 * par1 + par5 * par5) {
                par1 = d6;
                par3 = d8;
                par5 = d10;
                boundingBox.func_72328_c(axisalignedbb1);
            } else {
                double d11 = boundingBox.field_72338_b - (double)((int)boundingBox.field_72338_b);
                if (d11 > 0.0) {
                    ySize = (float)((double)ySize + (d11 + 0.01));
                }
            }
        }
        boolean isCollidedPositiveX = d2 > par1;
        boolean isCollidedNegativeX = d2 < par1;
        boolean isCollidedPositiveY = d3 > par3;
        boolean isCollidedNegativeY = d3 < par3;
        boolean isCollidedPositiveZ = d4 > par5;
        boolean isCollidedNegativeZ = d4 < par5;
        int result = 0;
        if (isCollidedPositiveX) {
            ++result;
        }
        if (isCollidedNegativeX) {
            result += 2;
        }
        if (isCollidedPositiveY) {
            result += 4;
        }
        if (isCollidedNegativeY) {
            result += 8;
        }
        if (isCollidedPositiveZ) {
            result += 16;
        }
        if (isCollidedNegativeZ) {
            result += 32;
        }
        return result;
    }

    public boolean isSneaking() {
        return this.sp.func_70093_af();
    }

    public void correctOnUpdate(boolean isSmall, boolean reverseMaterialAcceleration) {
        double d = this.sp.field_70165_t - this.sp.field_70169_q;
        double d1 = this.sp.field_70161_v - this.sp.field_70166_s;
        float f = MathHelper.func_76133_a((double)(d * d + d1 * d1));
        if (f < 0.05f && (double)f > 0.02 && isSmall) {
            float f5;
            float f4;
            float f1 = this.sp.field_70761_aq;
            f1 = (float)Math.atan2(d1, d) * 180.0f / 3.141593f - 90.0f;
            if (this.sp.field_70733_aJ > 0.0f) {
                f1 = this.sp.field_70177_z;
            }
            for (f4 = f1 - this.sp.field_70761_aq; f4 < -180.0f; f4 += 360.0f) {
            }
            while (f4 >= 180.0f) {
                f4 -= 360.0f;
            }
            float x = this.sp.field_70761_aq + f4 * 0.3f;
            for (f5 = this.sp.field_70177_z - x; f5 < -180.0f; f5 += 360.0f) {
            }
            while (f5 >= 180.0f) {
                f5 -= 360.0f;
            }
            if (f5 < -75.0f) {
                f5 = -75.0f;
            }
            if (f5 >= 75.0f) {
                f5 = 75.0f;
            }
            this.sp.field_70761_aq = this.sp.field_70177_z - f5;
            if (f5 * f5 > 2500.0f) {
                this.sp.field_70761_aq += f5 * 0.2f;
            }
            while (this.sp.field_70761_aq - this.sp.field_70760_ar < -180.0f) {
                this.sp.field_70760_ar -= 360.0f;
            }
            while (this.sp.field_70761_aq - this.sp.field_70760_ar >= 180.0f) {
                this.sp.field_70760_ar += 360.0f;
            }
        }
        if (reverseMaterialAcceleration) {
            this.reverseHandleMaterialAcceleration();
        }
    }

    protected double getGapUnderneight() {
        return this.sp.field_70121_D.field_72338_b - this.getMaxPlayerSolidBetween(this.sp.field_70121_D.field_72338_b - 1.1, this.sp.field_70121_D.field_72338_b, 0.0);
    }

    protected double getGapOverneight() {
        return this.getMinPlayerSolidBetween(this.sp.field_70121_D.field_72337_e, this.sp.field_70121_D.field_72337_e + 1.1, 0.0) - this.sp.field_70121_D.field_72337_e;
    }

    public double getOverGroundHeight(double maximum) {
        if (this.esp != null) {
            return this.sp.field_70121_D.field_72338_b - this.getMaxPlayerSolidBetween(this.sp.field_70121_D.field_72338_b - maximum, this.sp.field_70121_D.field_72338_b, 0.0);
        }
        return this.sp.field_70121_D.field_72338_b + 1.0 - this.getMaxPlayerSolidBetween(this.sp.field_70121_D.field_72338_b - maximum + 1.0, this.sp.field_70121_D.field_72338_b + 1.0, 0.1);
    }

    public Block getOverGroundBlockId(double distance) {
        int x = MathHelper.func_76128_c((double)this.sp.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.sp.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.sp.field_70161_v);
        int minY = y - (int)Math.ceil(distance);
        if (this.esp == null) {
            ++y;
            ++minY;
        }
        while (y >= minY) {
            Block block = this.sp.field_70170_p.func_147439_a(x, y, z);
            if (block != null) {
                return block;
            }
            --y;
        }
        return null;
    }

    public void reverseHandleMaterialAcceleration() {
        int j1;
        AxisAlignedBB axisalignedbb = this.sp.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001);
        Material material = Material.field_151586_h;
        EntityPlayer entity = this.sp;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(axisalignedbb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(axisalignedbb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        if (!entity.field_70170_p.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(axisalignedbb.field_72334_f + 1.0)))) {
            return;
        }
        Vec3 vec3d = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d1;
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == null || block.func_149688_o() != material || !((double)l >= (d1 = (double)((float)(l1 + 1) - BlockLiquid.func_149801_b((int)entity.field_70170_p.func_72805_g(k1, l1, i2)))))) continue;
                    block.func_149640_a(entity.field_70170_p, k1, l1, i2, (Entity)entity, vec3d);
                }
            }
        }
        if (vec3d.func_72433_c() > 0.0) {
            vec3d = vec3d.func_72432_b();
            double d = -0.014;
            entity.field_70159_w += vec3d.field_72450_a * d;
            entity.field_70181_x += vec3d.field_72448_b * d;
            entity.field_70179_y += vec3d.field_72449_c * d;
        }
    }
}

