/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C17PacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.smart.moving.IEntityPlayerMP;
import net.smart.moving.IPacketReceiver;
import net.smart.moving.IPacketSender;
import net.smart.moving.SmartMovingContext;
import net.smart.moving.SmartMovingFactory;
import net.smart.moving.SmartMovingOther;
import net.smart.moving.SmartMovingPacketStream;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.properties.Property;

public class SmartMovingComm
extends SmartMovingContext
implements IPacketReceiver,
IPacketSender {
    public static final SmartMovingComm instance = new SmartMovingComm();

    @Override
    public boolean processStatePacket(FMLProxyPacket packet, IEntityPlayerMP player, int entityId, long state) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId);
        if (entity == null) {
            return true;
        }
        SmartMovingOther moving = SmartMovingFactory.getOtherSmartMoving((EntityOtherPlayerMP)entity);
        if (moving != null) {
            moving.processStatePacket(state);
        }
        return true;
    }

    @Override
    public boolean processConfigInfoPacket(FMLProxyPacket packet, IEntityPlayerMP player, String info) {
        return false;
    }

    @Override
    public boolean processConfigContentPacket(FMLProxyPacket packet, IEntityPlayerMP player, String[] content, String username) {
        SmartMovingComm.processConfigPacket(content, username, false);
        return true;
    }

    @Override
    public boolean processConfigChangePacket(FMLProxyPacket packet, IEntityPlayerMP player) {
        SmartMovingOptions.writeNoRightsToChangeConfigMessageToChat(SmartMovingComm.isConnectedToRemoteServer());
        return true;
    }

    @Override
    public boolean processSpeedChangePacket(FMLProxyPacket packet, IEntityPlayerMP player, int difference, String username) {
        if (difference == 0) {
            SmartMovingOptions.writeNoRightsToChangeSpeedMessageToChat(SmartMovingComm.isConnectedToRemoteServer());
        } else {
            Config.changeSpeed(difference);
            Options.writeServerSpeedMessageToChat(username, (Boolean)SmartMovingComm.Config._globalConfig.value);
        }
        return true;
    }

    @Override
    public boolean processHungerChangePacket(FMLProxyPacket packet, IEntityPlayerMP player, float hunger) {
        return false;
    }

    @Override
    public boolean processSoundPacket(FMLProxyPacket packet, IEntityPlayerMP player, String soundId, float distance, float pitch) {
        return false;
    }

    private static boolean isConnectedToRemoteServer() {
        return MinecraftServer.func_71276_C() == null || Minecraft.func_71410_x().func_71401_C() == null || !Minecraft.func_71410_x().func_71401_C().func_71264_H();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void processConfigPacket(String[] content, String username, boolean blockCode) {
        boolean first;
        boolean isGloballyConfigured = false;
        if (content != null && content.length == 2 && SmartMovingComm.Options._globalConfig.getCurrentKey().equals(content[0])) {
            isGloballyConfigured = "true".equals(content[1]);
            content = null;
        }
        boolean wasEnabled = SmartMovingComm.Config.enabled;
        boolean bl = first = Config != ServerConfig;
        if (first) {
            ServerConfig.reset();
        }
        if (content != null) {
            if (content.length == 0) {
                Config = Options;
                Options.writeServerDeconfigMessageToChat();
                return;
            }
            ServerConfig.loadFromProperties(content, blockCode);
            isGloballyConfigured = (Boolean)SmartMovingComm.ServerConfig._globalConfig.value;
        } else {
            ServerConfig.load(false);
            ServerConfig.setCurrentKey(null);
        }
        SmartMovingComm.ServerConfig._globalConfig.value = isGloballyConfigured;
        if (!first) {
            Options.writeServerReconfigMessageToChat(wasEnabled, username, isGloballyConfigured);
            return;
        }
        Config = ServerConfig;
        Options.writeServerConfigMessageToChat();
        if (!blockCode) {
            SmartMovingPacketStream.sendConfigInfo(instance, "3.2");
        }
    }

    @Override
    public void sendPacket(byte[] data) {
        Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C17PacketCustomPayload(SmartMovingPacketStream.Id, data));
    }

    public static boolean processBlockCode(String text) {
        if (!text.startsWith("\u00ef\u00bf\u00bd0\u00ef\u00bf\u00bd1") || !text.endsWith("\u00ef\u00bf\u00bdf\u00ef\u00bf\u00bdf")) {
            return false;
        }
        String codes = text.substring(4, text.length() - 4);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd0", SmartMovingComm.Options._baseClimb, "standard");
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd1", SmartMovingComm.Options._freeClimb, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd2", SmartMovingComm.Options._ceilingClimbing, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd3", SmartMovingComm.Options._swim, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd4", SmartMovingComm.Options._dive, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd5", SmartMovingComm.Options._crawl, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd6", SmartMovingComm.Options._slide, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd7", SmartMovingComm.Options._fly, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd8", SmartMovingComm.Options._jumpCharge, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bd9", SmartMovingComm.Options._headJump, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bda", SmartMovingComm.Options._angleJumpSide, new String[0]);
        SmartMovingComm.processBlockCode(codes, "\u00ef\u00bf\u00bdb", SmartMovingComm.Options._angleJumpBack, new String[0]);
        return true;
    }

    private static void processBlockCode(String text, String blockCode, Property<?> property, String ... value) {
        if (text.contains(blockCode)) {
            SmartMovingComm.processConfigPacket(new String[]{property.getCurrentKey(), value.length > 0 ? value[0] : "false"}, null, true);
        }
    }
}

