/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.server.MinecraftServer;
import net.smart.moving.SmartMovingClient;
import net.smart.moving.SmartMovingFactory;
import net.smart.moving.SmartMovingInfo;
import net.smart.moving.SmartMovingServer;
import net.smart.moving.config.SmartMovingClientConfig;
import net.smart.moving.config.SmartMovingOptions;
import net.smart.moving.config.SmartMovingServerConfig;
import net.smart.moving.render.RenderPlayer;
import net.smart.render.SmartRenderContext;
import net.smart.render.statistics.SmartStatisticsContext;

public abstract class SmartMovingContext
extends SmartRenderContext {
    public static final float ClimbPullMotion = 0.3f;
    public static final double FastUpMotion = 0.2;
    public static final double MediumUpMotion = 0.14;
    public static final double SlowUpMotion = 0.1;
    public static final double HoldMotion = 0.08;
    public static final double SinkDownMotion = 0.05;
    public static final double ClimbDownMotion = 0.01;
    public static final double CatchCrawlGapMotion = 0.17;
    public static final float SwimCrawlWaterMaxBorder = 1.0f;
    public static final float SwimCrawlWaterTopBorder = 0.65f;
    public static final float SwimCrawlWaterMediumBorder = 0.6f;
    public static final float SwimCrawlWaterBottomBorder = 0.55f;
    public static final float HorizontalGroundDamping = 0.546f;
    public static final float HorizontalAirDamping = 0.91f;
    public static final float HorizontalAirodynamicDamping = 0.999f;
    public static final float SwimSoundDistance = 1.4285715f;
    public static final float SlideToHeadJumpingFallDistance = 0.05f;
    public static final SmartMovingClient Client = new SmartMovingClient();
    public static final SmartMovingOptions Options = new SmartMovingOptions();
    public static final SmartMovingServerConfig ServerConfig = new SmartMovingServerConfig();
    public static SmartMovingClientConfig Config = Options;
    private static boolean wasInitialized;
    private static MinecraftServer lastMinecraftServer;

    public static void onTickInGame() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71441_e != null && minecraft.field_71441_e.field_72995_K) {
            SmartMovingFactory.handleMultiPlayerTick(minecraft);
        }
        Options.initializeForGameIfNeccessary();
        SmartMovingContext.initializeServerIfNecessary();
    }

    public static void initialize() {
        if (!wasInitialized) {
            SmartStatisticsContext.setCalculateHorizontalStats((boolean)true);
        }
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindGrab);
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindConfigToggle);
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindSpeedIncrease);
        ClientRegistry.registerKeyBinding((KeyBinding)SmartMovingContext.Options.keyBindSpeedDecrease);
        if (wasInitialized) {
            return;
        }
        wasInitialized = true;
        System.out.println(SmartMovingInfo.ModComMessage);
        FMLLog.getLogger().info(SmartMovingInfo.ModComMessage);
    }

    public static void initializeServerIfNecessary() {
        MinecraftServer currentMinecraftServer = MinecraftServer.func_71276_C();
        if (currentMinecraftServer != null && currentMinecraftServer != lastMinecraftServer) {
            SmartMovingServer.initialize(SmartMovingOptions.optionsPath, currentMinecraftServer.func_71265_f().func_77148_a(), Options);
        }
        lastMinecraftServer = currentMinecraftServer;
    }

    public static void registerRenderers() {
        SmartMovingContext.registerRenderers(RenderPlayer.class);
    }

    static {
        lastMinecraftServer = null;
    }
}

