/*
 * Decompiled with CFR 0.152.
 */
package net.smart.moving.config;

import net.smart.moving.config.SmartMovingConfig;

public class SmartMovingClientConfig
extends SmartMovingConfig {
    public static final int Sprinting = 0;
    public static final int Running = 1;
    public static final int Walking = 2;
    public static final int Sneaking = 3;
    public static final int Standing = 4;
    public static final int Up = 0;
    public static final int ChargeUp = 1;
    public static final int Angle = 2;
    public static final int HeadUp = 3;
    public static final int SlideDown = 4;
    public static final int ClimbUp = 5;
    public static final int ClimbUpHandsOnly = 6;
    public static final int ClimbBackUp = 7;
    public static final int ClimbBackUpHandsOnly = 8;
    public static final int ClimbBackHead = 9;
    public static final int ClimbBackHeadHandsOnly = 10;
    public static final int WallUp = 11;
    public static final int WallHead = 12;
    public static final int WallUpSlide = 13;
    public static final int WallHeadSlide = 14;

    public boolean isSneakingEnabled() {
        return (Boolean)this._sneak.value != false || !this.enabled;
    }

    public boolean isStandardBaseClimb() {
        return (Boolean)this._isStandardBaseClimb.value != false || !this.enabled;
    }

    public boolean isSimpleBaseClimb() {
        return (Boolean)this._isSimpleBaseClimb.value != false && this.enabled;
    }

    public boolean isSmartBaseClimb() {
        return (Boolean)this._isSmartBaseClimb.value != false && this.enabled;
    }

    public boolean isFreeBaseClimb() {
        return (Boolean)this._isFreeBaseClimb.value != false && this.enabled;
    }

    public boolean isTotalFreeLadderClimb() {
        return this.isFreeBaseClimb() && (Boolean)this._freeBaseLadderClimb.value != false;
    }

    public boolean isTotalFreeVineClimb() {
        return this.isFreeBaseClimb() && (Boolean)this._freeBaseVineClimb.value != false;
    }

    public boolean isFreeClimbAutoLaddderEnabled() {
        return (Boolean)this._freeClimbingAutoLaddder.value != false && this.enabled;
    }

    public boolean isFreeClimbAutoVineEnabled() {
        return (Boolean)this._freeClimbingAutoVine.value != false && this.enabled;
    }

    public boolean isFreeClimbingEnabled() {
        return (Boolean)this._freeClimb.value != false && this.enabled;
    }

    public boolean isCeilingClimbingEnabled() {
        return (Boolean)this._ceilingClimbing.value != false && this.enabled;
    }

    public boolean isSwimmingEnabled() {
        return (Boolean)this._swim.value != false && this.enabled;
    }

    public boolean isDivingEnabled() {
        return (Boolean)this._dive.value != false && this.enabled;
    }

    public boolean isLavaLikeWaterEnabled() {
        return (Boolean)this._lavaLikeWater.value != false && this.enabled;
    }

    public boolean isFlyingEnabled() {
        return (Boolean)this._fly.value != false && this.enabled;
    }

    public boolean isLevitateSmallEnabled() {
        return (Boolean)this._levitateSmall.value != false && this.enabled;
    }

    public boolean isRunningEnabled() {
        return (Boolean)this._run.value != false || !this.enabled;
    }

    public boolean isRunExhaustionEnabled() {
        return (Boolean)this._runExhaustion.value != false && this.enabled;
    }

    public boolean isClimbExhaustionEnabled() {
        return (Boolean)this._climbExhaustion.value != false && this.enabled;
    }

    public boolean isCeilingClimbExhaustionEnabled() {
        return (Boolean)this._ceilingClimbExhaustion.value != false && this.enabled;
    }

    public boolean isSprintingEnabled() {
        return (Boolean)this._sprint.value != false && this.enabled;
    }

    public boolean isSprintExhaustionEnabled() {
        return (Boolean)this._sprintExhaustion.value != false && this.enabled;
    }

    public boolean isJumpChargingEnabled() {
        return (Boolean)this._jumpCharge.value != false && this.enabled;
    }

    public boolean isHeadJumpingEnabled() {
        return (Boolean)this._headJump.value != false && this.enabled;
    }

    public boolean isSlidingEnabled() {
        return (Boolean)this._slide.value != false && this.enabled;
    }

    public boolean isCrawlingEnabled() {
        return (Boolean)this._crawl.value != false && this.enabled;
    }

    public boolean isExhaustionLossHungerEnabled() {
        return (Boolean)this._exhaustionLossHunger.value != false && (Boolean)this._hungerGain.value != false && this.enabled;
    }

    public boolean isHungerGainEnabled() {
        return (Boolean)this._hungerGain.value != false || !this.enabled;
    }

    public boolean isLevitationAnimationEnabled() {
        return (Boolean)this._levitateAnimation.value != false && this.enabled;
    }

    public boolean isFallAnimationEnabled() {
        return (Boolean)this._fallAnimation.value != false && this.enabled;
    }

    public boolean isJumpingEnabled(int speed, int type) {
        if (!this.enabled) {
            return true;
        }
        if (type == 1) {
            return (Boolean)this._jumpCharge.value;
        }
        if (type == 4) {
            return (Boolean)this._slide.value;
        }
        if (type == 5 || type == 6) {
            return (Boolean)this._climbUpJump.value;
        }
        if (type == 7 || type == 8) {
            return (Boolean)this._climbBackUpJump.value;
        }
        if (type == 9 || type == 10) {
            return (Boolean)this._climbBackHeadJump.value;
        }
        if (type == 11) {
            return (Boolean)this._wallUpJump.value;
        }
        if (type == 12) {
            return (Boolean)this._wallHeadJump.value;
        }
        if (speed == 0) {
            return (Boolean)this._sprintJump.value;
        }
        if (speed == 1) {
            return (Boolean)this._runJump.value;
        }
        if (speed == 2) {
            return (Boolean)this._walkJump.value;
        }
        if (speed == 3) {
            return (Boolean)this._sneakJump.value;
        }
        if (speed == 4) {
            return (Boolean)this._standJump.value;
        }
        return true;
    }

    public boolean isSideJumpEnabled() {
        return this.enabled && (Boolean)this._angleJumpSide.value != false;
    }

    public boolean isBackJumpEnabled() {
        return this.enabled && (Boolean)this._angleJumpBack.value != false;
    }

    public boolean isWallJumpEnabled() {
        return this.enabled && (Boolean)this._wallUpJump.value != false;
    }

    public boolean isJumpExhaustionEnabled(int speed, int type) {
        if (!this.enabled) {
            return false;
        }
        boolean result = (Boolean)this._jumpExhaustion.value;
        if (type == 4) {
            return result && (Boolean)this._jumpSlideExhaustion.value != false;
        }
        result = type == 2 ? (result &= ((Boolean)this._angleJumpExhaustion.value).booleanValue()) : (type == 5 || type == 6 ? (result &= ((Boolean)this._climbJumpUpExhaustion.value).booleanValue()) : (type == 7 || type == 8 ? (result &= ((Boolean)this._climbJumpBackUpExhaustion.value).booleanValue()) : (type == 9 || type == 10 ? (result &= ((Boolean)this._climbJumpBackHeadExhaustion.value).booleanValue()) : (type == 11 ? (result &= ((Boolean)this._wallUpJumpExhaustion.value).booleanValue()) : (type == 12 ? (result &= ((Boolean)this._wallHeadJumpExhaustion.value).booleanValue()) : (result &= ((Boolean)this._upJumpExhaustion.value).booleanValue()))))));
        if (type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 10) {
            return result && (Boolean)this._climbJumpExhaustion.value != false;
        }
        if (type == 11 || type == 12) {
            return result && (Boolean)this._wallJumpExhaustion.value != false;
        }
        if (speed == 0) {
            result &= ((Boolean)this._sprintJumpExhaustion.value).booleanValue();
        } else if (speed == 1) {
            result &= ((Boolean)this._runJumpExhaustion.value).booleanValue();
        } else if (speed == 2) {
            result &= ((Boolean)this._walkJumpExhaustion.value).booleanValue();
        } else if (speed == 3) {
            result &= ((Boolean)this._sneakJumpExhaustion.value).booleanValue();
        } else if (speed == 4) {
            result &= ((Boolean)this._standJumpExhaustion.value).booleanValue();
        }
        if (type == 1) {
            result |= ((Boolean)this._jumpChargeExhaustion.value).booleanValue();
        }
        return result;
    }

    public float getJumpExhaustionGain(int speed, int type, float jumpCharge) {
        if (!this.enabled) {
            return 0.0f;
        }
        float result = ((Float)this._baseExhautionGainFactor.value).floatValue() * ((Float)this._jumpExhaustionGainFactor.value).floatValue();
        if (type == 4) {
            return result * ((Float)this._jumpSlideExhaustionGainFactor.value).floatValue();
        }
        result = type == 2 ? (result *= ((Float)this._angleJumpExhaustionGainFactor.value).floatValue()) : (type == 5 || type == 6 ? (result *= ((Float)this._climbJumpUpExhaustionGainFactor.value).floatValue()) : (type == 7 || type == 8 ? (result *= ((Float)this._climbJumpBackUpExhaustionGainFactor.value).floatValue()) : (type == 9 || type == 10 ? (result *= ((Float)this._climbJumpBackHeadExhaustionGainFactor.value).floatValue()) : (type == 11 ? (result *= ((Float)this._wallUpJumpExhaustionGainFactor.value).floatValue()) : (type == 12 ? (result *= ((Float)this._wallHeadJumpExhaustionGainFactor.value).floatValue()) : (result *= ((Float)this._upJumpExhaustionGainFactor.value).floatValue()))))));
        if (type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 10) {
            return result * ((Float)this._climbJumpExhaustionGainFactor.value).floatValue();
        }
        if (type == 11 || type == 12) {
            return result * ((Float)this._wallJumpExhaustionGainFactor.value).floatValue();
        }
        if (speed == 0) {
            result *= ((Float)this._sprintJumpExhaustionGainFactor.value).floatValue();
        } else if (speed == 1) {
            result *= ((Float)this._runJumpExhaustionGainFactor.value).floatValue();
        } else if (speed == 2) {
            result *= ((Float)this._walkJumpExhaustionGainFactor.value).floatValue();
        } else if (speed == 3) {
            result *= ((Float)this._sneakJumpExhaustionGainFactor.value).floatValue();
        } else if (speed == 4) {
            result *= ((Float)this._standJumpExhaustionGainFactor.value).floatValue();
        }
        if (type == 1) {
            if (!this.isJumpExhaustionEnabled(speed, 0)) {
                result = 0.0f;
            }
            result += ((Float)this._baseExhautionGainFactor.value).floatValue() * ((Float)this._jumpExhaustionGainFactor.value).floatValue() * ((Float)this._upJumpExhaustionGainFactor.value).floatValue() * ((Float)this._jumpChargeExhaustionGainFactor.value).floatValue() * Math.min(jumpCharge, ((Float)this._jumpChargeMaximum.value).floatValue()) / ((Float)this._jumpChargeMaximum.value).floatValue();
        }
        return result;
    }

    public float getJumpExhaustionStop(int speed, int type, float jumpCharge) {
        float result = ((Float)this._jumpExhaustionStopFactor.value).floatValue();
        if (type == 4) {
            return result * ((Float)this._jumpSlideExhaustionStopFactor.value).floatValue();
        }
        result = type == 2 ? (result *= ((Float)this._angleJumpExhaustionStopFactor.value).floatValue()) : (type == 5 || type == 6 ? (result *= ((Float)this._climbJumpUpExhaustionStopFactor.value).floatValue()) : (type == 7 || type == 8 ? (result *= ((Float)this._climbJumpBackUpExhaustionStopFactor.value).floatValue()) : (type == 9 || type == 10 ? (result *= ((Float)this._climbJumpBackHeadExhaustionStopFactor.value).floatValue()) : (type == 11 ? (result *= ((Float)this._wallUpJumpExhaustionStopFactor.value).floatValue()) : (type == 12 ? (result *= ((Float)this._wallHeadJumpExhaustionStopFactor.value).floatValue()) : (result *= ((Float)this._upJumpExhaustionStopFactor.value).floatValue()))))));
        if (type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 10) {
            return result * ((Float)this._climbJumpExhaustionStopFactor.value).floatValue();
        }
        if (type == 11 || type == 12) {
            return result * ((Float)this._wallJumpExhaustionStopFactor.value).floatValue();
        }
        if (speed == 0) {
            result *= ((Float)this._sprintJumpExhaustionStopFactor.value).floatValue();
        } else if (speed == 1) {
            result *= ((Float)this._runJumpExhaustionStopFactor.value).floatValue();
        } else if (speed == 2) {
            result *= ((Float)this._walkJumpExhaustionStopFactor.value).floatValue();
        } else if (speed == 3) {
            result *= ((Float)this._sneakJumpExhaustionStopFactor.value).floatValue();
        } else if (speed == 4) {
            result *= ((Float)this._standJumpExhaustionStopFactor.value).floatValue();
        }
        if (type == 1) {
            if (!this.isJumpExhaustionEnabled(speed, 0)) {
                result += this.getJumpExhaustionGain(speed, 0, 0.0f);
            }
            result -= ((Float)this._jumpExhaustionStopFactor.value).floatValue() * ((Float)this._upJumpExhaustionStopFactor.value).floatValue() * ((Float)this._jumpChargeExhaustionStopFactor.value).floatValue() * Math.min(jumpCharge, ((Float)this._jumpChargeMaximum.value).floatValue()) / ((Float)this._jumpChargeMaximum.value).floatValue();
        }
        return result;
    }

    public float getJumpChargeFactor(float jumpCharge) {
        if (!this.enabled || !((Boolean)this._jumpCharge.value).booleanValue()) {
            return 1.0f;
        }
        jumpCharge = Math.min(jumpCharge, ((Float)this._jumpChargeMaximum.value).floatValue());
        return 1.0f + jumpCharge / ((Float)this._jumpChargeMaximum.value).floatValue() * (((Float)this._jumpChargeFactor.value).floatValue() - 1.0f);
    }

    public float getHeadJumpFactor(float headJumpCharge) {
        if (!this.enabled || !((Boolean)this._headJump.value).booleanValue()) {
            return 1.0f;
        }
        headJumpCharge = Math.min(headJumpCharge, ((Float)this._headJumpChargeMaximum.value).floatValue());
        return (headJumpCharge - 1.0f) / (((Float)this._headJumpChargeMaximum.value).floatValue() - 1.0f);
    }

    public float getJumpVerticalFactor(int speed, int type) {
        if (!this.enabled) {
            return 1.0f;
        }
        float result = ((Float)this._jumpVerticalFactor.value).floatValue();
        if (type == 2) {
            return result * ((Float)this._angleJumpVerticalFactor.value).floatValue();
        }
        if (type == 5 || type == 6) {
            result *= ((Float)this._climbUpJumpVerticalFactor.value).floatValue();
        }
        if (type == 6) {
            result *= ((Float)this._climbUpJumpHandsOnlyVerticalFactor.value).floatValue();
        }
        if (type == 7 || type == 8) {
            result *= ((Float)this._climbBackUpJumpVerticalFactor.value).floatValue();
        }
        if (type == 8) {
            result *= ((Float)this._climbBackUpJumpHandsOnlyVerticalFactor.value).floatValue();
        }
        if (type == 9 || type == 10) {
            result *= ((Float)this._climbBackHeadJumpVerticalFactor.value).floatValue();
        }
        if (type == 10) {
            result *= ((Float)this._climbBackHeadJumpHandsOnlyVerticalFactor.value).floatValue();
        }
        if (type == 11 || type == 12) {
            result *= ((Float)this._wallUpJumpVerticalFactor.value).floatValue();
        }
        if (type == 12) {
            result *= ((Float)this._wallHeadJumpVerticalFactor.value).floatValue();
        }
        if (type == 2 || type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 10 || type == 11 || type == 12) {
            return result;
        }
        if (speed == 0) {
            result *= ((Float)this._sprintJumpVerticalFactor.value).floatValue();
        } else if (speed == 1) {
            result *= ((Float)this._runJumpVerticalFactor.value).floatValue();
        } else if (speed == 2) {
            result *= ((Float)this._walkJumpVerticalFactor.value).floatValue();
        } else if (speed == 3) {
            result *= ((Float)this._sneakJumpVerticalFactor.value).floatValue();
        } else if (speed == 4) {
            result *= ((Float)this._standJumpVerticalFactor.value).floatValue();
        }
        return result;
    }

    public float getJumpHorizontalFactor(int speed, int type) {
        if (!this.enabled) {
            return speed == 1 ? 2.0f : 1.0f;
        }
        float result = ((Float)this._jumpHorizontalFactor.value).floatValue();
        if (type == 2) {
            result *= ((Float)this._angleJumpHorizontalFactor.value).floatValue();
        }
        if (type == 7 || type == 8) {
            result *= ((Float)this._climbBackUpJumpHorizontalFactor.value).floatValue();
        }
        if (type == 8) {
            result *= ((Float)this._climbBackUpJumpHandsOnlyHorizontalFactor.value).floatValue();
        }
        if (type == 9 || type == 10) {
            result *= ((Float)this._climbBackHeadJumpHorizontalFactor.value).floatValue();
        }
        if (type == 10) {
            result *= ((Float)this._climbBackHeadJumpHandsOnlyHorizontalFactor.value).floatValue();
        }
        if (type == 11) {
            result *= ((Float)this._wallUpJumpHorizontalFactor.value).floatValue();
        }
        if (type == 12) {
            result *= ((Float)this._wallHeadJumpHorizontalFactor.value).floatValue();
        }
        if (type == 2 || type == 5 || type == 6 || type == 7 || type == 8 || type == 9 || type == 10 || type == 11 || type == 12) {
            return result;
        }
        if (speed == 0) {
            result *= ((Float)this._sprintJumpHorizontalFactor.value).floatValue();
        } else if (speed == 1) {
            result *= ((Float)this._runJumpHorizontalFactor.value).floatValue();
        } else if (speed == 2) {
            result *= ((Float)this._walkJumpHorizontalFactor.value).floatValue();
        } else if (speed == 3) {
            result *= ((Float)this._sneakJumpHorizontalFactor.value).floatValue();
        } else if (speed == 4 && type != 7 && type != 8 && type != 9 && type != 10) {
            result *= 0.0f;
        }
        return result;
    }

    public float getMaxHorizontalMotion(int speed, int type, boolean inWater) {
        float maxMotion = 0.11785204f;
        if (!this.enabled) {
            return speed == 1 ? maxMotion * 1.3f : maxMotion;
        }
        if (inWater) {
            maxMotion = 0.07839603f;
        }
        if (speed == 0) {
            maxMotion *= ((Float)this._sprintFactor.value).floatValue();
        } else if (speed == 1) {
            maxMotion *= ((Float)this._runFactor.value).floatValue();
        } else if (speed == 3) {
            maxMotion *= ((Float)this._sneakFactor.value).floatValue();
        }
        return maxMotion;
    }

    public float getMaxExhaustion() {
        float result = 0.0f;
        if (((Boolean)this._run.value).booleanValue() && ((Boolean)this._runExhaustion.value).booleanValue()) {
            result = SmartMovingClientConfig.max(result, ((Float)this._runExhaustionStop.value).floatValue());
        }
        if (((Boolean)this._sprint.value).booleanValue() && ((Boolean)this._sprintExhaustion.value).booleanValue()) {
            result = SmartMovingClientConfig.max(result, ((Float)this._sprintExhaustionStop.value).floatValue());
        }
        if (((Boolean)this._jump.value).booleanValue()) {
            for (int i = 0; i <= 4; ++i) {
                for (int n = 0; n <= 14; ++n) {
                    if (!this.isJumpExhaustionEnabled(i, n)) continue;
                    for (int t = 0; t <= 1; ++t) {
                        result = SmartMovingClientConfig.max(result, this.getJumpExhaustionStop(i, n, t) + this.getJumpExhaustionGain(i, n, t));
                    }
                }
            }
        }
        if (((Boolean)this._freeClimb.value).booleanValue() && ((Boolean)this._climbExhaustion.value).booleanValue()) {
            result = SmartMovingClientConfig.max(result, ((Float)this._climbExhaustionStop.value).floatValue());
        }
        if (((Boolean)this._ceilingClimbing.value).booleanValue() && ((Boolean)this._ceilingClimbExhaustion.value).booleanValue()) {
            result = SmartMovingClientConfig.max(result, ((Float)this._ceilingClimbExhaustionStop.value).floatValue());
        }
        return result;
    }

    private static float max(float value, float valueOrInfinite) {
        return valueOrInfinite == java.lang.Float.POSITIVE_INFINITY ? value : Math.max(value, valueOrInfinite);
    }

    public float getFactor(boolean hunger, boolean onGround, boolean isStanding, boolean isStill, boolean isSneaking, boolean isRunning, boolean isSprinting, boolean isClimbing, boolean isClimbCrawling, boolean isCeilingClimbing, boolean isDipping, boolean isSwimming, boolean isDiving, boolean isCrawling, boolean isCrawlClimbing) {
        isCrawling |= isCrawlClimbing;
        boolean actionOverGound = (isClimbing |= isClimbCrawling) || isCeilingClimbing || isDiving || isSwimming;
        boolean airBorne = !onGround && !actionOverGound;
        isStanding = actionOverGound ? isStill : isStanding;
        float factor = (hunger ? (Float)this._baseHungerGainFactor.value : (Float)this._baseExhautionLossFactor.value).floatValue();
        factor = airBorne ? (factor *= hunger ? 0.0f : ((Float)this._fallExhautionLossFactor.value).floatValue()) : (isSprinting ? (factor *= (hunger ? (Float)this._sprintingHungerGainFactor.value : (Float)this._sprintingExhautionLossFactor.value).floatValue()) : (isRunning ? (factor *= (hunger ? (Float)this._runningHungerGainFactor.value : (Float)this._runningExhautionLossFactor.value).floatValue()) : ((isSneaking &= !isStanding) ? (factor *= (hunger ? (Float)this._sneakingHungerGainFactor.value : (Float)this._sneakingExhautionLossFactor.value).floatValue()) : (isStanding ? (factor *= (hunger ? (Float)this._standingHungerGainFactor.value : (Float)this._standingExhautionLossFactor.value).floatValue()) : (factor *= (hunger ? (Float)this._walkingHungerGainFactor.value : (Float)this._walkingExhautionLossFactor.value).floatValue())))));
        factor = isClimbing ? (factor *= (hunger ? (Float)this._climbingHungerGainFactor.value : (Float)this._climbingExhaustionLossFactor.value).floatValue()) : (isCrawling ? (factor *= (hunger ? (Float)this._crawlingHungerGainFactor.value : (Float)this._crawlingExhaustionLossFactor.value).floatValue()) : (isCeilingClimbing ? (factor *= (hunger ? (Float)this._ceilClimbingHungerGainFactor.value : (Float)this._ceilClimbingExhaustionLossFactor.value).floatValue()) : (isSwimming ? (factor *= (hunger ? (Float)this._swimmingHungerGainFactor.value : (Float)this._swimmingExhaustionLossFactor.value).floatValue()) : (isDiving ? (factor *= (hunger ? (Float)this._divingHungerGainFactor.value : (Float)this._divingExhaustionLossFactor.value).floatValue()) : (isDipping ? (factor *= (hunger ? (Float)this._dippingHungerGainFactor.value : (Float)this._dippingExhaustionLossFactor.value).floatValue()) : (onGround ? (factor *= (hunger ? (Float)this._normalHungerGainFactor.value : (Float)this._normalExhaustionLossFactor.value).floatValue()) : (factor *= (hunger ? (Float)this._normalHungerGainFactor.value : (Float)this._normalExhaustionLossFactor.value).floatValue())))))));
        return factor;
    }
}

