/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render;

public abstract class SmartRenderUtilities {
    public static final float Whole = (float)Math.PI * 2;
    public static final float Half = (float)Math.PI;
    public static final float Quarter = 1.5707964f;
    public static final float Eighth = 0.7853982f;
    public static final float Sixteenth = 0.3926991f;
    public static final float Thirtytwoth = 0.19634955f;
    public static final float Sixtyfourth = 0.09817477f;
    public static final float RadiantToAngle = 57.295776f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float getHorizontalCollisionangle(boolean isCollidedPositiveX, boolean isCollidedNegativeX, boolean isCollidedPositiveZ, boolean isCollidedNegativeZ) {
        if (isCollidedPositiveX) {
            if (isCollidedNegativeX) {
                if (isCollidedPositiveZ) {
                    if (isCollidedNegativeZ) return Float.NaN;
                    return 90.0f;
                }
                if (!isCollidedNegativeZ) return Float.NaN;
                return 270.0f;
            }
            if (isCollidedPositiveZ) {
                if (!isCollidedNegativeZ) return 45.0f;
                return 0.0f;
            }
            if (!isCollidedNegativeZ) return 0.0f;
            return 315.0f;
        }
        if (isCollidedNegativeX) {
            if (isCollidedPositiveZ) {
                if (!isCollidedNegativeZ) return 135.0f;
                return 180.0f;
            }
            if (!isCollidedNegativeZ) return 180.0f;
            return 225.0f;
        }
        if (isCollidedPositiveZ) {
            if (isCollidedNegativeZ) return Float.NaN;
            return 90.0f;
        }
        if (!isCollidedNegativeZ) return Float.NaN;
        return 270.0f;
    }

    public static float getAngle(double x, double y) {
        if (x == 0.0) {
            if (y == 0.0) {
                return Float.NaN;
            }
            if (y < 0.0) {
                return 270.0f;
            }
            return 90.0f;
        }
        if (y == 0.0) {
            if (x < 0.0) {
                return 180.0f;
            }
            return 0.0f;
        }
        float angle = (float)Math.atan(y / x) * 57.295776f;
        if (x < 0.0) {
            return 180.0f + angle;
        }
        if (y < 0.0 && x > 0.0) {
            return 360.0f + angle;
        }
        return angle;
    }
}

