/*
 * Decompiled with CFR 0.152.
 */
package net.smart.render.playerapi;

import api.player.model.ModelPlayer;
import api.player.model.ModelPlayerAPI;
import api.player.render.RenderPlayerAPI;
import api.player.render.RenderPlayerBase;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.smart.render.IModelPlayer;
import net.smart.render.IRenderPlayer;
import net.smart.render.SmartRenderRender;
import net.smart.render.playerapi.SmartRender;

public class SmartRenderRenderPlayerBase
extends RenderPlayerBase
implements IRenderPlayer {
    private ModelPlayer[] allModelPlayers;
    private IModelPlayer[] allIModelPlayers;
    private SmartRenderRender render;

    public SmartRenderRenderPlayerBase(RenderPlayerAPI renderPlayerAPI) {
        super(renderPlayerAPI);
    }

    public SmartRenderRender getRenderRender() {
        if (this.render == null) {
            this.render = new SmartRenderRender(this);
        }
        return this.render;
    }

    @Override
    public IModelPlayer createModel(ModelBiped existing, float f) {
        return SmartRender.getPlayerBase((ModelPlayer)existing);
    }

    @Override
    public void initialize(ModelBiped modelBipedMain, ModelBiped modelArmorChestplate, ModelBiped modelArmor, float shadowSize) {
        this.renderPlayerAPI.setMainModelField((ModelBase)modelBipedMain);
        this.renderPlayerAPI.setShadowSizeField(0.5f);
        this.renderPlayerAPI.setModelBipedMainField(modelBipedMain);
        this.renderPlayerAPI.setModelArmorChestplateField(modelArmorChestplate);
        this.renderPlayerAPI.setModelArmorField(modelArmor);
    }

    public void renderPlayer(AbstractClientPlayer entityplayer, double d, double d1, double d2, float f, float renderPartialTicks) {
        this.getRenderRender().renderPlayer(entityplayer, d, d1, d2, f, renderPartialTicks);
    }

    @Override
    public void superRenderPlayer(AbstractClientPlayer entityplayer, double d, double d1, double d2, float f, float renderPartialTicks) {
        super.renderPlayer(entityplayer, d, d1, d2, f, renderPartialTicks);
    }

    public void renderFirstPersonArm(EntityPlayer entityPlayer) {
        this.getRenderRender().drawFirstPersonHand(entityPlayer);
    }

    @Override
    public void superDrawFirstPersonHand(EntityPlayer entityPlayer) {
        super.renderFirstPersonArm(entityPlayer);
    }

    public void rotatePlayer(AbstractClientPlayer entityplayer, float totalTime, float actualRotation, float f2) {
        this.getRenderRender().rotatePlayer(entityplayer, totalTime, actualRotation, f2);
    }

    @Override
    public void superRotatePlayer(AbstractClientPlayer entityplayer, float totalTime, float actualRotation, float f2) {
        super.rotatePlayer(entityplayer, totalTime, actualRotation, f2);
    }

    public void renderSpecials(AbstractClientPlayer entityplayer, float f) {
        this.getRenderRender().renderSpecials(entityplayer, f);
    }

    @Override
    public void superRenderSpecials(AbstractClientPlayer entityplayer, float f) {
        super.renderSpecials(entityplayer, f);
    }

    public void beforeHandleRotationFloat(EntityLivingBase entityliving, float f) {
        this.getRenderRender().beforeHandleRotationFloat(entityliving, f);
    }

    public void afterHandleRotationFloat(EntityLivingBase entityliving, float f) {
        this.getRenderRender().afterHandleRotationFloat(entityliving, f);
    }

    @Override
    public RenderManager getRenderManager() {
        return this.renderPlayerAPI.getRenderManagerField();
    }

    @Override
    public ModelBiped getModelBipedMain() {
        return this.renderPlayerAPI.getModelBipedMainField();
    }

    @Override
    public ModelBiped getModelArmorChestplate() {
        return this.renderPlayerAPI.getModelArmorChestplateField();
    }

    @Override
    public ModelBiped getModelArmor() {
        return this.renderPlayerAPI.getModelArmorField();
    }

    @Override
    public IModelPlayer[] getRenderModels() {
        ModelPlayer[] modelPlayers = ModelPlayerAPI.getAllInstances();
        if (this.allModelPlayers != null && (this.allModelPlayers == modelPlayers || modelPlayers.length == 0 && this.allModelPlayers.length == 0)) {
            return this.allIModelPlayers;
        }
        this.allModelPlayers = modelPlayers;
        this.allIModelPlayers = new IModelPlayer[modelPlayers.length];
        for (int i = 0; i < this.allIModelPlayers.length; ++i) {
            this.allIModelPlayers[i] = SmartRender.getPlayerBase(this.allModelPlayers[i]);
        }
        return this.allIModelPlayers;
    }
}

