/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatisticsFile;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import twilightforest.TFAchievementPage;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.entity.EntityTFAdherent;
import twilightforest.entity.EntityTFArmoredGiant;
import twilightforest.entity.EntityTFBlockGoblin;
import twilightforest.entity.EntityTFDeathTome;
import twilightforest.entity.EntityTFFireBeetle;
import twilightforest.entity.EntityTFGiantMiner;
import twilightforest.entity.EntityTFGoblinKnightLower;
import twilightforest.entity.EntityTFHarbingerCube;
import twilightforest.entity.EntityTFHelmetCrab;
import twilightforest.entity.EntityTFIceExploder;
import twilightforest.entity.EntityTFIceShooter;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMazeSlime;
import twilightforest.entity.EntityTFMiniGhast;
import twilightforest.entity.EntityTFMinotaur;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFRedcapSapper;
import twilightforest.entity.EntityTFSlimeBeetle;
import twilightforest.entity.EntityTFSnowGuardian;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFTowerBroodling;
import twilightforest.entity.EntityTFTowerGhast;
import twilightforest.entity.EntityTFTowerGolem;
import twilightforest.entity.EntityTFTroll;
import twilightforest.entity.EntityTFWraith;
import twilightforest.entity.EntityTFYeti;
import twilightforest.world.TFWorld;
import twilightforest.world.TFWorldChunkManager;

public class TFFeature {
    public static final TFFeature[] featureList = new TFFeature[256];
    public static final TFFeature nothing = new TFFeature(0, 0, "No Feature").enableDecorations().disableStructure();
    public static final TFFeature hill1 = new TFFeature(1, 1, "Small Hollow Hill").enableDecorations().enableTerrainAlterations();
    public static final TFFeature hill2 = new TFFeature(2, 2, "Medium Hollow Hill").enableDecorations().enableTerrainAlterations();
    public static final TFFeature hill3 = new TFFeature(3, 3, "Large Hollow Hill").enableDecorations().enableTerrainAlterations();
    public static final TFFeature hedgeMaze = new TFFeature(4, 2, "Hedge Maze").enableTerrainAlterations();
    public static final TFFeature nagaCourtyard = new TFFeature(5, 3, "Naga Courtyard").enableTerrainAlterations();
    public static final TFFeature lichTower = new TFFeature(6, 1, "Lich Tower").setRequiredAchievement(TFAchievementPage.twilightKillNaga);
    public static final TFFeature iceTower = new TFFeature(7, 2, "Ice Tower").setRequiredAchievement(TFAchievementPage.twilightProgressYeti);
    public static final TFFeature questIsland = new TFFeature(8, 1, "Quest Island").disableStructure();
    public static final TFFeature questGrove = new TFFeature(9, 1, "Quest Grove").enableTerrainAlterations();
    public static final TFFeature druidGrove = new TFFeature(10, 1, "Druid Grove").disableStructure();
    public static final TFFeature floatRuins = new TFFeature(11, 3, "Floating Ruins").disableStructure();
    public static final TFFeature hydraLair = new TFFeature(12, 2, "Hydra Lair").setRequiredAchievement(TFAchievementPage.twilightProgressLabyrinth).enableTerrainAlterations();
    public static final TFFeature labyrinth = new TFFeature(13, 3, "Labyrinth").enableDecorations().setRequiredAchievement(TFAchievementPage.twilightKillLich);
    public static final TFFeature darkTower = new TFFeature(14, 1, "Dark Tower").setRequiredAchievement(TFAchievementPage.twilightProgressKnights);
    public static final TFFeature tfStronghold = new TFFeature(15, 3, "Knight Stronghold").enableDecorations().setRequiredAchievement(TFAchievementPage.twilightProgressTrophyPedestal).disableProtectionAura();
    public static final TFFeature worldTree = new TFFeature(16, 3, "World Tree").disableStructure();
    public static final TFFeature yetiCave = new TFFeature(17, 2, "Yeti Lairs").enableDecorations().enableTerrainAlterations().setRequiredAchievement(TFAchievementPage.twilightProgressUrghast);
    public static final TFFeature trollCave = new TFFeature(18, 3, "Troll Lairs").enableDecorations().enableTerrainAlterations().setRequiredAchievement(TFAchievementPage.twilightProgressGlacier).disableProtectionAura();
    public static final TFFeature finalCastle = new TFFeature(19, 3, "Final Castle");
    public static final TFFeature mushroomTower = new TFFeature(20, 2, "Mushroom Tower");
    ArrayList<BiomeGenBase.SpawnListEntry> emptyList = new ArrayList();
    public int featureID;
    public int size;
    public String name;
    public boolean areChunkDecorationsEnabled;
    public boolean isStructureEnabled;
    public boolean isTerrainAltered;
    protected List<List<BiomeGenBase.SpawnListEntry>> spawnableMonsterLists;
    protected List<BiomeGenBase.SpawnListEntry> ambientCreatureList;
    protected List<BiomeGenBase.SpawnListEntry> waterCreatureList;
    protected Achievement requiredAchievement = null;
    public boolean hasProtectionAura;
    private long lastSpawnedHintMonsterTime;

    public TFFeature(int parID, int parSize, String parName) {
        this.featureID = parID;
        TFFeature.featureList[parID] = this;
        this.size = parSize;
        this.name = parName;
        this.areChunkDecorationsEnabled = false;
        this.isStructureEnabled = true;
        this.isTerrainAltered = false;
        this.spawnableMonsterLists = new ArrayList<List<BiomeGenBase.SpawnListEntry>>();
        this.ambientCreatureList = new ArrayList<BiomeGenBase.SpawnListEntry>();
        this.waterCreatureList = new ArrayList<BiomeGenBase.SpawnListEntry>();
        this.hasProtectionAura = true;
        this.ambientCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityBat.class, 10, 8, 8));
    }

    public TFFeature enableDecorations() {
        this.areChunkDecorationsEnabled = true;
        return this;
    }

    public TFFeature disableStructure() {
        this.isStructureEnabled = false;
        return this;
    }

    public TFFeature enableTerrainAlterations() {
        this.isTerrainAltered = true;
        return this;
    }

    public TFFeature disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFFeature addMonster(Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFFeature addMonster(int listIndex, Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new BiomeGenBase.SpawnListEntry(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFFeature addWaterCreature(Class<? extends EntityLiving> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new BiomeGenBase.SpawnListEntry(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static TFFeature getFeatureDirectlyAt(int chunkX, int chunkZ, World world) {
        WorldChunkManager worldChunkManager;
        if (world != null && (worldChunkManager = world.func_72959_q()) instanceof TFWorldChunkManager) {
            TFWorldChunkManager tfManager = (TFWorldChunkManager)worldChunkManager;
            if (tfManager.isInFeatureChunk(world, chunkX << 4, chunkZ << 4)) {
                return tfManager.getFeatureAt(chunkX << 4, chunkZ << 4, world);
            }
            return nothing;
        }
        return nothing;
    }

    public static TFFeature generateFeatureForOldMapGen(int chunkX, int chunkZ, World world) {
        TFFeature tFFeature;
        BiomeGenBase biomeAt = world.func_72807_a((chunkX << 4) + 8, (chunkZ << 4) + 8);
        Random hillRNG = new Random(world.func_72905_C() + (long)chunkX * 25117L + (long)chunkZ * 151121L);
        int randnum = hillRNG.nextInt(16);
        if (biomeAt == TFBiomeBase.glacier) {
            return iceTower;
        }
        if (biomeAt == TFBiomeBase.tfLake) {
            return questIsland;
        }
        if (biomeAt == TFBiomeBase.enchantedForest) {
            return questGrove;
        }
        if (biomeAt == TFBiomeBase.fireSwamp) {
            return hydraLair;
        }
        if (biomeAt == TFBiomeBase.clearing || biomeAt == TFBiomeBase.oakSavanna) {
            return labyrinth;
        }
        if (biomeAt == TFBiomeBase.darkForest) {
            switch (randnum % 3) {
                case 0: {
                    break;
                }
                case 1: {
                    return darkTower;
                }
                case 2: {
                    return tfStronghold;
                }
            }
        }
        if (biomeAt == TFBiomeBase.highlandsCenter) {
            return finalCastle;
        }
        if (biomeAt == TFBiomeBase.highlands) {
            return trollCave;
        }
        if (biomeAt == TFBiomeBase.deepMushrooms) {
            return mushroomTower;
        }
        switch (randnum) {
            default: {
                tFFeature = hill1;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                tFFeature = hill2;
                break;
            }
            case 10: {
                tFFeature = hill3;
                break;
            }
            case 11: 
            case 12: {
                tFFeature = hedgeMaze;
                break;
            }
            case 13: {
                if (biomeAt != TFBiomeBase.tfSwamp) {
                    tFFeature = nagaCourtyard;
                    break;
                }
                tFFeature = hydraLair;
                break;
            }
            case 14: 
            case 15: {
                tFFeature = lichTower;
            }
        }
        return tFFeature;
    }

    public static TFFeature generateFeatureFor1Point7(int chunkX, int chunkZ, World world) {
        TFFeature tFFeature;
        if (TwilightForestMod.oldMapGen) {
            return TFFeature.generateFeatureForOldMapGen(chunkX, chunkZ, world);
        }
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        BiomeGenBase biomeAt = world.func_72807_a((chunkX << 4) + 8, (chunkZ << 4) + 8);
        Random hillRNG = new Random(world.func_72905_C() + (long)chunkX * 25117L + (long)chunkZ * 151121L);
        int randnum = hillRNG.nextInt(16);
        if (biomeAt == TFBiomeBase.glacier) {
            return iceTower;
        }
        if (biomeAt == TFBiomeBase.tfSnow) {
            return yetiCave;
        }
        if (biomeAt == TFBiomeBase.tfLake) {
            return questIsland;
        }
        if (biomeAt == TFBiomeBase.enchantedForest) {
            return questGrove;
        }
        if (biomeAt == TFBiomeBase.fireSwamp) {
            return hydraLair;
        }
        if (biomeAt == TFBiomeBase.tfSwamp) {
            return labyrinth;
        }
        if (biomeAt == TFBiomeBase.darkForest) {
            return tfStronghold;
        }
        if (biomeAt == TFBiomeBase.darkForestCenter) {
            return darkTower;
        }
        if (biomeAt == TFBiomeBase.highlandsCenter) {
            return finalCastle;
        }
        if (biomeAt == TFBiomeBase.highlands) {
            return trollCave;
        }
        if (biomeAt == TFBiomeBase.deepMushrooms) {
            return mushroomTower;
        }
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return lichTower;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return nagaCourtyard;
        }
        switch (randnum) {
            default: {
                tFFeature = hill1;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                tFFeature = hill2;
                break;
            }
            case 9: {
                tFFeature = hill3;
                break;
            }
            case 10: 
            case 11: {
                tFFeature = hedgeMaze;
                break;
            }
            case 12: 
            case 13: {
                tFFeature = nagaCourtyard;
                break;
            }
            case 14: 
            case 15: {
                tFFeature = lichTower;
            }
        }
        return tFFeature;
    }

    public static TFFeature generateFeaturePreset5x5(int chunkX, int chunkZ, World world) {
        int cf = 16;
        if (chunkX % cf != 0 || chunkZ % cf != 0) {
            return nothing;
        }
        int mx = chunkX / cf + 4;
        int mz = chunkZ / cf + 4;
        int[][] map = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 19, 18, 8, 15, 14, 0}, {0, 0, 18, 18, 2, 3, 15, 0}, {0, 0, 4, 4, 5, 16, 9, 0}, {0, 0, 13, 6, 1, 2, 17, 0}, {0, 0, 12, 13, 3, 17, 7, 0}, {0, 0, 0, 0, 0, 0, 0, 0}};
        if (mx >= 0 && mx < 8 && mz >= 0 && mz < 8) {
            return featureList[map[mz][mx]];
        }
        return nothing;
    }

    public static TFFeature generateFeaturePreset6x6(int chunkX, int chunkZ, World world) {
        int cf = 16;
        if (chunkX % cf != 0 || chunkZ % cf != 0) {
            return nothing;
        }
        int mx = chunkX / cf + 3;
        int mz = chunkZ / cf + 3;
        int[][] map = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}, {0, 19, 19, 18, 15, 0, 0, 0}, {0, 18, 18, 18, 0, 14, 0, 0}, {0, 0, 4, 1, 2, 3, 15, 0}, {0, 4, 1, 5, 16, 9, 17, 0}, {0, 0, 13, 2, 3, 17, 17, 0}, {0, 0, 12, 13, 6, 17, 7, 0}, {0, 0, 0, 0, 0, 0, 0, 0}};
        if (mx >= 0 && mx < 8 && mz >= 0 && mz < 8) {
            return featureList[map[mz][mx]];
        }
        return nothing;
    }

    public static TFFeature getNearestFeature(int cx, int cz, World world) {
        for (int rad = 1; rad <= 3; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    TFFeature directlyAt = TFFeature.getFeatureDirectlyAt(x + cx, z + cz, world);
                    if (directlyAt.size != rad) continue;
                    return directlyAt;
                }
            }
        }
        return nothing;
    }

    public static TFFeature getFeatureForRegion(int chunkX, int chunkZ, World world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return TFFeature.generateFeatureFor1Point7(featureX, featureZ, world);
    }

    public static int[] getNearestCenter(int cx, int cz, World world) {
        for (int rad = 1; rad <= 3; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    if (TFFeature.getFeatureDirectlyAt((int)(x + cx), (int)(z + cz), (World)world).size != rad) continue;
                    int[] center = new int[]{x * 16 + 8, z * 16 + 8};
                    return center;
                }
            }
        }
        int[] no = new int[]{0, 0};
        return no;
    }

    public static ChunkCoordinates getNearestCenterXYZ(int cx, int cz, World world) {
        if (TwilightForestMod.oldMapGen) {
            return TFFeature.getNearestCenterXYZOld(cx, cz, world);
        }
        int chunkX = cx;
        int chunkZ = cz;
        int regionX = chunkX + 8 >> 4;
        int regionZ = chunkZ + 8 >> 4;
        long seed = (long)regionX * 3129871L ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new ChunkCoordinates(ccx, TFWorld.SEALEVEL, ccz);
    }

    private static ChunkCoordinates getNearestCenterXYZOld(int cx, int cz, World world) {
        int fx = (int)(Math.round((double)cx / 256.0) * 256L + 8L);
        int fz = (int)(Math.round((double)cz / 256.0) * 256L + 8L);
        return new ChunkCoordinates(fx, TFWorld.SEALEVEL, fz);
    }

    public List<BiomeGenBase.SpawnListEntry> getSpawnableList(EnumCreatureType creatureType) {
        List<BiomeGenBase.SpawnListEntry> list;
        switch (creatureType) {
            case monster: {
                list = this.getSpawnableList(EnumCreatureType.monster, 0);
                break;
            }
            case ambient: {
                list = this.ambientCreatureList;
                break;
            }
            case waterCreature: {
                list = this.waterCreatureList;
                break;
            }
            default: {
                list = this.emptyList;
            }
        }
        return list;
    }

    public List<BiomeGenBase.SpawnListEntry> getSpawnableList(EnumCreatureType creatureType, int index) {
        if (creatureType == EnumCreatureType.monster) {
            if (index >= 0 && index < this.spawnableMonsterLists.size()) {
                return this.spawnableMonsterLists.get(index);
            }
            return this.emptyList;
        }
        return this.getSpawnableList(creatureType);
    }

    private TFFeature setRequiredAchievement(Achievement required) {
        this.requiredAchievement = required;
        return this;
    }

    public boolean doesPlayerHaveRequiredAchievement(EntityPlayer player) {
        if (this.requiredAchievement != null) {
            if (player instanceof EntityPlayerMP && ((EntityPlayerMP)player).func_147099_x() != null) {
                StatisticsFile stats = ((EntityPlayerMP)player).func_147099_x();
                return stats.func_77443_a(this.requiredAchievement);
            }
            return false;
        }
        return true;
    }

    public void trySpawnHintMonster(World world, EntityPlayer player) {
        this.trySpawnHintMonster(world, player, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
    }

    public void trySpawnHintMonster(World world, EntityPlayer player, int x, int y, int z) {
        long currentTime = world.func_82737_E();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, x, y, z)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    private boolean didSpawnHintMonster(World world, EntityPlayer player, int x, int y, int z) {
        boolean isClearSpawn;
        int dx = x + world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16);
        int dy = y + world.field_73012_v.nextInt(4) - world.field_73012_v.nextInt(4);
        int dz = z + world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16);
        EntityTFKobold hinty = new EntityTFKobold(world);
        hinty.func_70107_b(dx, dy, dz);
        boolean bl = isClearSpawn = world.func_72855_b(hinty.field_70121_D) && world.func_72945_a((Entity)hinty, hinty.field_70121_D).isEmpty() && !world.func_72953_d(hinty.field_70121_D);
        if (isClearSpawn && hinty.func_70685_l((Entity)player)) {
            ItemStack book = this.createHintBook();
            hinty.func_70062_b(0, book);
            hinty.func_96120_a(0, 1.0f);
            world.func_72838_d((Entity)hinty);
            return true;
        }
        return false;
    }

    public ItemStack createHintBook() {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        NBTTagList bookPages = new NBTTagList();
        if (this == lichTower) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, gnawed on by monsters]]\u00a70\n\nI have begun examining the strange aura surrounding this tower. The bricks of the tower are protected by a curse, stronger than any I've seen before. The magic from the curse"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("is boiling off into the surrounding area.\n\nIn my homeland I would have many options for dealing with this magic, but here my supplies are limited. I shall have to research..."));
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[Many entries later]]\u00a70\n\nA breakthrough!  In my journeys I sighted a huge snake-like monster in a decorated courtyard. Nearby, I picked up a worn down, discarded green scale.\n\nThe magic in the scale seems to have the"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("curse-breaking properties I need, but the magic is too dim. I may need to acquire a fresher specimen, directly from the creature."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Pointy Tower"));
        } else if (this == labyrinth) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, written on waterproof paper]]\u00a70\n\nThe mosquitoes in this swamp are vexing, but strange. The vast majority of them seem to have no natural source, nor do they seem to have a role in the local ecology. I have begun to"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("suspect that they are some kind of magical curse.\n\n\u00a78[[Next entry]]\u00a70\n\nNow that I have encountered a protection spell on the ruined labyrinth here, I consider my suspicions confirmed. Both the protection"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("spell and the mosquitoes are a curse. This curse seems to have a different source from the others I have encountered. I will have to research further...\n\n\u00a78[[Next entry]]\u00a70\n\nThe curse seems to"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("be of a type too powerful for one being alone to produce. Several wizards working in combination would be necessary.\n\nIf one of the wizards stopped contributing, the whole of the curse over the entire swamp would fall. Strangely, "));
            bookPages.func_74742_a((NBTBase)new NBTTagString("my divinations do not show signs of any nearby living wizards. I did see something interesting in one of the nearby pointy-roofed towers though..."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Swampy Labyrinth"));
        } else if (this == hydraLair) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, written on fireproof paper]]\u00a70\n\nFire is a trivial obstacle for a master explorer such as myself. I have traversed seas of fire, and swam through oceans of lava. The burning air here is an interesting variation,"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("but ultimately no hinderance.\n\nWhat does stop me though is that I have encountered another protection spell, this time surrounding a mighty creature that must be king of this fire swamp. This is not the first protection spell I have"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("encountered, and I am beginning to unravel the mysteries of how they work.\n\nIf this spell is like the others, it will be sustained by a powerful creature nearby. Surrounding the fire swamp are several wet swamps, and under those"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("swamps are labyrinths full of minotaurs. The logical choice to bind such a spell to would be some sort of powerful minotaur, different in some way from the others that surround it..."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on the Fire Swamp"));
        } else if (this == tfStronghold) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, written on faintly glowing paper]]\u00a70\n\nThe tendrils of darkness surrounding this area are just a manifestation of a protective spell over the entire dark forest. The spell causes blindness, which is quite vexing. I have"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("seen several interesting things in the area and would like to keep exploring.\n\n\u00a78[[Next entry]]\u00a70\n\nI have found ruins in the dark forest.  They belong to a stronghold, of a type usually inhabited by knights. Rather than"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("knights though, this stronghold is full of goblins. They wear knightly armor, but their behavior is most un-knightly.\n\n\u00a78[[Next entry]]\u00a70\n\nDeep in the ruins, I have found a pedestal. The pedestal seems to be of a type that"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("knights would place trophies on to prove their strength.\n\nKilling a powerful creature would seem to weaken the curse on the dark forest, and placing a trophy associated with the creature on the pedestal would likely grant access into the"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("main part of the stronghold.\n\nThe only creature I have seen so far seen so far of sufficient power is the many-headed beast in the fire swamp. How vexing..."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Stronghold"));
        } else if (this == darkTower) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook that seems to have survived an explosion]]\u00a70\n\nThis tower clearly has mechanisms that are not responding to me. Their magic almost yearns to acknowledge my touch, but it cannot. It is if the devices of the tower are being"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("suppressed by a powerful group of beings nearby.\n\n\u00a78[[Next entry]]\u00a70\n\nThe magic seems to emanate from deep within the strongholds nearby. It can't come from the goblins, as their magic is charming, but unfocused. There"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("must still be some force still active in the strongholds.\n\n\u00a78[[Next entry]]\u00a70\n\nMy analysis indicates that it comes from several sources, operating as a group. I will head back to the stronghold after I resupply..."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on a Wooden Tower"));
        } else if (this == yetiCave) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, covered in frost]]\u00a70\n\nThe blizzard surrounding these snowy lands is unceasing. This is no ordinary snowfall--this is a magical phenomenon. I will have to conduct experiments to find"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("what is capable of causing such an effect.\n\n\u00a78[[Next entry]]\u00a70\n\nAt the center of the dark forest, where the leaves turn red and the grass dies, there is a wooden tower. The tops of the tower are affixed with"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("structures acting as antennae. The antennae are not the source of the snowfall, but serve merely to boost the power of the curse causing it.\n\nA blizzard this intense must be caused by a powerful creature, most likely found"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("near the top of the dark forest tower. Stop the creature, and the blizzard will fade."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on an Icy Cave"));
        } else if (this == iceTower) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, caked in ice]]\u00a70\n\nI overcame one blizzard, only to run into this terrible ice storm atop the glacier. My explorations have shown me the splendor of an ice palace, shining with the colors of the polar aurora. It"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("all seems protected by some sort of curse.\n\n\u00a78[[Next entry]]\u00a70\n\nI am no novice.  This curse is fed by the power of a creature nearby.  The cause of the curse surrounding the fire swamp was built off the power of the leader of the "));
            bookPages.func_74742_a((NBTBase)new NBTTagString("minotaurs nearby.\n\nSurrounding this glacier, there are masses of yetis.  Perhaps the yetis have some sort of leader..."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on an Auroral Fortification"));
        } else if (this == trollCave) {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[An explorer's notebook, damaged by acid]]\u00a70\n\nThere seems to be no way to protect myself from the toxic rainstorm surrounding this area. In my brief excursions, I have also encountered another protection spell, similar to the"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("others I have witnessed. The spell must be connected to the toxic storm in some way. Further research to follow...\n\n\u00a78[[Next entry]]\u00a70\n\nSuch supreme weather magic must be the result of an unequaled weather"));
            bookPages.func_74742_a((NBTBase)new NBTTagString("magician. Such a person would likely hide themselves in an extreme environment, far away.\n\nBased on my logic, I would expect to find such a person somewhere on the glacier, perhaps in some sort of fortress there..."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on an the Highlands"));
        } else {
            bookPages.func_74742_a((NBTBase)new NBTTagString("\u00a78[[This book shows signs of having been copied many times]]\u00a70\n\nI cannot explain the field surrounding this structure, but the magic is powerful.  If this curse is like the others, than the answer to unlocking it lies elsewhere.  Perhaps there is "));
            bookPages.func_74742_a((NBTBase)new NBTTagString("something I have left undone, or some monster I have yet to defeat. I will have to turn back. I will return to this place later, to see if anything has changed."));
            book.func_77983_a("pages", (NBTBase)bookPages);
            book.func_77983_a("author", (NBTBase)new NBTTagString("A Forgotten Explorer"));
            book.func_77983_a("title", (NBTBase)new NBTTagString("Notes on the Unexplained"));
        }
        return book;
    }

    static {
        lichTower.addMonster(EntityZombie.class, 10, 4, 4);
        lichTower.addMonster(EntitySkeleton.class, 10, 4, 4);
        lichTower.addMonster(EntityCreeper.class, 1, 4, 4);
        lichTower.addMonster(EntityEnderman.class, 1, 1, 4);
        lichTower.addMonster(EntityTFDeathTome.class, 10, 4, 4);
        lichTower.addMonster(EntityWitch.class, 1, 1, 1);
        hill1.addMonster(EntitySpider.class, 10, 4, 4);
        hill1.addMonster(EntityZombie.class, 10, 4, 4);
        hill1.addMonster(EntityTFRedcap.class, 10, 4, 4);
        hill1.addMonster(EntityTFSwarmSpider.class, 10, 4, 4);
        hill1.addMonster(EntityTFKobold.class, 10, 4, 8);
        hill2.addMonster(EntityTFRedcap.class, 10, 4, 4);
        hill2.addMonster(EntityTFRedcapSapper.class, 1, 1, 4);
        hill2.addMonster(EntityTFKobold.class, 10, 4, 8);
        hill2.addMonster(EntitySkeleton.class, 10, 4, 4);
        hill2.addMonster(EntityTFSwarmSpider.class, 10, 4, 4);
        hill2.addMonster(EntitySpider.class, 10, 4, 4);
        hill2.addMonster(EntityCreeper.class, 10, 4, 4);
        hill2.addMonster(EntityTFFireBeetle.class, 5, 4, 4);
        hill2.addMonster(EntityTFSlimeBeetle.class, 5, 4, 4);
        hill2.addMonster(EntityWitch.class, 1, 1, 1);
        hill3.addMonster(EntityTFRedcap.class, 10, 4, 4);
        hill3.addMonster(EntityTFRedcapSapper.class, 2, 1, 4);
        hill3.addMonster(EntitySkeleton.class, 10, 4, 4);
        hill3.addMonster(EntityCaveSpider.class, 10, 4, 4);
        hill3.addMonster(EntityCreeper.class, 10, 4, 4);
        hill3.addMonster(EntityEnderman.class, 1, 1, 4);
        hill3.addMonster(EntityTFWraith.class, 2, 1, 4);
        hill3.addMonster(EntityTFFireBeetle.class, 10, 4, 4);
        hill3.addMonster(EntityTFSlimeBeetle.class, 10, 4, 4);
        hill3.addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        hill3.addMonster(EntityWitch.class, 1, 1, 1);
        labyrinth.addMonster(EntityTFMinotaur.class, 20, 2, 4);
        labyrinth.addMonster(EntityCaveSpider.class, 10, 4, 4);
        labyrinth.addMonster(EntityCreeper.class, 10, 4, 4);
        labyrinth.addMonster(EntityTFMazeSlime.class, 10, 4, 4);
        labyrinth.addMonster(EntityEnderman.class, 1, 1, 4);
        labyrinth.addMonster(EntityTFFireBeetle.class, 10, 4, 4);
        labyrinth.addMonster(EntityTFSlimeBeetle.class, 10, 4, 4);
        labyrinth.addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        darkTower.addMonster(EntityTFTowerGolem.class, 10, 4, 4);
        darkTower.addMonster(EntitySkeleton.class, 10, 4, 4);
        darkTower.addMonster(EntityCreeper.class, 10, 4, 4);
        darkTower.addMonster(EntityEnderman.class, 2, 1, 4);
        darkTower.addMonster(EntityWitch.class, 1, 1, 1);
        darkTower.addMonster(EntityTFMiniGhast.class, 10, 1, 4);
        darkTower.addMonster(EntityTFTowerBroodling.class, 10, 8, 8);
        darkTower.addMonster(EntityTFPinchBeetle.class, 10, 2, 4);
        darkTower.addMonster(1, EntityTFTowerGhast.class, 10, 1, 4);
        darkTower.addWaterCreature(EntitySquid.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFBlockGoblin.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFGoblinKnightLower.class, 5, 1, 2);
        tfStronghold.addMonster(EntityTFHelmetCrab.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFSlimeBeetle.class, 10, 4, 4);
        tfStronghold.addMonster(EntityTFRedcapSapper.class, 2, 1, 4);
        tfStronghold.addMonster(EntityTFKobold.class, 10, 4, 8);
        tfStronghold.addMonster(EntityCreeper.class, 10, 4, 4);
        tfStronghold.addMonster(EntitySlime.class, 5, 4, 4);
        yetiCave.addMonster(EntityTFYeti.class, 10, 4, 4);
        iceTower.addMonster(EntityTFSnowGuardian.class, 10, 4, 4);
        iceTower.addMonster(EntityTFIceShooter.class, 10, 4, 4);
        iceTower.addMonster(EntityTFIceExploder.class, 5, 4, 4);
        trollCave.addMonster(EntityCreeper.class, 5, 4, 4);
        trollCave.addMonster(EntitySkeleton.class, 10, 4, 4);
        trollCave.addMonster(EntityTFTroll.class, 20, 4, 4);
        trollCave.addMonster(EntityWitch.class, 5, 1, 1);
        trollCave.addMonster(1, EntityTFGiantMiner.class, 10, 1, 4);
        trollCave.addMonster(1, EntityTFArmoredGiant.class, 10, 1, 4);
        finalCastle.addMonster(EntityTFKobold.class, 10, 4, 4);
        finalCastle.addMonster(EntityTFAdherent.class, 10, 1, 1);
        finalCastle.addMonster(EntityTFHarbingerCube.class, 10, 1, 1);
        finalCastle.addMonster(EntityEnderman.class, 10, 1, 1);
        finalCastle.addMonster(1, EntityTFKobold.class, 10, 4, 4);
        finalCastle.addMonster(1, EntityTFAdherent.class, 10, 1, 1);
        finalCastle.addMonster(1, EntityTFHarbingerCube.class, 10, 1, 1);
        finalCastle.addMonster(1, EntityTFArmoredGiant.class, 10, 1, 1);
        finalCastle.addMonster(2, EntityTFAdherent.class, 10, 1, 1);
        finalCastle.addMonster(3, EntityBlaze.class, 10, 1, 1);
    }
}

