/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.AEApi;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderBlockSkyChest;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.helpers.ICustomCollision;
import appeng.tile.storage.TileSkyChest;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSkyChest
extends AEBaseBlock
implements ICustomCollision {
    public BlockSkyChest() {
        super(BlockSkyChest.class, Material.field_151576_e);
        this.setTileEntity(TileSkyChest.class);
        this.isFullSize = false;
        this.isOpaque = false;
        this.field_149786_r = 0;
        this.hasSubtypes = true;
        this.func_149711_c(50.0f);
        this.field_149781_w = 150.0f;
        this.setFeature(EnumSet.of(AEFeature.Core, AEFeature.SkyStoneChests));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack is = super.getPickBlock(target, world, x, y, z, player);
        is.func_77964_b(world.func_72805_g(x, y, z));
        return is;
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderBlockSkyChest.class;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int direction, int metadata) {
        Iterator i$ = AEApi.instance().definitions().blocks().skyStone().maybeBlock().asSet().iterator();
        if (i$.hasNext()) {
            Block skyStoneBlock = (Block)i$.next();
            return skyStoneBlock.func_149691_a(direction, metadata);
        }
        return Blocks.field_150348_b.func_149691_a(direction, metadata);
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (Platform.isServer()) {
            Platform.openGUI(player, this.getTileEntity((IBlockAccess)w, x, y, z), ForgeDirection.getOrientation((int)side), GuiBridge.GUI_SKYCHEST);
        }
        return true;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegistry) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        itemStacks.add(new ItemStack(item, 1, 1));
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        if (is.func_77960_j() == 1) {
            return this.func_149739_a() + ".Block";
        }
        return this.func_149739_a();
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        TileSkyChest sk = (TileSkyChest)this.getTileEntity((IBlockAccess)w, x, y, z);
        double sc = 0.06;
        ForgeDirection o = ForgeDirection.UNKNOWN;
        if (sk != null) {
            o = sk.getUp();
        }
        double X = o.offsetX == 0 ? 0.06 : 0.0;
        double Y = o.offsetY == 0 ? 0.06 : 0.0;
        double Z = o.offsetZ == 0 ? 0.06 : 0.0;
        return Collections.singletonList(AxisAlignedBB.func_72330_a((double)Math.max(0.0, X - (double)o.offsetX * sc), (double)Math.max(0.0, Y - (double)o.offsetY * sc), (double)Math.max(0.0, Z - (double)o.offsetZ * sc), (double)Math.min(1.0, 1.0 - X - (double)o.offsetX * sc), (double)Math.min(1.0, 1.0 - Y - (double)o.offsetY * sc), (double)Math.min(1.0, 1.0 - Z - (double)o.offsetZ * sc)));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        out.add(AxisAlignedBB.func_72330_a((double)0.05, (double)0.05, (double)0.05, (double)0.95, (double)0.95, (double)0.95));
    }
}

