/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.spatial.TileSpatialIOPort;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerSpatialIOPort
extends AEBaseContainer {
    final TileSpatialIOPort spatialIOPort;
    @GuiSync(value=0)
    public long currentPower;
    @GuiSync(value=1)
    public long maxPower;
    @GuiSync(value=2)
    public long reqPower;
    @GuiSync(value=3)
    public long eff;
    IGrid network;
    int delay = 40;

    public ContainerSpatialIOPort(InventoryPlayer ip, TileSpatialIOPort spatialIOPort) {
        super(ip, spatialIOPort, null);
        this.spatialIOPort = spatialIOPort;
        if (Platform.isServer()) {
            this.network = spatialIOPort.getGridNode(ForgeDirection.UNKNOWN).getGrid();
        }
        this.func_75146_a(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.SPATIAL_STORAGE_CELLS, (IInventory)spatialIOPort, 0, 52, 48, this.invPlayer));
        this.func_75146_a(new SlotOutput((IInventory)spatialIOPort, 1, 113, 48, SlotRestrictedInput.PlacableItemType.SPATIAL_STORAGE_CELLS.IIcon));
        this.bindPlayerInventory(ip, 0, 115);
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (Platform.isServer()) {
            ++this.delay;
            if (this.delay > 15 && this.network != null) {
                this.delay = 0;
                IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
                ISpatialCache sc = (ISpatialCache)this.network.getCache(ISpatialCache.class);
                if (eg != null) {
                    this.currentPower = (long)(100.0 * eg.getStoredPower());
                    this.maxPower = (long)(100.0 * eg.getMaxStoredPower());
                    this.reqPower = (long)(100.0 * (double)sc.requiredPower());
                    this.eff = (long)(100.0f * sc.currentEfficiency());
                }
            }
        }
        super.func_75142_b();
    }
}

