/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.FacadeConfig;
import appeng.core.IMCHandler;
import appeng.core.Registration;
import appeng.core.WorldSettings;
import appeng.core.crash.CrashInfo;
import appeng.core.crash.IntegrationCrashEnhancement;
import appeng.core.crash.ModCrashEnhancement;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.server.AECommand;
import appeng.services.VersionChecker;
import appeng.services.version.VersionCheckerConfig;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.ICommand;

@Mod(modid="appliedenergistics2", acceptedMinecraftVersions="[1.7.10]", name="Applied Energistics 2", version="rv2-stable-10", dependencies="after:appliedenergistics2-core;required-after:Forge@[10.13.2.1291,)", guiFactory="appeng.client.gui.config.AEConfigGuiFactory")
public final class AppEng {
    public static final String MOD_ID = "appliedenergistics2";
    public static final String MOD_NAME = "Applied Energistics 2";
    public static final String MOD_DEPENDENCIES = "after:appliedenergistics2-core;required-after:Forge@[10.13.2.1291,)";
    public static AppEng instance;
    private final IMCHandler imcHandler;
    private File configDirectory;

    public AppEng() {
        instance = this;
        this.imcHandler = new IMCHandler();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new ModCrashEnhancement(CrashInfo.MOD_VERSION));
    }

    public final File getConfigDirectory() {
        return this.configDirectory;
    }

    public boolean isIntegrationEnabled(IntegrationType integrationName) {
        return IntegrationRegistry.INSTANCE.isEnabled(integrationName);
    }

    public Object getIntegration(IntegrationType integrationName) {
        return IntegrationRegistry.INSTANCE.getInstance(integrationName);
    }

    @Mod.EventHandler
    void preInit(FMLPreInitializationEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2-core")) {
            CommonHelper.proxy.missingCoreMod();
        }
        Stopwatch watch = Stopwatch.createStarted();
        this.configDirectory = new File(event.getModConfigurationDirectory().getPath(), "AppliedEnergistics2");
        File configFile = new File(this.configDirectory, "AppliedEnergistics2.cfg");
        File facadeFile = new File(this.configDirectory, "Facades.cfg");
        File versionFile = new File(this.configDirectory, "VersionChecker.cfg");
        AEConfig.instance = new AEConfig(configFile);
        FacadeConfig.instance = new FacadeConfig(facadeFile);
        VersionCheckerConfig versionCheckerConfig = new VersionCheckerConfig(versionFile);
        AELog.info("Pre Initialization ( started )", new Object[0]);
        CreativeTab.init();
        if (AEConfig.instance.isFeatureEnabled(AEFeature.Facades)) {
            CreativeTabFacade.init();
        }
        if (Platform.isClient()) {
            CommonHelper.proxy.init();
        }
        Registration.INSTANCE.preInitialize(event);
        if (versionCheckerConfig.isEnabled()) {
            VersionChecker versionChecker = new VersionChecker(versionCheckerConfig);
            Thread versionCheckerThread = new Thread(versionChecker);
            this.startService("AE2 VersionChecker", versionCheckerThread);
        }
        AELog.info("Pre Initialization ( ended after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        AELog.info("Starting " + serviceName, new Object[0]);
        thread.start();
    }

    @Mod.EventHandler
    void init(FMLInitializationEvent event) {
        Stopwatch star = Stopwatch.createStarted();
        AELog.info("Initialization ( started )", new Object[0]);
        Registration.INSTANCE.initialize(event);
        IntegrationRegistry.INSTANCE.init();
        AELog.info("Initialization ( ended after " + star.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    void postInit(FMLPostInitializationEvent event) {
        Stopwatch star = Stopwatch.createStarted();
        AELog.info("Post Initialization ( started )", new Object[0]);
        Registration.INSTANCE.postInit(event);
        IntegrationRegistry.INSTANCE.postInit();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new IntegrationCrashEnhancement());
        CommonHelper.proxy.postInit();
        AEConfig.instance.save();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiBridge.GUI_Handler);
        NetworkHandler.instance = new NetworkHandler("AE2");
        AELog.info("Post Initialization ( ended after " + star.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    public void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        this.imcHandler.handleIMCEvent(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        WorldSettings.getInstance().shutdown();
        TickHandler.INSTANCE.shutdown();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        WorldSettings.getInstance().init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new AECommand(evt.getServer()));
    }
}

