/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.IItemDefinition;
import appeng.core.features.IStackSrc;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public final class DamagedItemDefinition
implements IItemDefinition {
    private final IStackSrc source;

    public DamagedItemDefinition(@Nonnull IStackSrc source) {
        this.source = (IStackSrc)Preconditions.checkNotNull((Object)source);
    }

    @Override
    public Optional<Item> maybeItem() {
        Item item = this.source.getItem();
        return Optional.fromNullable((Object)item);
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        ItemStack stack = this.source.stack(stackSize);
        return Optional.fromNullable((Object)stack);
    }

    @Override
    public boolean isSameAs(ItemStack comparableStack) {
        if (comparableStack == null) {
            return false;
        }
        return comparableStack.func_77973_b() == this.source.getItem() && comparableStack.func_77960_j() == this.source.getDamage();
    }

    @Override
    public boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

