/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.client.gui.AEBaseMEGui;
import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.integration.BaseModule;
import appeng.integration.abstraction.INEI;
import appeng.integration.modules.NEIHelpers.NEIAEShapedRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIAEShapelessRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEICraftingHandler;
import appeng.integration.modules.NEIHelpers.NEIFacadeRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIGrinderRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIInscriberRecipeHandler;
import appeng.integration.modules.NEIHelpers.NEIWorldCraftingHandler;
import appeng.integration.modules.NEIHelpers.TerminalCraftingSlotFinder;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class NEI
extends BaseModule
implements INEI,
IContainerTooltipHandler {
    public static NEI instance;
    Class<?> API;
    Method registerRecipeHandler;
    Method registerUsageHandler;

    public NEI() throws ClassNotFoundException {
        this.testClassExistence(GuiContainerManager.class);
        this.testClassExistence(ICraftingHandler.class);
        this.testClassExistence(IUsageHandler.class);
        this.API = Class.forName("codechicken.nei.api.API");
    }

    @Override
    public void init() throws Throwable {
        this.registerRecipeHandler = this.API.getDeclaredMethod("registerRecipeHandler", ICraftingHandler.class);
        this.registerUsageHandler = this.API.getDeclaredMethod("registerUsageHandler", IUsageHandler.class);
        this.registerRecipeHandler((Object)new NEIAEShapedRecipeHandler());
        this.registerRecipeHandler((Object)new NEIAEShapelessRecipeHandler());
        this.registerRecipeHandler((Object)new NEIInscriberRecipeHandler());
        this.registerRecipeHandler(new NEIWorldCraftingHandler());
        this.registerRecipeHandler((Object)new NEIGrinderRecipeHandler());
        if (AEConfig.instance.isFeatureEnabled(AEFeature.Facades) && AEConfig.instance.isFeatureEnabled(AEFeature.enableFacadeCrafting)) {
            this.registerRecipeHandler((Object)new NEIFacadeRecipeHandler());
        }
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)this);
        Method registerGuiOverlay = this.API.getDeclaredMethod("registerGuiOverlay", Class.class, String.class, IStackPositioner.class);
        Class<?> IOverlayHandler2 = Class.forName("codechicken.nei.api.IOverlayHandler");
        Class<NEICraftingHandler> DefaultOverlayHandler = NEICraftingHandler.class;
        Method registerGuiOverlayHandler = this.API.getDeclaredMethod("registerGuiOverlayHandler", Class.class, IOverlayHandler2, String.class);
        registerGuiOverlay.invoke(this.API, GuiCraftingTerm.class, "crafting", new TerminalCraftingSlotFinder());
        registerGuiOverlay.invoke(this.API, GuiPatternTerm.class, "crafting", new TerminalCraftingSlotFinder());
        Constructor DefaultOverlayHandlerConstructor = DefaultOverlayHandler.getConstructor(Integer.TYPE, Integer.TYPE);
        registerGuiOverlayHandler.invoke(this.API, GuiCraftingTerm.class, DefaultOverlayHandlerConstructor.newInstance(6, 75), "crafting");
        registerGuiOverlayHandler.invoke(this.API, GuiPatternTerm.class, DefaultOverlayHandlerConstructor.newInstance(6, 75), "crafting");
    }

    public void registerRecipeHandler(Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.registerRecipeHandler.invoke(this.API, o);
        this.registerUsageHandler.invoke(this.API, o);
    }

    @Override
    public void postInit() {
    }

    @Override
    public void drawSlot(Slot s) {
        if (s == null) {
            return;
        }
        ItemStack stack = s.func_75211_c();
        if (stack == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        int x = s.field_75223_e;
        int y = s.field_75221_f;
        GuiContainerManager.drawItems.func_82406_b(fontRenderer, mc.func_110434_K(), stack, x, y);
        GuiContainerManager.drawItems.func_94148_a(fontRenderer, mc.func_110434_K(), stack, x, y, String.valueOf(stack.field_77994_a));
    }

    @Override
    public RenderItem setItemRender(RenderItem renderItem) {
        try {
            RenderItem ri = GuiContainerManager.drawItems;
            GuiContainerManager.drawItems = renderItem;
            return ri;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Invalid version of NEI, please update", t);
        }
    }

    public List<String> handleTooltip(GuiContainer arg0, int arg1, int arg2, List<String> current) {
        return current;
    }

    public List<String> handleItemDisplayName(GuiContainer arg0, ItemStack arg1, List<String> current) {
        return current;
    }

    public List<String> handleItemTooltip(GuiContainer guiScreen, ItemStack stack, int mouseX, int mouseY, List<String> currentToolTip) {
        if (guiScreen instanceof AEBaseMEGui) {
            return ((AEBaseMEGui)guiScreen).handleItemTooltip(stack, mouseX, mouseY, currentToolTip);
        }
        return currentToolTip;
    }
}

