/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import appeng.api.AEApi;
import appeng.api.features.IGrinderEntry;
import appeng.api.implementations.tiles.ICrankable;
import appeng.api.util.WorldCoord;
import appeng.tile.AEBaseInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGrinder
extends AEBaseInvTile
implements ICrankable {
    final int[] inputs = new int[]{0, 1, 2};
    final int[] sides = new int[]{0, 1, 2, 3, 4, 5};
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 7);
    int points;

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.func_145838_q().func_149695_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Platform.AIR);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public boolean func_102007_a(int slotIndex, ItemStack insertingItem, int side) {
        if (AEApi.instance().registries().grinder().getRecipeForInput(insertingItem) == null) {
            return false;
        }
        return slotIndex >= 0 && slotIndex <= 2;
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        return slotIndex >= 3 && slotIndex <= 5;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }

    @Override
    public boolean canTurn() {
        if (Platform.isClient()) {
            return false;
        }
        if (null == this.func_70301_a(6)) {
            WrapperInventoryRange src = new WrapperInventoryRange((IInventory)this, this.inputs, true);
            for (int x = 0; x < src.func_70302_i_(); ++x) {
                IGrinderEntry r;
                ItemStack item = src.func_70301_a(x);
                if (item == null || (r = AEApi.instance().registries().grinder().getRecipeForInput(item)) == null || item.field_77994_a < r.getInput().field_77994_a) continue;
                item.field_77994_a -= r.getInput().field_77994_a;
                ItemStack ais = item.func_77946_l();
                ais.field_77994_a = r.getInput().field_77994_a;
                if (item.field_77994_a <= 0) {
                    item = null;
                }
                src.func_70299_a(x, item);
                this.func_70299_a(6, ais);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyTurn() {
        if (Platform.isClient()) {
            return;
        }
        ++this.points;
        ItemStack processing = this.func_70301_a(6);
        IGrinderEntry r = AEApi.instance().registries().grinder().getRecipeForInput(processing);
        if (r != null) {
            if (r.getEnergyCost() > this.points) {
                return;
            }
            this.points = 0;
            InventoryAdaptor sia = InventoryAdaptor.getAdaptor(new WrapperInventoryRange((IInventory)this, 3, 3, true), ForgeDirection.EAST);
            this.addItem(sia, r.getOutput());
            float chance = (float)(Platform.getRandomInt() % 2000) / 2000.0f;
            if (chance <= r.getOptionalChance()) {
                this.addItem(sia, r.getOptionalOutput());
            }
            if ((chance = (float)(Platform.getRandomInt() % 2000) / 2000.0f) <= r.getSecondOptionalChance()) {
                this.addItem(sia, r.getSecondOptionalOutput());
            }
            this.func_70299_a(6, null);
        }
    }

    private void addItem(InventoryAdaptor sia, ItemStack output) {
        if (output == null) {
            return;
        }
        ItemStack notAdded = sia.addItems(output);
        if (notAdded != null) {
            WorldCoord wc = new WorldCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            wc.add(this.getForward(), 1);
            ArrayList<ItemStack> out = new ArrayList<ItemStack>();
            out.add(notAdded);
            Platform.spawnDrops(this.field_145850_b, wc.x, wc.y, wc.z, out);
        }
    }

    @Override
    public boolean canCrankAttach(ForgeDirection directionToCrank) {
        return this.getUp() == directionToCrank;
    }
}

