/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.GuiHandler;
import forestry.core.gui.IGuiHandlerEntity;
import forestry.core.gui.IHintSource;
import forestry.core.tiles.ITitled;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;

public abstract class EntityMinecartForestry
extends EntityMinecart
implements ITitled,
IRestrictedAccess,
IHintSource,
IGuiHandlerEntity {
    private final AccessHandler accessHandler = new AccessHandler(this);

    public EntityMinecartForestry(World world) {
        super(world);
        this.func_94096_e(true);
    }

    public EntityMinecartForestry(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.func_94096_e(true);
    }

    public final boolean func_130002_c(EntityPlayer player) {
        if (MinecraftForge.EVENT_BUS.post((Event)new MinecartInteractEvent((EntityMinecart)this, player))) {
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            GuiHandler.openGui(player, this);
        }
        return true;
    }

    public void setOwner(GameProfile owner) {
        this.accessHandler.setOwner(owner);
    }

    public int func_94087_l() {
        return -1;
    }

    protected void func_70037_a(NBTTagCompound nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        this.accessHandler.readFromNBT(nbtTagCompound);
    }

    protected void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        this.accessHandler.writeToNBT(nbtTagCompound);
    }

    public boolean canBeRidden() {
        return false;
    }

    public abstract Block func_145820_n();

    public abstract int func_94098_o();

    public abstract ItemStack getCartItem();

    public void func_94095_a(DamageSource damageSource) {
        super.func_94095_a(damageSource);
        this.func_70099_a(new ItemStack(this.func_145820_n(), 1, this.func_94098_o()), 0.0f);
    }

    public float func_70013_c(float p_70013_1_) {
        return 1.0f;
    }

    public String func_70005_c_() {
        return StatCollector.func_74838_a((String)this.getUnlocalizedTitle());
    }

    @Override
    public String getUnlocalizedTitle() {
        ItemStack cartItem = this.getCartItem();
        return cartItem.func_77977_a() + ".name";
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
    }
}

